/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.ui.dashboard.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.bridge.ui.dashboard.DashboardAction;
import org.eclipse.gmf.bridge.ui.dashboard.DashboardFacade;
import org.eclipse.gmf.bridge.ui.dashboard.DashboardState;
import org.eclipse.gmf.internal.bridge.transform.TransformOptions;
import org.eclipse.gmf.internal.bridge.transform.TransformToGenModelOperation;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;

public class TransformMap2GenModelAction
implements DashboardAction {
    private DashboardFacade context;

    public void init(DashboardFacade context) {
        this.context = context;
    }

    public boolean isEnabled() {
        DashboardState state = this.context.getState();
        if (this.context.isStrict() && (state.getDM() == null || state.getDGM() == null || state.getTDM() == null)) {
            return false;
        }
        return state.getMM() != null;
    }

    public void run() {
        IStatus result;
        block6: {
            DashboardState state = this.context.getState();
            URI mm = state.getMM();
            URI gm = state.getGM();
            if (gm == null) {
                gm = mm.trimFileExtension().appendFileExtension("gmfgen");
                state.setGM(gm);
            }
            result = Status.OK_STATUS;
            try {
                try {
                    ResourceSetImpl rs = new ResourceSetImpl();
                    TransformToGenModelOperation op = new TransformToGenModelOperation((ResourceSet)rs);
                    this.configureOptions(op.getOptions());
                    op.loadMappingModel(mm, (IProgressMonitor)new NullProgressMonitor());
                    op.loadGenModel(state.getDGM(), (IProgressMonitor)new NullProgressMonitor());
                    op.setGenURI(gm);
                    result = op.executeTransformation((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException ce) {
                    result = ce.getStatus();
                    this.context.updateStatus();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.context.updateStatus();
                throw throwable;
            }
            this.context.updateStatus();
        }
        ErrorDialog.openError((Shell)this.context.getShell(), null, null, (IStatus)result, (int)6);
    }

    protected void configureOptions(TransformOptions options) {
        options.setUseRuntimeFigures(true);
        options.setUseMapMode(true);
        options.setGenerateRCP(this.context.getState().getOption("rcp"));
    }
}

