/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.popup.actions;

import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.internal.codegen.popup.actions.DiagnosticsDialog;
import org.eclipse.gmf.internal.codegen.popup.actions.ErrorDialogEx;
import org.eclipse.gmf.internal.codegen.popup.actions.Messages;
import org.eclipse.gmf.internal.common.migrate.MigrationUtil;
import org.eclipse.gmf.internal.common.migrate.ModelLoadHelper;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class MigrateModelAction
implements IObjectActionDelegate {
    private IFile fileSelection;
    private IWorkbenchPart wrkbenchPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.wrkbenchPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fileSelection = null;
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        this.fileSelection = (IFile)((IStructuredSelection)selection).getFirstElement();
        action.setEnabled(true);
    }

    public void run(IAction action) {
        boolean overwrite;
        IFile modelFile = this.fileSelection;
        URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
        ModelLoadHelper loadHelper = MigrationUtil.migrateModel((URI)fileURI);
        if (!loadHelper.isOK()) {
            DiagnosticsDialog.openOk(this.getShell(), action.getText(), Messages.migration_problemsDetectedTitle, loadHelper.getDiagnostics());
            return;
        }
        String modelExtension = modelFile.getFileExtension();
        IPath destPath = modelFile.getFullPath().removeFileExtension().addFileExtension(modelExtension);
        InputDialog dlg = new InputDialog(this.getShell(), Messages.migration_modelDestinationFileTitle, Messages.migration_specifyFileNameLabel, destPath.lastSegment(), new IInputValidator(){

            public String isValid(String newText) {
                IStatus fileNameStatus = ResourcesPlugin.getWorkspace().validateName(newText, 1);
                return fileNameStatus.isOK() ? null : fileNameStatus.getMessage();
            }
        });
        if (dlg.open() != 0) {
            return;
        }
        Resource resource = loadHelper.getLoadedResource();
        String destFileName = dlg.getValue();
        if (this.fileSelection.getParent().findMember(destFileName) != null && !(overwrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.migration_confirmModelOverwriteTitle, (String)NLS.bind((String)Messages.migration_confirmModelOverwriteMessage, (Object)destFileName)))) {
            return;
        }
        URI migratedURI = fileURI.trimSegments(1).appendSegment(destFileName);
        resource.setURI(migratedURI);
        IStatus saveStatus = Status.OK_STATUS;
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (Exception e) {
            saveStatus = BasicDiagnostic.toIStatus((Diagnostic)BasicDiagnostic.toDiagnostic((Throwable)e));
        }
        this.openErrorDialog(action.getText(), Messages.migration_destinationModelSaveError, saveStatus);
    }

    private void openErrorDialog(String title, String message, IStatus errorStatus) {
        String[] buttons = new String[]{IDialogConstants.OK_LABEL};
        int[] buttonIDs = new int[1];
        ErrorDialogEx dlg = new ErrorDialogEx(this.getShell(), title, message, errorStatus, buttons, buttonIDs, 0);
        dlg.open();
    }

    private Shell getShell() {
        return this.wrkbenchPart.getSite().getShell();
    }
}

