/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.metrics.tck.application.cdi;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import org.eclipse.microprofile.telemetry.metrics.tck.application.TestLibraries;
import org.eclipse.microprofile.telemetry.metrics.tck.application.TestUtils;
import org.eclipse.microprofile.telemetry.metrics.tck.application.exporter.InMemoryMetricExporter;
import org.eclipse.microprofile.telemetry.metrics.tck.application.exporter.InMemoryMetricExporterProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LongUpDownCounterTest
extends Arquillian {
    private static final String counterName = "testLongUpDownCounter";
    private static final String counterDescription = "Testing long up down counter";
    private static final String counterUnit = "Metric Tonnes";
    private static final long LONG_WITH_ATTRIBUTES = -20L;
    private static final long LONG_WITHOUT_ATTRIBUTES = -10L;
    @Inject
    private Meter sdkMeter;
    @Inject
    private InMemoryMetricExporter metricExporter;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{InMemoryMetricExporter.class, InMemoryMetricExporterProvider.class, TestUtils.class})).addAsLibrary((Archive)TestLibraries.AWAITILITY_LIB)).addAsServiceProvider(ConfigurableMetricExporterProvider.class, new Class[]{InMemoryMetricExporterProvider.class})).addAsResource((Asset)new StringAsset("otel.sdk.disabled=false\notel.metrics.exporter=in-memory\notel.logs.exporter=none\notel.traces.exporter=none\notel.metric.export.interval=3000"), "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @BeforeMethod
    void setUp() {
        if (this.metricExporter != null) {
            this.metricExporter.reset();
        }
    }

    @Test
    void testLongUpDownCounter() throws InterruptedException {
        LongUpDownCounter longUpDownCounter = this.sdkMeter.upDownCounterBuilder(counterName).setDescription(counterDescription).setUnit(counterUnit).build();
        Assert.assertNotNull((Object)longUpDownCounter);
        HashMap<Long, Attributes> expectedResults = new HashMap<Long, Attributes>();
        expectedResults.put(-20L, Attributes.builder().put("K", "V").build());
        expectedResults.put(-10L, Attributes.empty());
        expectedResults.keySet().stream().forEach(key -> longUpDownCounter.add(key.longValue(), (Attributes)expectedResults.get(key)));
        List<MetricData> metrics = this.metricExporter.getMetricData(counterName);
        metrics.stream().peek(metricData -> {
            Assert.assertEquals((Object)metricData.getType(), (Object)MetricDataType.LONG_SUM);
            Assert.assertEquals((String)metricData.getDescription(), (String)counterDescription);
            Assert.assertEquals((String)metricData.getUnit(), (String)counterUnit);
        }).flatMap(metricData -> metricData.getLongSumData().getPoints().stream()).forEach(point -> {
            Assert.assertTrue((boolean)expectedResults.containsKey(point.getValue()), (String)("Long" + point.getValue() + " was not an expected result"));
            Assert.assertTrue((boolean)point.getAttributes().equals(expectedResults.get(point.getValue())), (String)("Attributes were not equal." + System.lineSeparator() + "Actual values: " + TestUtils.mapToString(point.getAttributes().asMap()) + System.lineSeparator() + "Expected values: " + TestUtils.mapToString(((Attributes)expectedResults.get(point.getValue())).asMap())));
        });
    }
}

