/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.arquillian;

import jakarta.inject.Inject;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.reactive.streams.operators.tck.ReactiveStreamsTck;
import org.eclipse.microprofile.reactive.streams.operators.tck.arquillian.ReactiveStreamsCdiTck;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.reactivestreams.example.unicast.AsyncIterablePublisher;
import org.reactivestreams.tck.TestEnvironment;
import org.testng.IClassListener;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestObjectFactory;
import org.testng.ITestResult;
import org.testng.TestNG;
import org.testng.annotations.Test;

public class ReactiveStreamsArquillianTck
extends Arquillian {
    @Inject
    private ReactiveStreamsCdiTck tck;

    @Deployment
    public static JavaArchive tckDeployment() {
        return (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackages(true, new Package[]{ReactiveStreamsTck.class.getPackage()})).addPackages(true, new Package[]{TestEnvironment.class.getPackage()})).addPackages(true, new Package[]{AsyncIterablePublisher.class.getPackage()})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void runAllTckTests() throws Throwable {
        TestNG testng = new TestNG();
        testng.setObjectFactory((ITestObjectFactory)new TCKObjectFactory());
        testng.setUseDefaultListeners(false);
        ResultListener resultListener = new ResultListener();
        testng.addListener((ITestNGListener)resultListener);
        testng.setTestClasses(new Class[]{ReactiveStreamsCdiTck.class});
        testng.setMethodInterceptor(new IMethodInterceptor(){

            public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
                methods.sort(Comparator.comparing(m -> m.getInstance().getClass().getName()));
                return methods;
            }
        });
        testng.run();
        int total = resultListener.success.get() + resultListener.failed.get() + resultListener.skipped.get();
        System.out.println(String.format("Ran %d tests, %d passed, %d failed, %d skipped.", total, resultListener.success.get(), resultListener.failed.get(), resultListener.skipped.get()));
        System.out.println("Failed tests:");
        resultListener.failures.forEach(result -> System.out.println(result.getInstance().getClass().getName() + "." + result.getMethod().getMethodName()));
        if (resultListener.failed.get() > 0) {
            if (resultListener.lastFailure.get() != null) {
                throw (Throwable)resultListener.lastFailure.get();
            }
            throw new Exception("Tests failed with no exception");
        }
    }

    private class TCKObjectFactory
    implements ITestObjectFactory {
        private TCKObjectFactory() {
        }

        public <T> T newInstance(Class<T> cls, Object ... parameters) {
            if (cls.equals(ReactiveStreamsCdiTck.class)) {
                return (T)ReactiveStreamsArquillianTck.this.tck;
            }
            return (T)super.newInstance(cls, parameters);
        }

        public <T> T newInstance(String clsName, Object ... parameters) {
            if (clsName.equals(ReactiveStreamsCdiTck.class.getName())) {
                return (T)ReactiveStreamsArquillianTck.this.tck;
            }
            return (T)super.newInstance(clsName, parameters);
        }

        public <T> T newInstance(Constructor<T> constructor, Object ... parameters) {
            if (constructor.getDeclaringClass().equals(ReactiveStreamsCdiTck.class)) {
                return (T)ReactiveStreamsArquillianTck.this.tck;
            }
            return (T)super.newInstance(constructor, parameters);
        }
    }

    private static class ResultListener
    implements IClassListener,
    ITestListener {
        private final AtomicInteger success = new AtomicInteger();
        private final AtomicInteger failed = new AtomicInteger();
        private final AtomicInteger skipped = new AtomicInteger();
        private final AtomicReference<Throwable> lastFailure = new AtomicReference();
        private final List<ITestResult> failures = Collections.synchronizedList(new ArrayList());

        private ResultListener() {
        }

        public void onBeforeClass(ITestClass testClass) {
            System.out.println(testClass.getName() + ":");
        }

        public void onAfterClass(ITestClass testClass) {
        }

        public void onTestStart(ITestResult result) {
        }

        public void onTestSuccess(ITestResult result) {
            ResultListener.printResult(result, "SUCCESS");
            this.success.incrementAndGet();
        }

        public void onTestFailure(ITestResult result) {
            ResultListener.printResult(result, "FAILED");
            if (result.getThrowable() != null) {
                result.getThrowable().printStackTrace(System.out);
                this.lastFailure.set(result.getThrowable());
            }
            this.failures.add(result);
            this.failed.incrementAndGet();
        }

        public void onTestSkipped(ITestResult result) {
            ResultListener.printResult(result, "SKIPPED");
            this.skipped.incrementAndGet();
        }

        public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        }

        public void onStart(ITestContext context) {
        }

        public void onFinish(ITestContext context) {
        }

        private static void printResult(ITestResult result, String status) {
            String methodName = String.format("%-100s", result.getMethod().getMethodName()).replace(' ', '.');
            System.out.println(" - " + methodName + "." + status);
        }
    }
}

