/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences.DirectoryValidator;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences.ListEditor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences.LocalRemoteDirectoryEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PathPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String REMOTE = "remote";
    public static final String LOCAL = "local";
    private LocalRemoteDirectoryEditor directoryEditor;

    public PathPreferencePage() {
        super(1);
        this.setPreferenceStore(IDEPlugin.getDefault().getPreferenceStore());
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        String[][] labels = new String[][]{{Localization.getString("PathPreferencePage.LocalMachine"), LOCAL}, {Localization.getString("PathPreferencePage.RemoteMachine"), REMOTE}};
        RadioGroupFieldEditor radioEditor = new RadioGroupFieldEditor("RemoteLocalKernelSource", Localization.getString("PathPreferencePage.RemoteOrLocalRadio"), 1, labels, parent, true){

            protected void fireValueChanged(String property, Object oldValue, Object newValue) {
                super.fireValueChanged(property, oldValue, newValue);
                if (!oldValue.equals(newValue) && PathPreferencePage.this.directoryEditor != null) {
                    if (newValue.equals(PathPreferencePage.REMOTE)) {
                        PathPreferencePage.this.directoryEditor.setRemote(true, PathPreferencePage.this.getFieldEditorParent());
                    } else {
                        PathPreferencePage.this.directoryEditor.setRemote(false, PathPreferencePage.this.getFieldEditorParent());
                    }
                }
            }
        };
        this.addField((FieldEditor)radioEditor);
        IPreferenceStore p = IDEPlugin.getDefault().getPreferenceStore();
        String remoteOrLocal = p.getString("RemoteLocalKernelSource");
        boolean remote = remoteOrLocal.equals(REMOTE);
        this.directoryEditor = new LocalRemoteDirectoryEditor("KernelSourcePreference", Localization.getString("PathPreferencePage.KernelSourceDirectory"), parent, remote);
        this.addField((FieldEditor)this.directoryEditor);
        this.addField((FieldEditor)new ListEditor("ExcludedKernelSource", Localization.getString("PathPreferencePage.ExcludedSourceFolders"), Localization.getString("PathPreferencePage.ExcludedDirectory"), "", new DirectoryValidator(), parent));
    }

    public void init(IWorkbench workbench) {
    }
}

