/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.docker.core.IDockerBlkioDeviceRate;
import org.eclipse.linuxtools.docker.core.IDockerBlkioWeightDevice;
import org.eclipse.linuxtools.docker.core.IDockerConfParameter;
import org.eclipse.linuxtools.docker.core.IDockerDevice;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerLogConfig;
import org.eclipse.linuxtools.docker.core.IDockerPortBinding;
import org.eclipse.linuxtools.docker.core.IDockerRestartPolicy;
import org.eclipse.linuxtools.docker.core.IDockerUlimit;
import org.eclipse.linuxtools.internal.docker.core.DockerBlkioDeviceRate;
import org.eclipse.linuxtools.internal.docker.core.DockerBlkioWeightDevice;
import org.eclipse.linuxtools.internal.docker.core.DockerConfParameter;
import org.eclipse.linuxtools.internal.docker.core.DockerDevice;
import org.eclipse.linuxtools.internal.docker.core.DockerLogConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerPortBinding;
import org.eclipse.linuxtools.internal.docker.core.DockerRestartPolicy;
import org.eclipse.linuxtools.internal.docker.core.DockerUlimit;
import org.mandas.docker.client.messages.Device;
import org.mandas.docker.client.messages.HostConfig;
import org.mandas.docker.client.messages.PortBinding;

public class DockerHostConfig
implements IDockerHostConfig {
    private final List<String> binds;
    private final String containerIDFile;
    private final List<IDockerConfParameter> lxcConf;
    private final boolean privileged;
    private final boolean readonlyRootfs;
    private final Map<String, String> tmpfs;
    private final Map<String, List<IDockerPortBinding>> portBindings;
    private final List<String> links;
    private final boolean publishAllPorts;
    private final List<String> dns;
    private final List<String> dnsSearch;
    private final List<String> dnsOptions;
    private final List<String> extraHosts;
    private final List<IDockerDevice> devices;
    private final List<String> volumesFrom;
    private final List<String> securityOpt;
    private final List<String> capAdd;
    private final List<String> capDrop;
    private final String networkMode;
    private final String cgroupParent;
    private final Long memory;
    private final Long cpuShares;
    private final Long memorySwap;
    private final Integer memorySwappiness;
    private final Long memoryReservation;
    private final Long nanoCpus;
    private final Long cpuPeriod;
    private final String cpusetCpus;
    private final String cpusetMems;
    private final Long cpuQuota;
    private final String ipcMode;
    private final String pidMode;
    private final Long shmSize;
    private final boolean oomKillDisable;
    private final Integer oomScoreAdj;
    private final boolean autoRemove;
    private final Integer pidsLimit;
    private final IDockerRestartPolicy restartPolicy;
    private final List<IDockerUlimit> ulimits;
    private final IDockerLogConfig logConfig;
    private final Map<String, String> storageOpt;
    private final Integer blkioWeight;
    private final List<IDockerBlkioWeightDevice> blkioWeightDevice;
    private final List<IDockerBlkioDeviceRate> blkioDeviceReadBps;
    private final List<IDockerBlkioDeviceRate> blkioDeviceWriteBps;
    private final List<IDockerBlkioDeviceRate> blkioDeviceReadIOps;
    private final List<IDockerBlkioDeviceRate> blkioDeviceWriteIOps;

    public DockerHostConfig(HostConfig hostConfig) {
        this.binds = hostConfig.binds();
        this.containerIDFile = hostConfig.containerIdFile();
        this.lxcConf = new ArrayList<IDockerConfParameter>();
        if (hostConfig.lxcConf() != null) {
            for (HostConfig.LxcConfParameter lxcConfParameter : hostConfig.lxcConf()) {
                this.lxcConf.add(new DockerConfParameter(lxcConfParameter));
            }
        }
        this.privileged = hostConfig.privileged() != null ? hostConfig.privileged() : false;
        this.readonlyRootfs = hostConfig.readonlyRootfs() != null ? hostConfig.readonlyRootfs() : false;
        this.tmpfs = hostConfig.tmpfs();
        this.portBindings = new HashMap<String, List<IDockerPortBinding>>();
        if (hostConfig != null && hostConfig.portBindings() != null) {
            for (Map.Entry entry : hostConfig.portBindings().entrySet()) {
                ArrayList<DockerPortBinding> portBindings = new ArrayList<DockerPortBinding>();
                for (PortBinding portBinding : (List)entry.getValue()) {
                    portBindings.add(new DockerPortBinding(portBinding));
                }
                this.portBindings.put((String)entry.getKey(), portBindings);
            }
        }
        this.links = hostConfig.links();
        this.publishAllPorts = hostConfig.publishAllPorts() != null ? hostConfig.publishAllPorts() : false;
        this.dns = hostConfig.dns();
        this.dnsSearch = hostConfig.dnsSearch();
        this.volumesFrom = hostConfig.volumesFrom();
        this.networkMode = hostConfig.networkMode();
        this.memory = hostConfig.memory();
        this.cpuShares = hostConfig.cpuShares();
        this.securityOpt = hostConfig.securityOpt();
        this.capAdd = hostConfig.capAdd();
        this.capDrop = hostConfig.capDrop();
        this.dnsOptions = hostConfig.dnsOptions();
        this.extraHosts = hostConfig.extraHosts();
        this.devices = new ArrayList<IDockerDevice>();
        if (hostConfig != null && hostConfig.devices() != null) {
            for (Device device : hostConfig.devices()) {
                this.devices.add(new DockerDevice(device));
            }
        }
        this.cgroupParent = hostConfig.cgroupParent();
        this.memorySwap = hostConfig.memorySwap();
        this.memorySwappiness = hostConfig.memorySwappiness();
        this.memoryReservation = hostConfig.memoryReservation();
        this.nanoCpus = hostConfig.nanoCpus();
        this.cpuPeriod = hostConfig.cpuPeriod();
        this.cpusetCpus = hostConfig.cpusetCpus();
        this.cpusetMems = hostConfig.cpusetMems();
        this.cpuQuota = hostConfig.cpuQuota();
        this.ipcMode = hostConfig.ipcMode();
        this.pidMode = hostConfig.pidMode();
        this.shmSize = hostConfig.shmSize();
        this.oomKillDisable = hostConfig.oomKillDisable() != null ? hostConfig.oomKillDisable() : false;
        this.oomScoreAdj = hostConfig.oomScoreAdj();
        this.autoRemove = hostConfig.autoRemove() != null ? hostConfig.autoRemove() : false;
        this.pidsLimit = hostConfig.pidsLimit();
        this.restartPolicy = hostConfig.restartPolicy() != null ? new DockerRestartPolicy(hostConfig.restartPolicy()) : null;
        this.ulimits = new ArrayList<IDockerUlimit>();
        if (hostConfig.ulimits() != null) {
            for (HostConfig.Ulimit ulimit : hostConfig.ulimits()) {
                this.ulimits.add(new DockerUlimit(ulimit));
            }
        }
        this.logConfig = hostConfig.logConfig() != null ? new DockerLogConfig(hostConfig.logConfig()) : null;
        this.storageOpt = hostConfig.storageOpt();
        this.blkioWeight = hostConfig.blkioWeight();
        this.blkioWeightDevice = new ArrayList<IDockerBlkioWeightDevice>();
        if (hostConfig.blkioWeightDevice() != null) {
            for (HostConfig.BlkioWeightDevice blkioWeightDevice : hostConfig.blkioWeightDevice()) {
                this.blkioWeightDevice.add(new DockerBlkioWeightDevice(blkioWeightDevice));
            }
        }
        this.blkioDeviceReadBps = new ArrayList<IDockerBlkioDeviceRate>();
        if (hostConfig.blkioDeviceReadBps() != null) {
            for (HostConfig.BlkioDeviceRate blkioDeviceRate : hostConfig.blkioDeviceReadBps()) {
                this.blkioDeviceReadBps.add(new DockerBlkioDeviceRate(blkioDeviceRate));
            }
        }
        this.blkioDeviceWriteBps = new ArrayList<IDockerBlkioDeviceRate>();
        if (hostConfig.blkioDeviceReadBps() != null) {
            for (HostConfig.BlkioDeviceRate blkioDeviceRate : hostConfig.blkioDeviceWriteBps()) {
                this.blkioDeviceWriteBps.add(new DockerBlkioDeviceRate(blkioDeviceRate));
            }
        }
        this.blkioDeviceReadIOps = new ArrayList<IDockerBlkioDeviceRate>();
        if (hostConfig.blkioDeviceReadBps() != null) {
            for (HostConfig.BlkioDeviceRate blkioDeviceRate : hostConfig.blkioDeviceReadIOps()) {
                this.blkioDeviceReadIOps.add(new DockerBlkioDeviceRate(blkioDeviceRate));
            }
        }
        this.blkioDeviceWriteIOps = new ArrayList<IDockerBlkioDeviceRate>();
        if (hostConfig.blkioDeviceReadBps() != null) {
            for (HostConfig.BlkioDeviceRate blkioDeviceRate : hostConfig.blkioDeviceWriteIOps()) {
                this.blkioDeviceWriteIOps.add(new DockerBlkioDeviceRate(blkioDeviceRate));
            }
        }
    }

    private DockerHostConfig(Builder builder) {
        this.binds = builder.binds;
        this.containerIDFile = builder.containerIDFile;
        this.lxcConf = builder.lxcConf;
        this.privileged = builder.privileged != null ? builder.privileged : false;
        this.readonlyRootfs = builder.readonlyRootfs != null ? builder.readonlyRootfs : false;
        this.tmpfs = builder.tmpfs;
        this.portBindings = builder.portBindings;
        this.links = builder.links;
        this.publishAllPorts = builder.publishAllPorts != null ? builder.publishAllPorts : false;
        this.dns = builder.dns;
        this.dnsSearch = builder.dnsSearch;
        this.volumesFrom = builder.volumesFrom;
        this.networkMode = builder.networkMode;
        this.memory = builder.memory;
        this.cpuShares = builder.cpuShares;
        this.securityOpt = builder.securityOpt;
        this.capAdd = builder.capAdd;
        this.capDrop = builder.capDrop;
        this.dnsOptions = builder.dnsOptions;
        this.extraHosts = builder.extraHosts;
        this.devices = builder.devices;
        this.cgroupParent = builder.cgroupParent;
        this.memorySwap = builder.memorySwap;
        this.memorySwappiness = builder.memorySwappiness;
        this.memoryReservation = builder.memoryReservation;
        this.nanoCpus = builder.nanoCpus;
        this.cpuPeriod = builder.cpuPeriod;
        this.cpusetCpus = builder.cpusetCpus;
        this.cpusetMems = builder.cpusetMems;
        this.cpuQuota = builder.cpuQuota;
        this.ipcMode = builder.ipcMode;
        this.pidMode = builder.pidMode;
        this.shmSize = builder.shmSize;
        this.oomKillDisable = builder.oomKillDisable != null ? builder.oomKillDisable : false;
        this.oomScoreAdj = builder.oomScoreAdj;
        this.autoRemove = builder.autoRemove != null ? builder.autoRemove : false;
        this.pidsLimit = builder.pidsLimit;
        this.restartPolicy = builder.restartPolicy;
        this.ulimits = builder.ulimits;
        this.logConfig = builder.logConfig;
        this.storageOpt = builder.storageOpt;
        this.blkioWeight = builder.blkioWeight;
        this.blkioWeightDevice = builder.blkioWeightDevice;
        this.blkioDeviceReadBps = builder.blkioDeviceReadBps;
        this.blkioDeviceWriteBps = builder.blkioDeviceWriteBps;
        this.blkioDeviceReadIOps = builder.blkioDeviceReadIOps;
        this.blkioDeviceWriteIOps = builder.blkioDeviceWriteIOps;
    }

    @Override
    public List<String> binds() {
        return this.binds;
    }

    @Override
    public String containerIDFile() {
        return this.containerIDFile;
    }

    @Override
    public List<IDockerConfParameter> lxcConf() {
        return this.lxcConf;
    }

    @Override
    public boolean privileged() {
        return this.privileged;
    }

    public boolean readonlyRootfs() {
        return this.readonlyRootfs;
    }

    public Map<String, String> tmpfs() {
        return this.tmpfs;
    }

    @Override
    public Map<String, List<IDockerPortBinding>> portBindings() {
        return this.portBindings;
    }

    @Override
    public List<String> links() {
        return this.links;
    }

    @Override
    public boolean publishAllPorts() {
        return this.publishAllPorts;
    }

    @Override
    public List<String> dns() {
        return this.dns;
    }

    @Override
    public List<String> dnsSearch() {
        return this.dnsSearch;
    }

    public List<String> dnsOptions() {
        return this.dnsOptions;
    }

    public List<IDockerDevice> devices() {
        return this.devices;
    }

    @Override
    public List<String> volumesFrom() {
        return this.volumesFrom;
    }

    @Override
    public List<String> securityOpt() {
        return this.securityOpt;
    }

    public List<String> capAdd() {
        return this.capAdd;
    }

    public List<String> capDrop() {
        return this.capDrop;
    }

    public List<String> extraHosts() {
        return this.extraHosts;
    }

    public String cgroupParent() {
        return this.cgroupParent;
    }

    @Override
    public String networkMode() {
        return this.networkMode;
    }

    public Long memory() {
        return this.memory;
    }

    public Long cpuShares() {
        return this.cpuShares;
    }

    public Long memorySwap() {
        return this.memorySwap;
    }

    public Integer memorySwappiness() {
        return this.memorySwappiness;
    }

    public Long memoryReservation() {
        return this.memoryReservation;
    }

    public Long nanoCpus() {
        return this.nanoCpus;
    }

    public Long cpuPeriod() {
        return this.cpuPeriod;
    }

    public String cpusetCpus() {
        return this.cpusetCpus;
    }

    public String cpusetMems() {
        return this.cpusetMems;
    }

    public Long cpuQuota() {
        return this.cpuQuota;
    }

    public String ipcMode() {
        return this.ipcMode;
    }

    public String pidMode() {
        return this.pidMode;
    }

    public Long shmSize() {
        return this.shmSize;
    }

    public boolean oomKillDisable() {
        return this.oomKillDisable;
    }

    public Integer oomScoreAdj() {
        return this.oomScoreAdj;
    }

    public boolean autoRemove() {
        return this.autoRemove;
    }

    public Integer pidsLimit() {
        return this.pidsLimit;
    }

    public IDockerRestartPolicy restartPolicy() {
        return this.restartPolicy;
    }

    public List<IDockerUlimit> ulimits() {
        return this.ulimits;
    }

    public IDockerLogConfig logConfig() {
        return this.logConfig;
    }

    public Map<String, String> storageOpt() {
        return this.storageOpt;
    }

    public Integer blkioWeight() {
        return this.blkioWeight;
    }

    public List<IDockerBlkioWeightDevice> blkioWeightDevice() {
        return this.blkioWeightDevice;
    }

    public List<IDockerBlkioDeviceRate> blkioDeviceReadBps() {
        return this.blkioDeviceReadBps;
    }

    public List<IDockerBlkioDeviceRate> blkioDeviceWriteBps() {
        return this.blkioDeviceWriteBps;
    }

    public List<IDockerBlkioDeviceRate> blkioDeviceReadIOps() {
        return this.blkioDeviceReadIOps;
    }

    public List<IDockerBlkioDeviceRate> blkioDeviceWriteIOps() {
        return this.blkioDeviceWriteIOps;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> binds;
        private String containerIDFile;
        private List<IDockerConfParameter> lxcConf;
        private Boolean privileged;
        private Boolean readonlyRootfs;
        private Map<String, String> tmpfs;
        private Map<String, List<IDockerPortBinding>> portBindings;
        private List<String> links;
        private Boolean publishAllPorts;
        private List<String> dns = new ArrayList<String>();
        private List<String> dnsSearch = new ArrayList<String>();
        private List<String> volumesFrom;
        private List<String> securityOpt;
        private List<String> capAdd;
        private List<String> capDrop;
        private List<String> dnsOptions = new ArrayList<String>();
        private List<String> extraHosts;
        private List<IDockerDevice> devices = new ArrayList<IDockerDevice>();
        private String cgroupParent = "";
        private String networkMode;
        private Long memory;
        private Long cpuShares;
        private Long memorySwap;
        private Integer memorySwappiness;
        private Long memoryReservation;
        private Long nanoCpus;
        private Long cpuPeriod;
        private String cpusetCpus = "";
        private String cpusetMems = "";
        private Long cpuQuota;
        private String ipcMode = "";
        private String pidMode = "";
        private Long shmSize;
        private Boolean oomKillDisable;
        private Integer oomScoreAdj;
        private Boolean autoRemove;
        private Integer pidsLimit;
        private IDockerRestartPolicy restartPolicy;
        private List<IDockerUlimit> ulimits;
        private IDockerLogConfig logConfig;
        private Map<String, String> storageOpt;
        private Integer blkioWeight;
        private List<IDockerBlkioWeightDevice> blkioWeightDevice;
        private List<IDockerBlkioDeviceRate> blkioDeviceReadBps;
        private List<IDockerBlkioDeviceRate> blkioDeviceWriteBps;
        private List<IDockerBlkioDeviceRate> blkioDeviceReadIOps;
        private List<IDockerBlkioDeviceRate> blkioDeviceWriteIOps;

        public Builder binds(List<String> binds) {
            this.binds = new ArrayList<String>(binds);
            return this;
        }

        public Builder binds(String ... binds) {
            this.binds = Arrays.asList(binds);
            return this;
        }

        public List<String> binds() {
            return this.binds;
        }

        public Builder containerIDFile(String containerIDFile) {
            this.containerIDFile = containerIDFile;
            return this;
        }

        public Builder lxcConf(List<IDockerConfParameter> lxcConf) {
            this.lxcConf = new ArrayList<IDockerConfParameter>(lxcConf);
            return this;
        }

        public Builder lxcConf(IDockerConfParameter ... lxcConf) {
            this.lxcConf = Arrays.asList(lxcConf);
            return this;
        }

        public Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public Builder readonlyRootfs(Boolean readonlyRootfs) {
            this.readonlyRootfs = readonlyRootfs;
            return this;
        }

        public Builder tmpfs(Map<String, String> tmpfs) {
            this.tmpfs = tmpfs;
            return this;
        }

        public Map<String, String> tmpfs() {
            return this.tmpfs;
        }

        public Builder portBindings(Map<String, List<IDockerPortBinding>> portBindings) {
            this.portBindings = portBindings;
            return this;
        }

        public Builder links(List<String> links) {
            this.links = new ArrayList<String>(links);
            return this;
        }

        public Builder links(String ... links) {
            this.links = Arrays.asList(links);
            return this;
        }

        public Builder publishAllPorts(Boolean publishAllPorts) {
            this.publishAllPorts = publishAllPorts;
            return this;
        }

        public Builder volumesFrom(List<String> volumesFrom) {
            this.volumesFrom = new ArrayList<String>(volumesFrom);
            return this;
        }

        public Builder volumesFrom(String ... volumesFrom) {
            this.volumesFrom = Arrays.asList(volumesFrom);
            return this;
        }

        public Builder securityOpt(List<String> securityOpt) {
            this.securityOpt = new ArrayList<String>(securityOpt);
            return this;
        }

        public Builder securityOpt(String ... securityOpt) {
            this.securityOpt = Arrays.asList(securityOpt);
            return this;
        }

        public Builder capAdd(List<String> capAdd) {
            this.capAdd = new ArrayList<String>(capAdd);
            return this;
        }

        public Builder capAdd(String ... capAdd) {
            this.capAdd = Arrays.asList(capAdd);
            return this;
        }

        public Builder capDrop(List<String> capDrop) {
            this.capDrop = new ArrayList<String>(capDrop);
            return this;
        }

        public Builder capDrop(String ... capDrop) {
            this.capDrop = Arrays.asList(capDrop);
            return this;
        }

        public Builder dns(List<String> dns) {
            this.dns = new ArrayList<String>(dns);
            return this;
        }

        public Builder dns(String ... dns) {
            this.dns = Arrays.asList(dns);
            return this;
        }

        public Builder dnsOptions(List<String> dnsOptions) {
            this.dnsOptions = new ArrayList<String>(dnsOptions);
            return this;
        }

        public Builder dnsOptions(String ... dnsOptions) {
            this.dnsOptions = Arrays.asList(dnsOptions);
            return this;
        }

        public Builder dnsSearch(List<String> dnsSearch) {
            this.dnsSearch = new ArrayList<String>(dnsSearch);
            return this;
        }

        public Builder dnsSearch(String ... dnsSearch) {
            this.dnsSearch = Arrays.asList(dnsSearch);
            return this;
        }

        public Builder extraHosts(List<String> extraHosts) {
            this.extraHosts = new ArrayList<String>(extraHosts);
            return this;
        }

        public Builder extraHosts(String ... extraHosts) {
            this.extraHosts = Arrays.asList(extraHosts);
            return this;
        }

        public Builder devices(List<IDockerDevice> devices) {
            this.devices = new ArrayList<IDockerDevice>(devices);
            return this;
        }

        public Builder cgroupParent(String cgroupParent) {
            this.cgroupParent = cgroupParent;
            return this;
        }

        public Builder networkMode(String networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        public Builder memory(Long memory) {
            this.memory = memory;
            return this;
        }

        public Builder cpuShares(Long cpuShares) {
            this.cpuShares = cpuShares;
            return this;
        }

        public Builder memorySwap(Long memorySwap) {
            this.memorySwap = memorySwap;
            return this;
        }

        public Builder memorySwappiness(Integer memorySwappiness) {
            this.memorySwappiness = memorySwappiness;
            return this;
        }

        public Builder memoryReservation(Long memoryReservation) {
            this.memoryReservation = memoryReservation;
            return this;
        }

        public Builder nanoCpus(Long nanoCpus) {
            this.nanoCpus = nanoCpus;
            return this;
        }

        public Builder cpuPeriod(Long cpuPeriod) {
            this.cpuPeriod = cpuPeriod;
            return this;
        }

        public Builder cpusetCpus(String cpusetCpus) {
            this.cpusetCpus = cpusetCpus;
            return this;
        }

        public Builder cpusetMems(String cpusetMems) {
            this.cpusetMems = cpusetMems;
            return this;
        }

        public Builder cpuQuota(Long cpuQuota) {
            this.cpuQuota = cpuQuota;
            return this;
        }

        public Builder ipcMode(String ipcMode) {
            this.ipcMode = ipcMode;
            return this;
        }

        public Builder pidMode(String pidMode) {
            this.pidMode = pidMode;
            return this;
        }

        public Builder shmSize(Long shmSize) {
            this.shmSize = shmSize;
            return this;
        }

        public Builder oomKillDisable(Boolean oomKillDisable) {
            this.oomKillDisable = oomKillDisable;
            return this;
        }

        public Builder oomScoreAdj(Integer oomScoreAdj) {
            this.oomScoreAdj = oomScoreAdj;
            return this;
        }

        public Builder autoRemove(Boolean autoRemove) {
            this.autoRemove = autoRemove;
            return this;
        }

        public Builder pidsLimit(Integer pidsLimit) {
            this.pidsLimit = pidsLimit;
            return this;
        }

        public Builder restartPolicy(IDockerRestartPolicy restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        public Builder ulimits(List<IDockerUlimit> ulimits) {
            this.ulimits = ulimits;
            return this;
        }

        public Builder logConfig(IDockerLogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        public Builder storageOpt(Map<String, String> storageOpt) {
            this.storageOpt = storageOpt;
            return this;
        }

        public Builder blkioWeight(Integer blkioWeight) {
            this.blkioWeight = blkioWeight;
            return this;
        }

        public Builder blkioWeightDevice(List<IDockerBlkioWeightDevice> blkioWeightDevice) {
            this.blkioWeightDevice = blkioWeightDevice;
            return this;
        }

        public Builder blkioDeviceReadBps(List<IDockerBlkioDeviceRate> blkioDeviceReadBps) {
            this.blkioDeviceReadBps = blkioDeviceReadBps;
            return this;
        }

        public Builder blkioDeviceWriteBps(List<IDockerBlkioDeviceRate> blkioDeviceWriteBps) {
            this.blkioDeviceWriteBps = blkioDeviceWriteBps;
            return this;
        }

        public Builder blkioDeviceReadIOps(List<IDockerBlkioDeviceRate> blkioDeviceReadIOps) {
            this.blkioDeviceReadIOps = blkioDeviceReadIOps;
            return this;
        }

        public Builder blkioDeviceWriteIOps(List<IDockerBlkioDeviceRate> blkioDeviceWriteIOps) {
            this.blkioDeviceWriteIOps = blkioDeviceWriteIOps;
            return this;
        }

        public IDockerHostConfig build() {
            return new DockerHostConfig(this);
        }
    }
}

