
package org.mandas.docker.client.messages.mount;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link Mount}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMount.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableMount implements Mount {
  private final @Nullable String type;
  private final @Nullable String source;
  private final @Nullable String target;
  private final @Nullable Boolean readOnly;
  private final @Nullable BindOptions bindOptions;
  private final @Nullable VolumeOptions volumeOptions;
  private final @Nullable TmpfsOptions tmpfsOptions;

  private ImmutableMount(
      @Nullable String type,
      @Nullable String source,
      @Nullable String target,
      @Nullable Boolean readOnly,
      @Nullable BindOptions bindOptions,
      @Nullable VolumeOptions volumeOptions,
      @Nullable TmpfsOptions tmpfsOptions) {
    this.type = type;
    this.source = source;
    this.target = target;
    this.readOnly = readOnly;
    this.bindOptions = bindOptions;
    this.volumeOptions = volumeOptions;
    this.tmpfsOptions = tmpfsOptions;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("Type")
  @Override
  public @Nullable String type() {
    return type;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @JsonProperty("Source")
  @Override
  public @Nullable String source() {
    return source;
  }

  /**
   * @return The value of the {@code target} attribute
   */
  @JsonProperty("Target")
  @Override
  public @Nullable String target() {
    return target;
  }

  /**
   * @return The value of the {@code readOnly} attribute
   */
  @JsonProperty("ReadOnly")
  @Override
  public @Nullable Boolean readOnly() {
    return readOnly;
  }

  /**
   * @return The value of the {@code bindOptions} attribute
   */
  @JsonProperty("BindOptions")
  @Override
  public @Nullable BindOptions bindOptions() {
    return bindOptions;
  }

  /**
   * @return The value of the {@code volumeOptions} attribute
   */
  @JsonProperty("VolumeOptions")
  @Override
  public @Nullable VolumeOptions volumeOptions() {
    return volumeOptions;
  }

  /**
   * @return The value of the {@code tmpfsOptions} attribute
   */
  @JsonProperty("TmpfsOptions")
  @Override
  public @Nullable TmpfsOptions tmpfsOptions() {
    return tmpfsOptions;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Mount#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMount withType(@Nullable String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableMount(
        value,
        this.source,
        this.target,
        this.readOnly,
        this.bindOptions,
        this.volumeOptions,
        this.tmpfsOptions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Mount#source() source} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMount withSource(@Nullable String value) {
    if (Objects.equals(this.source, value)) return this;
    return new ImmutableMount(
        this.type,
        value,
        this.target,
        this.readOnly,
        this.bindOptions,
        this.volumeOptions,
        this.tmpfsOptions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Mount#target() target} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for target (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMount withTarget(@Nullable String value) {
    if (Objects.equals(this.target, value)) return this;
    return new ImmutableMount(
        this.type,
        this.source,
        value,
        this.readOnly,
        this.bindOptions,
        this.volumeOptions,
        this.tmpfsOptions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Mount#readOnly() readOnly} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for readOnly (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMount withReadOnly(@Nullable Boolean value) {
    if (Objects.equals(this.readOnly, value)) return this;
    return new ImmutableMount(
        this.type,
        this.source,
        this.target,
        value,
        this.bindOptions,
        this.volumeOptions,
        this.tmpfsOptions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Mount#bindOptions() bindOptions} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bindOptions (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMount withBindOptions(@Nullable BindOptions value) {
    if (this.bindOptions == value) return this;
    return new ImmutableMount(
        this.type,
        this.source,
        this.target,
        this.readOnly,
        value,
        this.volumeOptions,
        this.tmpfsOptions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Mount#volumeOptions() volumeOptions} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for volumeOptions (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMount withVolumeOptions(@Nullable VolumeOptions value) {
    if (this.volumeOptions == value) return this;
    return new ImmutableMount(this.type, this.source, this.target, this.readOnly, this.bindOptions, value, this.tmpfsOptions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Mount#tmpfsOptions() tmpfsOptions} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tmpfsOptions (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMount withTmpfsOptions(@Nullable TmpfsOptions value) {
    if (this.tmpfsOptions == value) return this;
    return new ImmutableMount(this.type, this.source, this.target, this.readOnly, this.bindOptions, this.volumeOptions, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMount} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMount
        && equalsByValue((ImmutableMount) another);
  }

  private boolean equalsByValue(ImmutableMount another) {
    return Objects.equals(type, another.type)
        && Objects.equals(source, another.source)
        && Objects.equals(target, another.target)
        && Objects.equals(readOnly, another.readOnly)
        && Objects.equals(bindOptions, another.bindOptions)
        && Objects.equals(volumeOptions, another.volumeOptions)
        && Objects.equals(tmpfsOptions, another.tmpfsOptions);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code source}, {@code target}, {@code readOnly}, {@code bindOptions}, {@code volumeOptions}, {@code tmpfsOptions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(source);
    h += (h << 5) + Objects.hashCode(target);
    h += (h << 5) + Objects.hashCode(readOnly);
    h += (h << 5) + Objects.hashCode(bindOptions);
    h += (h << 5) + Objects.hashCode(volumeOptions);
    h += (h << 5) + Objects.hashCode(tmpfsOptions);
    return h;
  }

  /**
   * Prints the immutable value {@code Mount} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Mount{"
        + "type=" + type
        + ", source=" + source
        + ", target=" + target
        + ", readOnly=" + readOnly
        + ", bindOptions=" + bindOptions
        + ", volumeOptions=" + volumeOptions
        + ", tmpfsOptions=" + tmpfsOptions
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Mount} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Mount instance
   */
  public static ImmutableMount copyOf(Mount instance) {
    if (instance instanceof ImmutableMount) {
      return (ImmutableMount) instance;
    }
    return ImmutableMount.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMount ImmutableMount}.
   * <pre>
   * ImmutableMount.builder()
   *    .type(String | null) // nullable {@link Mount#type() type}
   *    .source(String | null) // nullable {@link Mount#source() source}
   *    .target(String | null) // nullable {@link Mount#target() target}
   *    .readOnly(Boolean | null) // nullable {@link Mount#readOnly() readOnly}
   *    .bindOptions(org.mandas.docker.client.messages.mount.BindOptions | null) // nullable {@link Mount#bindOptions() bindOptions}
   *    .volumeOptions(org.mandas.docker.client.messages.mount.VolumeOptions | null) // nullable {@link Mount#volumeOptions() volumeOptions}
   *    .tmpfsOptions(org.mandas.docker.client.messages.mount.TmpfsOptions | null) // nullable {@link Mount#tmpfsOptions() tmpfsOptions}
   *    .build();
   * </pre>
   * @return A new ImmutableMount builder
   */
  public static ImmutableMount.Builder builder() {
    return new ImmutableMount.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMount ImmutableMount}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements Mount.Builder {
    private String type;
    private String source;
    private String target;
    private Boolean readOnly;
    private BindOptions bindOptions;
    private VolumeOptions volumeOptions;
    private TmpfsOptions tmpfsOptions;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Mount} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Mount instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String typeValue = instance.type();
      if (typeValue != null) {
        type(typeValue);
      }
      @Nullable String sourceValue = instance.source();
      if (sourceValue != null) {
        source(sourceValue);
      }
      @Nullable String targetValue = instance.target();
      if (targetValue != null) {
        target(targetValue);
      }
      @Nullable Boolean readOnlyValue = instance.readOnly();
      if (readOnlyValue != null) {
        readOnly(readOnlyValue);
      }
      @Nullable BindOptions bindOptionsValue = instance.bindOptions();
      if (bindOptionsValue != null) {
        bindOptions(bindOptionsValue);
      }
      @Nullable VolumeOptions volumeOptionsValue = instance.volumeOptions();
      if (volumeOptionsValue != null) {
        volumeOptions(volumeOptionsValue);
      }
      @Nullable TmpfsOptions tmpfsOptionsValue = instance.tmpfsOptions();
      if (tmpfsOptionsValue != null) {
        tmpfsOptions(tmpfsOptionsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Mount#type() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link Mount#source() source} attribute.
     * @param source The value for source (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Source")
    public final Builder source(@Nullable String source) {
      this.source = source;
      return this;
    }

    /**
     * Initializes the value for the {@link Mount#target() target} attribute.
     * @param target The value for target (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Target")
    public final Builder target(@Nullable String target) {
      this.target = target;
      return this;
    }

    /**
     * Initializes the value for the {@link Mount#readOnly() readOnly} attribute.
     * @param readOnly The value for readOnly (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ReadOnly")
    public final Builder readOnly(@Nullable Boolean readOnly) {
      this.readOnly = readOnly;
      return this;
    }

    /**
     * Initializes the value for the {@link Mount#bindOptions() bindOptions} attribute.
     * @param bindOptions The value for bindOptions (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("BindOptions")
    public final Builder bindOptions(@Nullable BindOptions bindOptions) {
      this.bindOptions = bindOptions;
      return this;
    }

    /**
     * Initializes the value for the {@link Mount#volumeOptions() volumeOptions} attribute.
     * @param volumeOptions The value for volumeOptions (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("VolumeOptions")
    public final Builder volumeOptions(@Nullable VolumeOptions volumeOptions) {
      this.volumeOptions = volumeOptions;
      return this;
    }

    /**
     * Initializes the value for the {@link Mount#tmpfsOptions() tmpfsOptions} attribute.
     * @param tmpfsOptions The value for tmpfsOptions (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("TmpfsOptions")
    public final Builder tmpfsOptions(@Nullable TmpfsOptions tmpfsOptions) {
      this.tmpfsOptions = tmpfsOptions;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMount ImmutableMount}.
     * @return An immutable instance of Mount
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMount build() {
      return new ImmutableMount(type, source, target, readOnly, bindOptions, volumeOptions, tmpfsOptions);
    }
  }
}
