/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.man.parser;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.linuxtools.internal.man.parser.Messages;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ManParser {
    private static final int DEFAULT_SSH_PORT = 22;

    public static List<Path> getManPaths() {
        ArrayList<String> params = new ArrayList<String>();
        params.add(ManParser.getManExecutable());
        params.add("-w");
        ArrayList<Path> manPaths = new ArrayList<Path>();
        ProcessBuilder builder = new ProcessBuilder(params);
        try (InputStream stdout = builder.start().getInputStream();){
            int x;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((x = stdout.read()) != -1) {
                bos.write(x);
            }
            for (String path : bos.toString().trim().split(File.pathSeparator)) {
                manPaths.add(Paths.get(path, new String[0]));
            }
        }
        catch (IOException e) {
            Bundle bundle = FrameworkUtil.getBundle(ManParser.class);
            IStatus status = Status.error((String)e.getMessage());
            Platform.getLog((Bundle)bundle).log(status);
        }
        return manPaths;
    }

    public InputStream getManPage(String page, boolean html, String ... sections) {
        StringBuilder sectionParam = new StringBuilder();
        for (String section : sections) {
            if (sectionParam.length() > 0) {
                sectionParam.append(':');
            }
            sectionParam.append(section);
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(ManParser.getManExecutable());
        if (page != null && !page.isEmpty() && sectionParam.length() > 0) {
            params.add("-S");
            params.add(sectionParam.toString());
        }
        if (html) {
            params.add("-Thtml");
        }
        params.add(page);
        ProcessBuilder builder = new ProcessBuilder(params);
        InputStream stdout = null;
        try {
            Process process = builder.start();
            stdout = process.getInputStream();
        }
        catch (IOException e) {
            Bundle bundle = FrameworkUtil.getBundle(this.getClass());
            Platform.getLog((Bundle)bundle).log(Status.error((String)e.getMessage()));
        }
        return stdout;
    }

    public StringBuilder getRawManPage(String manPage) {
        StringBuilder sb = new StringBuilder();
        try (InputStream manContent = this.getManPage(manPage, false, new String[0]);
             BufferedReader reader = manContent != null ? new BufferedReader(new InputStreamReader(manContent)) : null;){
            if (reader != null) {
                sb.append(reader.lines().collect(Collectors.joining("\n")));
            }
        }
        catch (IOException e) {
            Bundle bundle = FrameworkUtil.getBundle(this.getClass());
            Platform.getLog((Bundle)bundle).log(Status.error((String)e.getMessage()));
        }
        return sb;
    }

    public StringBuilder getRemoteRawManPage(String manPage, String user, String host, String password) {
        final StringBuilder sb = new StringBuilder();
        OutputStream out = new OutputStream(this){

            @Override
            public void write(int b) throws IOException {
                sb.append((char)b);
            }
        };
        try {
            ManParser.execRemoteAndWait(new String[]{ManParser.getManExecutable(), manPage}, out, out, user, host, password);
        }
        catch (JSchException e) {
            sb.setLength(0);
            sb.append(Messages.ManParser_RemoteAccessError);
        }
        return sb;
    }

    private static Channel execRemoteAndWait(String[] args, OutputStream out, OutputStream err, String user, String host, String password) throws JSchException {
        Channel channel = ManParser.execRemote(args, out, err, user, host, password);
        while (!channel.isClosed()) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                return channel;
            }
        }
        return channel;
    }

    private static Channel execRemote(String[] args, OutputStream out, OutputStream err, String user, String host, String password) throws JSchException {
        JSch jsch = new JSch();
        Session session = jsch.getSession(user, host, 22);
        session.setPassword(password);
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        session.setConfig(config);
        session.connect();
        StringBuilder command = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            command.append(args[i] + " ");
        }
        ChannelExec channel = (ChannelExec)session.openChannel("exec");
        channel.setPty(true);
        channel.setCommand(command.toString());
        channel.setInputStream(null, true);
        channel.setOutputStream(out, true);
        channel.setExtOutputStream(err, true);
        channel.connect();
        return channel;
    }

    private static String getManExecutable() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(FrameworkUtil.getBundle(ManParser.class).getSymbolicName());
        return prefs.get("pathPreference", "/usr/bin/man");
    }
}

