/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.utils;

import java.util.Map;
import java.util.Optional;

public final class MapUtil {
    private MapUtil() {
    }

    public static Optional<String> getValue(Map<String, String> args, String key) {
        return Optional.ofNullable(args).map(arg -> (String)arg.get(key));
    }

    public static Optional<Integer> getIntValue(Map<String, String> args, String key) {
        try {
            return Optional.ofNullable(args).map(arg -> Integer.parseInt((String)arg.get(key)));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }

    public static Optional<Float> getFloatValue(Map<String, String> args, String key) {
        try {
            return Optional.ofNullable(args).map(opt -> Float.valueOf(Float.parseFloat((String)opt.get(key))));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }

    public static boolean getBoolValue(Map<String, String> args, String key) {
        return Optional.ofNullable(args).map(arg -> Boolean.parseBoolean((String)arg.get(key))).orElse(false);
    }
}

