/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.glsp.example.workflow.wfgraph.WfgraphPackage;
import org.eclipse.glsp.graph.DefaultTypes;
import org.eclipse.glsp.graph.GraphPackage;
import org.eclipse.glsp.server.diagram.BaseDiagramConfiguration;
import org.eclipse.glsp.server.layout.ServerLayoutKind;
import org.eclipse.glsp.server.types.EdgeTypeHint;
import org.eclipse.glsp.server.types.ShapeTypeHint;

public class WorkflowDiagramConfiguration
extends BaseDiagramConfiguration {
    public Map<String, EClass> getTypeMappings() {
        Map mappings = DefaultTypes.getDefaultTypeMappings();
        mappings.put("label:heading", GraphPackage.Literals.GLABEL);
        mappings.put("label:text", GraphPackage.Literals.GLABEL);
        mappings.put("comp:header", GraphPackage.Literals.GCOMPARTMENT);
        mappings.put("label:icon", GraphPackage.Literals.GLABEL);
        mappings.put("edge:weighted", WfgraphPackage.Literals.WEIGHTED_EDGE);
        mappings.put("icon", WfgraphPackage.Literals.ICON);
        mappings.put("activityNode", WfgraphPackage.Literals.ACTIVITY_NODE);
        mappings.put("task", WfgraphPackage.Literals.TASK_NODE);
        mappings.put("category", WfgraphPackage.Literals.CATEGORY);
        mappings.put("struct", GraphPackage.Literals.GCOMPARTMENT);
        return mappings;
    }

    public List<ShapeTypeHint> getShapeTypeHints() {
        ArrayList<ShapeTypeHint> nodeHints = new ArrayList<ShapeTypeHint>();
        nodeHints.add(this.createDefaultShapeTypeHint("task:manual"));
        nodeHints.add(this.createDefaultShapeTypeHint("task:automated"));
        ShapeTypeHint catHint = this.createDefaultShapeTypeHint("category");
        catHint.setContainableElementTypeIds(Arrays.asList("task", "activityNode", "category"));
        nodeHints.add(catHint);
        ShapeTypeHint forkHint = this.createDefaultShapeTypeHint("activityNode:fork");
        forkHint.setResizable(false);
        nodeHints.add(forkHint);
        ShapeTypeHint joinHint = this.createDefaultShapeTypeHint("activityNode:join");
        joinHint.setResizable(false);
        nodeHints.add(joinHint);
        nodeHints.add(this.createDefaultShapeTypeHint("activityNode:decision"));
        nodeHints.add(this.createDefaultShapeTypeHint("activityNode:merge"));
        return nodeHints;
    }

    public ShapeTypeHint createDefaultShapeTypeHint(String elementId) {
        return new ShapeTypeHint(elementId, true, true, true, true);
    }

    public List<EdgeTypeHint> getEdgeTypeHints() {
        ArrayList<EdgeTypeHint> edgeHints = new ArrayList<EdgeTypeHint>();
        EdgeTypeHint hint = super.createDefaultEdgeTypeHint("edge");
        hint.addSourceElementTypeId(new String[]{"task", "activityNode", "category"});
        hint.addTargetElementTypeId(new String[]{"task", "activityNode", "category"});
        edgeHints.add(hint);
        EdgeTypeHint weightedEdgeHint = this.createDefaultEdgeTypeHint("edge:weighted");
        weightedEdgeHint.addSourceElementTypeId(new String[]{"activityNode"});
        weightedEdgeHint.addTargetElementTypeId(new String[]{"task", "activityNode"});
        weightedEdgeHint.setDynamic(true);
        edgeHints.add(weightedEdgeHint);
        return edgeHints;
    }

    public ServerLayoutKind getLayoutKind() {
        return ServerLayoutKind.MANUAL;
    }

    public boolean needsClientLayout() {
        return true;
    }
}

