/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.ui;

import com.google.gson.Gson;
import java.util.Collection;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.glsp.ide.editor.ui.BrowserFunctionInstaller;
import org.eclipse.glsp.ide.editor.utils.UIUtil;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.services.IServiceLocator;

public class BrowserKeyBindingForwarderInstaller
implements BrowserFunctionInstaller {
    protected static final Logger LOGGER = LogManager.getLogger(BrowserKeyBindingForwarderInstaller.class);
    public static final String FUNCTION_NAME = "$notifyKeybinding";
    public static final String FUNCTION_CALL = "if(event.ctrlKey || event.shiftKey || event.altKey) { $notifyKeybinding(JSON.stringify({    altKey: event.altKey,     ctrlKey: event.ctrlKey,     shiftKey: event.shiftKey,     metaKey: event.metaKey,     repeat: event.repeat,     key: event.key,     code: event.code }));}";
    private static final String FUNCTION_INSTALLER = "document.addEventListener('keydown', (event) => { if(event.ctrlKey || event.shiftKey || event.altKey) { $notifyKeybinding(JSON.stringify({    altKey: event.altKey,     ctrlKey: event.ctrlKey,     shiftKey: event.shiftKey,     metaKey: event.metaKey,     repeat: event.repeat,     key: event.key,     code: event.code }));} });";
    private final IBindingService bindingService;

    public BrowserKeyBindingForwarderInstaller(IBindingService bindingService) {
        this.bindingService = bindingService;
    }

    public BrowserKeyBindingForwarderInstaller(IServiceLocator serviceLocator) {
        this.bindingService = (IBindingService)serviceLocator.getService(IBindingService.class);
    }

    @Override
    public Optional<BrowserFunction> install(Browser browser) {
        return this.doInstall(browser);
    }

    protected Optional<BrowserFunction> doInstall(Browser browser) {
        BrowserFunction browserFunction = new BrowserFunction(browser, FUNCTION_NAME){

            public Object function(Object[] arguments) {
                SerializableKeyEvent event;
                Optional<KeySequence> keySequence;
                if (arguments.length == 1 && arguments[0] instanceof String && (keySequence = BrowserKeyBindingForwarderInstaller.this.getKeySequence(event = (SerializableKeyEvent)new Gson().fromJson((String)arguments[0], SerializableKeyEvent.class))).isPresent() && BrowserKeyBindingForwarderInstaller.this.bindingService != null) {
                    BrowserKeyBindingForwarderInstaller.this.forwardKeySequence(BrowserKeyBindingForwarderInstaller.this.bindingService, keySequence.get());
                }
                return null;
            }
        };
        browser.execute(FUNCTION_INSTALLER);
        return Optional.of(browserFunction);
    }

    protected void forwardKeySequence(IBindingService bindingService, KeySequence keySequence) {
        this.findMatchingBinding(bindingService, keySequence).ifPresent(this::executeCommand);
    }

    protected Optional<Binding> findMatchingBinding(IBindingService bindingService, KeySequence keySequence) {
        Collection partialMatches;
        Binding perfectMatch = bindingService.getPerfectMatch((TriggerSequence)keySequence);
        if (perfectMatch == null && (partialMatches = bindingService.getConflictsFor((TriggerSequence)keySequence)) != null) {
            for (Binding binding : partialMatches) {
                if (!binding.getParameterizedCommand().getCommand().isEnabled()) continue;
                return Optional.of(binding);
            }
        }
        return Optional.ofNullable(perfectMatch);
    }

    protected void executeCommand(Binding binding) {
        UIUtil.asyncExec(() -> this.doExecuteCommand(binding));
    }

    protected void doExecuteCommand(Binding binding) {
        try {
            if (binding != null && binding.getParameterizedCommand().getCommand().isEnabled()) {
                binding.getParameterizedCommand().executeWithChecks(null, null);
            }
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException exception) {
            LOGGER.error((Object)exception);
        }
    }

    protected Optional<KeySequence> getKeySequence(SerializableKeyEvent event) {
        Object keyString = event.getKey().toUpperCase();
        if (event.isCtrlKey()) {
            keyString = "CTRL+" + (String)keyString;
        }
        if (event.isAltKey()) {
            keyString = "ALT+" + (String)keyString;
        }
        if (event.isShiftKey()) {
            keyString = "SHIFT+" + (String)keyString;
        }
        try {
            KeyStroke stroke = KeyStroke.getInstance((String)keyString);
            return Optional.ofNullable(KeySequence.getInstance((KeyStroke)stroke));
        }
        catch (IllegalArgumentException | ParseException exception) {
            return Optional.empty();
        }
    }

    protected static class SerializableKeyEvent {
        private static final String JAVASCRIPT_CONSTRUCTOR_FOR_EVENT = "{    altKey: event.altKey,     ctrlKey: event.ctrlKey,     shiftKey: event.shiftKey,     metaKey: event.metaKey,     repeat: event.repeat,     key: event.key,     code: event.code }";
        private boolean altKey;
        private boolean ctrlKey;
        private boolean shiftKey;
        private boolean metaKey;
        private boolean repeat;
        private String code;
        private String key;

        protected SerializableKeyEvent() {
        }

        public boolean isAltKey() {
            return this.altKey;
        }

        public boolean isCtrlKey() {
            return this.ctrlKey;
        }

        public boolean isShiftKey() {
            return this.shiftKey;
        }

        public boolean isMetaKey() {
            return this.metaKey;
        }

        public boolean isRepeat() {
            return this.repeat;
        }

        public String getCode() {
            return this.code;
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SerializableEvent [isAltKey()=").append(this.isAltKey()).append(", isCtrlKey()=").append(this.isCtrlKey()).append(", isShiftKey()=").append(this.isShiftKey()).append(", isMetaKey()=").append(this.isMetaKey()).append(", isRepeat()=").append(this.isRepeat()).append(", getCode()=").append(this.getCode()).append(", getKey()=").append(this.getKey()).append("]");
            return builder.toString();
        }
    }
}

