/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.suite.engine;

import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.core.LauncherDiscoveryResult;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.junit.platform.suite.api.Suite;
import org.junit.platform.suite.api.SuiteDisplayName;
import org.junit.platform.suite.commons.SuiteLauncherDiscoveryRequestBuilder;
import org.junit.platform.suite.engine.NoTestsDiscoveredException;
import org.junit.platform.suite.engine.SuiteLauncher;

final class SuiteTestDescriptor
extends AbstractTestDescriptor {
    static final String SEGMENT_TYPE = "suite";
    private final SuiteLauncherDiscoveryRequestBuilder discoveryRequestBuilder = SuiteLauncherDiscoveryRequestBuilder.request();
    private final ConfigurationParameters configurationParameters;
    private final Boolean failIfNoTests;
    private final Class<?> suiteClass;
    private LauncherDiscoveryResult launcherDiscoveryResult;
    private SuiteLauncher launcher;

    SuiteTestDescriptor(UniqueId id, Class<?> suiteClass, ConfigurationParameters configurationParameters) {
        super(id, SuiteTestDescriptor.getSuiteDisplayName(suiteClass), ClassSource.from(suiteClass));
        this.configurationParameters = configurationParameters;
        this.failIfNoTests = SuiteTestDescriptor.getFailIfNoTests(suiteClass);
        this.suiteClass = suiteClass;
    }

    private static Boolean getFailIfNoTests(Class<?> suiteClass) {
        return AnnotationUtils.findAnnotation(suiteClass, Suite.class).map(Suite::failIfNoTests).orElseThrow(() -> new JUnitException(String.format("Suite [%s] was not annotated with @Suite", suiteClass.getName())));
    }

    SuiteTestDescriptor addDiscoveryRequestFrom(Class<?> suiteClass) {
        Preconditions.condition(this.launcherDiscoveryResult == null, "discovery request cannot be modified after discovery");
        this.discoveryRequestBuilder.applySelectorsAndFiltersFromSuite(suiteClass);
        return this;
    }

    SuiteTestDescriptor addDiscoveryRequestFrom(UniqueId uniqueId) {
        Preconditions.condition(this.launcherDiscoveryResult == null, "discovery request cannot be modified after discovery");
        this.discoveryRequestBuilder.selectors(DiscoverySelectors.selectUniqueId(uniqueId));
        return this;
    }

    void discover() {
        if (this.launcherDiscoveryResult != null) {
            return;
        }
        LauncherDiscoveryRequest request = this.discoveryRequestBuilder.filterStandardClassNamePatterns(true).enableImplicitConfigurationParameters(false).parentConfigurationParameters(this.configurationParameters).applyConfigurationParametersFromSuite(this.suiteClass).build();
        this.launcher = SuiteLauncher.create();
        this.launcherDiscoveryResult = this.launcher.discover(request, this.getUniqueId());
        this.launcherDiscoveryResult.getTestEngines().stream().map(testEngine -> this.launcherDiscoveryResult.getEngineTestDescriptor((TestEngine)testEngine)).forEach(this::addChild);
    }

    @Override
    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    private static String getSuiteDisplayName(Class<?> testClass) {
        return AnnotationUtils.findAnnotation(testClass, SuiteDisplayName.class).map(SuiteDisplayName::value).filter(StringUtils::isNotBlank).orElse(testClass.getSimpleName());
    }

    void execute(EngineExecutionListener parentEngineExecutionListener) {
        parentEngineExecutionListener.executionStarted(this);
        LauncherDiscoveryResult discoveryResult = this.launcherDiscoveryResult.withRetainedEngines(this.getChildren()::contains);
        TestExecutionSummary summary = this.launcher.execute(discoveryResult, parentEngineExecutionListener);
        parentEngineExecutionListener.executionFinished(this, this.computeTestExecutionResult(summary));
    }

    private TestExecutionResult computeTestExecutionResult(TestExecutionSummary summary) {
        if (this.failIfNoTests.booleanValue() && summary.getTestsFoundCount() == 0L) {
            return TestExecutionResult.failed(new NoTestsDiscoveredException(this.suiteClass));
        }
        return TestExecutionResult.successful();
    }

    @Override
    public boolean mayRegisterTests() {
        return true;
    }
}

