/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.rowset.rw.rs_json;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import org.apache.jena.atlas.iterator.IteratorSlotted;
import org.apache.jena.riot.rowset.rw.rs_json.ParserState;
import org.apache.jena.riot.rowset.rw.rs_json.RsJsonEltEncoder;
import org.apache.jena.sparql.resultset.ResultSetException;

public class IteratorRsJSON<E>
extends IteratorSlotted<E> {
    protected ParserState parserState;
    protected RsJsonEltEncoder<E> eltEncoder;
    protected Gson gson;
    protected JsonReader reader;

    public IteratorRsJSON(Gson gson, JsonReader jsonReader, RsJsonEltEncoder<E> eltEncoder) {
        this(gson, jsonReader, eltEncoder, ParserState.INIT);
    }

    public IteratorRsJSON(Gson gson, JsonReader jsonReader, RsJsonEltEncoder<E> eltEncoder, ParserState parserState) {
        this.gson = gson;
        this.reader = jsonReader;
        this.eltEncoder = eltEncoder;
        this.parserState = parserState;
    }

    @Override
    protected E moveToNext() {
        E result;
        try {
            result = this.computeNextActual();
        }
        catch (Throwable e2) {
            throw new ResultSetException(e2.getMessage(), e2);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected E computeNextActual() throws IOException {
        block23: while (true) {
            block27: {
                E result;
                switch (this.parserState) {
                    case INIT: {
                        this.reader.beginObject();
                        this.parserState = ParserState.ROOT;
                        continue block23;
                    }
                    case ROOT: {
                        if (this.reader.hasNext()) {
                            String topLevelName;
                            switch (topLevelName = this.reader.nextName()) {
                                case "head": {
                                    result = this.eltEncoder.newHeadElt(this.gson, this.reader);
                                    return result;
                                }
                                case "results": {
                                    this.reader.beginObject();
                                    this.parserState = ParserState.RESULTS;
                                    result = this.eltEncoder.newResultsElt(this.gson, this.reader);
                                    return result;
                                }
                                case "boolean": {
                                    result = this.eltEncoder.newBooleanElt(this.gson, this.reader);
                                    return result;
                                }
                            }
                            result = this.eltEncoder.newUnknownElt(this.gson, this.reader);
                            return result;
                        }
                        this.reader.endObject();
                        this.parserState = ParserState.DONE;
                        continue block23;
                    }
                    case RESULTS: {
                        break;
                    }
                    case BINDINGS: {
                        if (this.reader.hasNext()) {
                            result = this.eltEncoder.newBindingElt(this.gson, this.reader);
                            return result;
                        }
                        this.reader.endArray();
                        this.parserState = ParserState.RESULTS;
                        break block27;
                    }
                    case DONE: {
                        result = null;
                        return result;
                    }
                }
                while (this.reader.hasNext()) {
                    String elt;
                    switch (elt = this.reader.nextName()) {
                        case "bindings": {
                            this.reader.beginArray();
                            this.parserState = ParserState.BINDINGS;
                            continue block23;
                        }
                    }
                    result = this.eltEncoder.newUnknownElt(this.gson, this.reader);
                }
                this.reader.endObject();
                this.parserState = ParserState.ROOT;
            }
        }
    }

    @Override
    protected boolean hasMore() {
        return true;
    }

    @Override
    public void closeIterator() {
        try {
            this.reader.close();
        }
        catch (IOException e2) {
            throw new ResultSetException("IOException on closing the underlying stream", e2);
        }
    }
}

