/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dap;

import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.dap.EpsilonDebugAdapter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.control.ExecutionController;
import org.eclipse.epsilon.eol.execute.control.IExecutionListener;

public class ExecutionQueueModule
extends EolModule {
    public static final Duration DEFAULT_DURATION = Duration.ofMillis(200L);
    private final BlockingQueue<Runnable> taskQueue = new LinkedBlockingDeque<Runnable>();
    private Duration pollInterval = DEFAULT_DURATION;
    private EpsilonDebugAdapter debugAdapter;

    public Future<Object> enqueue(IEolModule module) {
        CompletableFuture<Object> futureResult = new CompletableFuture<Object>();
        this.taskQueue.add(() -> {
            try {
                ExecutorFactory moduleExecFactory = module.getContext().getExecutorFactory();
                ExecutorFactory queueExecFactory = this.getContext().getExecutorFactory();
                for (IExecutionListener l : queueExecFactory.getExecutionListeners()) {
                    moduleExecFactory.addExecutionListener(l);
                }
                if (this.debugAdapter != null) {
                    this.debugAdapter.attachTo(module);
                }
                Object result = module.execute();
                futureResult.complete(result);
            }
            catch (EolRuntimeException e) {
                futureResult.completeExceptionally(e);
            }
        });
        return futureResult;
    }

    public Object executeImpl() throws EolRuntimeException {
        ExecutionController executionController = this.getContext().getExecutorFactory().getExecutionController();
        while (!executionController.isTerminated()) {
            try {
                Runnable r = this.taskQueue.poll(this.pollInterval.toMillis(), TimeUnit.MILLISECONDS);
                if (r == null) continue;
                r.run();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Duration getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(Duration pollInterval) {
        this.pollInterval = pollInterval;
    }

    public EpsilonDebugAdapter getDebugAdapter() {
        return this.debugAdapter;
    }

    public void setDebugAdapter(EpsilonDebugAdapter debugAdapter) {
        this.debugAdapter = debugAdapter;
    }
}

