/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.resolver;

import jakarta.validation.Path;
import jakarta.validation.TraversableResolver;
import java.lang.annotation.ElementType;
import java.util.HashMap;
import java.util.Map;

class CachingTraversableResolverForSingleValidation
implements TraversableResolver {
    private final TraversableResolver delegate;
    private final Map<TraversableHolder, TraversableHolder> traversables = new HashMap<TraversableHolder, TraversableHolder>();

    public CachingTraversableResolverForSingleValidation(TraversableResolver delegate) {
        this.delegate = delegate;
    }

    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        TraversableHolder currentLH = new TraversableHolder(traversableObject, traversableProperty, elementType);
        TraversableHolder cachedLH = this.traversables.get(currentLH);
        if (cachedLH == null) {
            currentLH.isReachable = this.delegate.isReachable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
            this.traversables.put(currentLH, currentLH);
            cachedLH = currentLH;
        } else if (cachedLH.isReachable == null) {
            cachedLH.isReachable = this.delegate.isReachable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
        }
        return cachedLH.isReachable;
    }

    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        TraversableHolder currentLH = new TraversableHolder(traversableObject, traversableProperty, elementType);
        TraversableHolder cachedLH = this.traversables.get(currentLH);
        if (cachedLH == null) {
            currentLH.isCascadable = this.delegate.isCascadable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
            this.traversables.put(currentLH, currentLH);
            cachedLH = currentLH;
        } else if (cachedLH.isCascadable == null) {
            cachedLH.isCascadable = this.delegate.isCascadable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
        }
        return cachedLH.isCascadable;
    }

    private static final class TraversableHolder {
        private final Object traversableObject;
        private final String traversableProperty;
        private final ElementType elementType;
        private final int hashCode;
        private Boolean isReachable;
        private Boolean isCascadable;

        private TraversableHolder(Object traversableObject, Path.Node traversableProperty, ElementType elementType) {
            this.traversableObject = traversableObject;
            this.traversableProperty = traversableProperty.getName();
            this.elementType = elementType;
            this.hashCode = this.buildHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof TraversableHolder)) {
                return false;
            }
            TraversableHolder that = (TraversableHolder)o;
            if (this.traversableObject != null ? this.traversableObject != that.traversableObject : that.traversableObject != null) {
                return false;
            }
            if (!this.traversableProperty.equals(that.traversableProperty)) {
                return false;
            }
            return this.elementType == that.elementType;
        }

        public int hashCode() {
            return this.hashCode;
        }

        private int buildHashCode() {
            int result = this.traversableObject != null ? System.identityHashCode(this.traversableObject) : 0;
            result = 31 * result + this.traversableProperty.hashCode();
            result = 31 * result + this.elementType.hashCode();
            return result;
        }
    }
}

