/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.AbstractConfigImpl;
import io.helidon.config.Config;
import io.helidon.config.ConfigHelper;
import io.helidon.config.ConfigKeyImpl;
import io.helidon.config.ConfigLeafImpl;
import io.helidon.config.ConfigListImpl;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMissingImpl;
import io.helidon.config.ConfigObjectImpl;
import io.helidon.config.ProviderImpl;
import io.helidon.config.spi.ConfigFilter;
import io.helidon.config.spi.ConfigNode;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

final class ConfigFactory {
    private final ConfigMapperManager mapperManager;
    private final Map<ConfigKeyImpl, ConfigNode> fullKeyToNodeMap;
    private final ConfigFilter filter;
    private final ProviderImpl provider;
    private final Function<String, List<String>> aliasGenerator;
    private final ConcurrentMap<PrefixedKey, AbstractConfigImpl> configCache;
    private final Instant timestamp;

    ConfigFactory(ConfigMapperManager mapperManager, ConfigNode.ObjectNode node, ConfigFilter filter, ProviderImpl provider, Function<String, List<String>> aliasGenerator) {
        Objects.requireNonNull(mapperManager, "mapperManager argument is null.");
        Objects.requireNonNull(node, "node argument is null.");
        Objects.requireNonNull(filter, "filter argument is null.");
        Objects.requireNonNull(provider, "provider argument is null.");
        this.mapperManager = mapperManager;
        this.fullKeyToNodeMap = ConfigHelper.createFullKeyToNodeMap(node);
        this.filter = filter;
        this.provider = provider;
        this.aliasGenerator = aliasGenerator;
        this.configCache = new ConcurrentHashMap<PrefixedKey, AbstractConfigImpl>();
        this.timestamp = Instant.now();
    }

    Instant timestamp() {
        return this.timestamp;
    }

    AbstractConfigImpl config() {
        return this.config(ConfigKeyImpl.of(), ConfigKeyImpl.of());
    }

    AbstractConfigImpl config(ConfigKeyImpl prefix, ConfigKeyImpl key) {
        PrefixedKey prefixedKey = new PrefixedKey(prefix, key);
        return this.configCache.computeIfAbsent(prefixedKey, it -> this.createConfig(prefix, key));
    }

    private AbstractConfigImpl createConfig(ConfigKeyImpl prefix, ConfigKeyImpl key) {
        ConfigNode value = this.findNode(prefix, key);
        if (null == value) {
            return new ConfigMissingImpl(prefix, key, this, this.mapperManager);
        }
        switch (value.nodeType()) {
            case OBJECT: {
                return new ConfigObjectImpl(prefix, key, (ConfigNode.ObjectNode)value, this.filter, this, this.mapperManager);
            }
            case LIST: {
                return new ConfigListImpl(prefix, key, (ConfigNode.ListNode)value, this.filter, this, this.mapperManager);
            }
            case VALUE: {
                return new ConfigLeafImpl(prefix, key, (ConfigNode.ValueNode)value, this.filter, this, this.mapperManager);
            }
        }
        return new ConfigMissingImpl(prefix, key, this, this.mapperManager);
    }

    private ConfigNode findNode(ConfigKeyImpl prefix, ConfigKeyImpl key) {
        ConfigNode node;
        block1: {
            String keyAlias;
            node = this.fullKeyToNodeMap.get(prefix.child(key));
            if (node != null || this.aliasGenerator == null) break block1;
            String fullKey = key.toString();
            Iterator<String> iterator = this.aliasGenerator.apply(fullKey).iterator();
            while (iterator.hasNext() && (node = this.fullKeyToNodeMap.get(prefix.child(keyAlias = iterator.next()))) == null) {
            }
        }
        return node;
    }

    Config.Context context() {
        return this.provider;
    }

    ProviderImpl provider() {
        return this.provider;
    }

    private static final class PrefixedKey {
        private final ConfigKeyImpl prefix;
        private final ConfigKeyImpl key;

        private PrefixedKey(ConfigKeyImpl prefix, ConfigKeyImpl key) {
            this.prefix = prefix;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrefixedKey that = (PrefixedKey)o;
            return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.prefix, this.key);
        }
    }
}

