/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.delegate;

import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.glassfish.epicyro.config.delegate.MessagePolicyDelegate;

public class ServletMessagePolicyDelegate
implements MessagePolicyDelegate {
    private static final String MANDATORY_AUTH_CONTEXT_ID = "mandatory";
    private static final String OPTIONAL_AUTH_CONTEXT_ID = "optional";
    private static final String MANDATORY_KEY = "jakarta.security.auth.message.MessagePolicy.isMandatory";
    private static final Class<?>[] MESSAGE_TYPES = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
    private static final MessagePolicy mandatoryPolicy = new MessagePolicy(new MessagePolicy.TargetPolicy[]{new MessagePolicy.TargetPolicy(null, () -> "#authenticateSender")}, true);
    private static final MessagePolicy optionalPolicy = new MessagePolicy(new MessagePolicy.TargetPolicy[]{new MessagePolicy.TargetPolicy(null, () -> "#authenticateSender")}, false);

    @Override
    public Class<?>[] getMessageTypes() {
        return MESSAGE_TYPES;
    }

    public MessagePolicy getRequestPolicy(String authContextID, Map properties) {
        return MANDATORY_AUTH_CONTEXT_ID.equals(authContextID) ? mandatoryPolicy : optionalPolicy;
    }

    public MessagePolicy getResponsePolicy(String authContextID, Map properties) {
        return null;
    }

    @Override
    public String getAuthContextID(MessageInfo messageInfo) {
        return messageInfo.getMap().containsKey(MANDATORY_KEY) ? MANDATORY_AUTH_CONTEXT_ID : OPTIONAL_AUTH_CONTEXT_ID;
    }

    @Override
    public boolean isProtected() {
        return true;
    }
}

