/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.module.HK2Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleLifecycleListener;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.ModulesRegistry;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import org.glassfish.admin.monitor.FutureStatsProviders;
import org.glassfish.admin.monitor.MLogger;
import org.glassfish.admin.monitor.StatsProviderManagerDelegateImpl;
import org.glassfish.admin.monitor.StatsProviderRegistry;
import org.glassfish.admin.monitor.StatsProviderUtil;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.monitoring.ContainerMonitoring;
import org.glassfish.external.amx.AMXGlassfish;
import org.glassfish.external.amx.MBeanListener;
import org.glassfish.external.probe.provider.StatsProviderInfo;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.probe.provider.StatsProviderManagerDelegate;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.impl.client.AgentAttacher;
import org.glassfish.flashlight.provider.ProbeProviderEventListener;
import org.glassfish.flashlight.provider.ProbeProviderFactory;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.LogManager;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@RunLevel(value=1)
public class MonitoringBootstrap
implements PostConstruct,
PreDestroy,
EventListener,
ModuleLifecycleListener,
ConfigListener {
    @Inject
    @Optional
    private LogManager dependency0;
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    @Inject
    private ModulesRegistry registry;
    @Inject
    protected ProbeProviderFactory probeProviderFactory;
    @Inject
    protected ProbeClientMediator pcm;
    @Inject
    Events events;
    @Inject
    ServerEnvironment serverEnv;
    @Inject
    @Named(value="default-instance-name")
    @Optional
    MonitoringService monitoringService = null;
    @Inject
    private ProbeRegistry probeRegistry;
    @Inject
    ServiceLocator habitat;
    @Inject
    Transactions transactions;
    private Domain domain;
    Map<String, HK2Module> map = Collections.synchronizedMap(new WeakHashMap());
    List<String> appList = Collections.synchronizedList(new ArrayList());
    private static final String INSTALL_ROOT_URI_PROPERTY_NAME = "com.sun.aas.installRootURI";
    private static final Logger logger = MLogger.getLogger();
    private static final String PROBE_PROVIDER_CLASS_NAMES = "probe-provider-class-names";
    private static final String PROBE_PROVIDER_XML_FILE_NAMES = "probe-provider-xml-file-names";
    private static final String DELIMITER = ",";
    private StatsProviderManagerDelegateImpl spmd;
    private boolean monitoringEnabled = false;
    private boolean hasDiscoveredXMLProviders = false;

    public void postConstruct() {
        boolean enableMonitoring;
        this.domain = (Domain)this.habitat.getService(Domain.class, new Annotation[0]);
        this.transactions.addListenerForType(ContainerMonitoring.class, (ConfigListener)this);
        this.transactions.addListenerForType(MonitoringService.class, (ConfigListener)this);
        this.transactions.addListenerForType(ModuleMonitoringLevels.class, (ConfigListener)this);
        boolean bl = this.monitoringService != null ? Boolean.parseBoolean(this.monitoringService.getMonitoringEnabled()) && this.monitoringService.isAnyModuleOn() : (enableMonitoring = false);
        if (enableMonitoring) {
            this.enableMonitoring(false);
        }
    }

    private void enableMonitoring(boolean isDiscoverXMLProbeProviders) {
        this.events.register(this);
        this.enableMonitoringForProbeProviders(isDiscoverXMLProbeProviders);
        AgentAttacher.attachAgent();
        if (this.spmd != null) {
            this.spmd.updateAllStatsProviders();
        }
        this.monitoringEnabled = true;
    }

    private void discoverProbeProviders() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Discovering the ProbeProviders");
        }
        for (HK2Module m : this.registry.getModules()) {
            if (m.getState() != ModuleState.READY && m.getState() != ModuleState.RESOLVED) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" In (discoverProbeProviders) ModuleState - " + String.valueOf((Object)m.getState()) + " : " + m.getName());
            }
            this.verifyModule(m);
        }
    }

    public void preDestroy() {
        ProbeRegistry.cleanup();
        if (this.spmd != null) {
            this.spmd = new StatsProviderManagerDelegateImpl(this.pcm, this.probeRegistry, this.mrdr, this.domain, this.serverEnv.getInstanceName(), this.monitoringService);
            StatsProviderManager.setStatsProviderManagerDelegate((StatsProviderManagerDelegate)this.spmd);
        }
    }

    @Override
    public void event(EventListener.Event<?> event) {
        if (event.is(EventTypes.SERVER_READY)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Discovering the XML ProbeProviders from lib/monitor");
            }
            this.discoverXMLProviders();
        }
    }

    public void setStatsProviderManagerDelegate() {
        if (this.spmd != null) {
            return;
        }
        this.spmd = new StatsProviderManagerDelegateImpl(this.pcm, this.probeRegistry, this.mrdr, this.domain, this.serverEnv.getInstanceName(), this.monitoringService);
        StatsProviderManager.setStatsProviderManagerDelegate((StatsProviderManagerDelegate)this.spmd);
        StatsProviderUtil.setStatsProviderManagerDelegate(this.spmd);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" StatsProviderManagerDelegate is assigned");
        }
        AMXGlassfish amxg = AMXGlassfish.DEFAULT;
        amxg.listenForDomainRoot((MBeanServerConnection)ManagementFactory.getPlatformMBeanServer(), (MBeanListener.Callback)this.spmd);
    }

    @Override
    public void moduleResolved(HK2Module module) {
        if (module == null) {
            return;
        }
        this.verifyModule(module);
    }

    @Override
    public synchronized void moduleStarted(HK2Module module) {
        if (module == null) {
            return;
        }
        this.verifyModule(module);
    }

    private synchronized void verifyModule(HK2Module module) {
        if (module == null) {
            return;
        }
        String str = module.getName();
        if (!this.map.containsKey(str)) {
            this.map.put(str, module);
            this.addProvider(module);
        }
    }

    public synchronized void registerProbes(String appName, File appDir, ClassLoader cl) {
        if (appName == null) {
            return;
        }
        if (cl == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Null classloader passed for application : {0}", appName);
            }
            return;
        }
        if (!this.appList.contains(appName)) {
            this.appList.add(appName);
            this.addProvider(appDir, cl);
        }
    }

    @Override
    public synchronized void moduleStopped(HK2Module module) {
    }

    @Override
    public void moduleInstalled(HK2Module module) {
    }

    @Override
    public void moduleUpdated(HK2Module module) {
    }

    private void addProvider(HK2Module module) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" Adding the Provider - verified the module");
        }
        ClassLoader mcl = module.getClassLoader();
        ModuleDefinition md = module.getModuleDefinition();
        Manifest mf = null;
        if (md != null) {
            mf = md.getManifest();
        }
        if (mf != null) {
            this.processManifest(mf, mcl);
        }
        this.handleFutureStatsProviders();
    }

    private void addProvider(File appDir, ClassLoader classLoader) {
        Manifest mf;
        File manifestFile = new File(appDir, "META-INF" + File.separator + "MANIFEST.MF");
        String appDirPath = "";
        try {
            appDirPath = appDir.getCanonicalPath();
            FileInputStream fis = new FileInputStream(manifestFile);
            mf = new Manifest(fis);
        }
        catch (IOException ex) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Can''t access META-INF{0}MANIFEST.MF for {1}", new Object[]{File.separator, appDirPath});
                logger.fine(ex.getLocalizedMessage());
            }
            return;
        }
        this.processManifest(mf, classLoader);
        this.handleFutureStatsProviders();
    }

    private void processManifest(Manifest mf, ClassLoader mcl) {
        if (mf != null) {
            Attributes attrs = mf.getMainAttributes();
            String cnames = null;
            String xnames = null;
            if (attrs != null) {
                StringTokenizer st;
                cnames = attrs.getValue(PROBE_PROVIDER_CLASS_NAMES);
                if (cnames != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("probe providers = " + cnames);
                    }
                    st = new StringTokenizer(cnames, DELIMITER);
                    while (st.hasMoreTokens()) {
                        try {
                            if (mcl == null) continue;
                            this.processProbeProviderClass(mcl.loadClass(st.nextToken().trim()));
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "NCLS-MNTG-00104", e);
                        }
                    }
                }
                if ((xnames = attrs.getValue(PROBE_PROVIDER_XML_FILE_NAMES)) != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("xnames = " + xnames);
                    }
                    st = new StringTokenizer(xnames, DELIMITER);
                    while (st.hasMoreTokens()) {
                        this.processProbeProviderXML(mcl, st.nextToken(), true);
                    }
                }
            }
        }
    }

    public void handleFutureStatsProviders() {
        if (FutureStatsProviders.isEmpty()) {
            return;
        }
        ArrayList<StatsProviderInfo> removeList = new ArrayList<StatsProviderInfo>();
        Iterator<StatsProviderInfo> it = FutureStatsProviders.iterator();
        while (it.hasNext()) {
            StatsProviderInfo spInfo = it.next();
            try {
                this.spmd.tryToRegister(spInfo);
                removeList.add(spInfo);
            }
            catch (RuntimeException runtimeException) {}
        }
        for (StatsProviderInfo spInfo : removeList) {
            FutureStatsProviders.remove(spInfo);
        }
    }

    private void discoverXMLProviders() {
        if (this.hasDiscoveredXMLProviders) {
            return;
        }
        try {
            URI xmlProviderDirStr = new URI(System.getProperty(INSTALL_ROOT_URI_PROPERTY_NAME) + "/lib/monitor");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ProviderXML's Dir = " + xmlProviderDirStr.getPath());
            }
            File xmlProviderDir = new File(xmlProviderDirStr.getPath());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ProviderXML's Dir exists = " + xmlProviderDir.exists());
                logger.fine("ProviderXML's Dir path - " + xmlProviderDir.getAbsolutePath());
            }
            this.loadXMLProviders(xmlProviderDir);
            this.hasDiscoveredXMLProviders = true;
        }
        catch (URISyntaxException ex) {
            logger.log(Level.SEVERE, "NCLS-MNTG-00105", ex);
        }
    }

    private void loadXMLProviders(File xmlProvidersDir) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };
        File[] files = xmlProvidersDir.listFiles(filter);
        if (files == null) {
            return;
        }
        for (File file : files) {
            HK2Module module;
            int index;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found the provider xml - " + file.getAbsolutePath());
            }
            if ((index = file.getName().indexOf("-:")) == -1) continue;
            String moduleName = file.getName().substring(0, index);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" The provider xml belongs to - \"" + moduleName + "\"");
            }
            if (!this.map.containsKey(moduleName)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" HK2Module found (containsKey)");
            }
            if ((module = this.map.get(moduleName)) == null) {
                logger.log(Level.SEVERE, "NCLS-MNTG-00005", new Object[]{moduleName});
                continue;
            }
            ClassLoader mcl = module.getClassLoader();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ModuleClassLoader = " + String.valueOf(mcl));
                logger.fine("XML File path = " + file.getAbsolutePath());
            }
            this.processProbeProviderXML(mcl, file.getAbsolutePath(), false);
        }
    }

    private void processProbeProviderClass(Class cls) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("processProbeProviderClass for " + String.valueOf(cls));
        }
        try {
            this.probeProviderFactory.getProbeProvider(cls);
        }
        catch (InstantiationException ex) {
            logger.log(Level.SEVERE, "NCLS-MNTG-00104", ex);
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.SEVERE, "NCLS-MNTG-00104", ex);
        }
    }

    private void processProbeProviderXML(ClassLoader mcl, String xname, boolean inBundle) {
        this.probeProviderFactory.processXMLProbeProviders(mcl, xname, inBundle);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] propertyChangeEvents) {
        StatsProviderRegistry spr;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" spmd = " + String.valueOf((Object)this.spmd));
        }
        StatsProviderRegistry statsProviderRegistry = spr = this.spmd == null ? null : this.spmd.getStatsProviderRegistry();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("spr = " + String.valueOf(spr));
        }
        for (PropertyChangeEvent event : propertyChangeEvents) {
            boolean oldEnabled;
            if (event == null || !this.isCurrentInstanceMatchingTarget(event)) continue;
            String propName = event.getPropertyName();
            Object oldVal = event.getOldValue();
            Object newVal = event.getNewValue();
            if (newVal == null || newVal.equals(oldVal) || !this.ok(propName)) continue;
            String level_change_mesg = "Level change event received, {0} New Level = {1}, Old Level = {2}";
            if (event.getSource() instanceof ModuleMonitoringLevels) {
                String oldEnabled2;
                String newEnabled = newVal.toString().toUpperCase(Locale.ENGLISH);
                String string = oldEnabled2 = oldVal == null ? "OFF" : oldVal.toString().toUpperCase(Locale.ENGLISH);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, level_change_mesg, new Object[]{propName, newEnabled, oldEnabled2});
                }
                if (newEnabled.equals(oldEnabled2)) continue;
                this.handleLevelChange(propName, newEnabled);
                continue;
            }
            if (event.getSource() instanceof ContainerMonitoring) {
                String oldEnabled3;
                ContainerMonitoring cm = (ContainerMonitoring)event.getSource();
                String newEnabled = newVal.toString().toUpperCase(Locale.ENGLISH);
                String string = oldEnabled3 = oldVal == null ? "OFF" : oldVal.toString().toUpperCase(Locale.ENGLISH);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, level_change_mesg, new Object[]{propName, newEnabled, oldEnabled3});
                }
                if (newEnabled.equals(oldEnabled3)) continue;
                this.handleLevelChange(cm.getName(), newEnabled);
                continue;
            }
            if (!(event.getSource() instanceof MonitoringService)) continue;
            boolean newEnabled = Boolean.parseBoolean(newVal.toString());
            boolean bl = oldVal == null ? !newEnabled : (oldEnabled = Boolean.parseBoolean(oldVal.toString()));
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, level_change_mesg, new Object[]{propName, newEnabled, oldEnabled});
            }
            if (newEnabled == oldEnabled) continue;
            this.handleServiceChange(spr, propName, newEnabled);
        }
        return null;
    }

    private boolean isCurrentInstanceMatchingTarget(PropertyChangeEvent event) {
        ConfigBeanProxy proxy;
        if (this.serverEnv.isInstance()) {
            return true;
        }
        for (proxy = (ConfigBeanProxy)event.getSource(); proxy != null && !(proxy instanceof Config); proxy = proxy.getParent()) {
        }
        if (proxy != null) {
            Config config = (Config)proxy;
            return config.isDas();
        }
        return false;
    }

    private void handleLevelChange(String propName, String enabledStr) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("In handleLevelChange(), spmd = " + String.valueOf((Object)this.spmd) + "  Enabled=" + enabledStr);
        }
        if (!this.ok(propName)) {
            return;
        }
        if (!this.monitoringEnabled && !"OFF".equals(enabledStr)) {
            this.enableMonitoring(true);
        }
        if (this.spmd == null) {
            return;
        }
        if (this.parseLevelsBoolean(enabledStr)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Enabling {0} monitoring to {1}", new Object[]{propName, enabledStr});
            }
            try {
                this.spmd.enableStatsProviders(propName);
            }
            catch (RuntimeException rte) {
                logger.log(Level.INFO, "NCLS-MNTG-00001", rte);
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Disabling {0} monitoring", propName);
            }
            this.spmd.disableStatsProviders(propName);
        }
    }

    private void handleServiceChange(StatsProviderRegistry spr, String propName, boolean enabled) {
        if (!this.ok(propName)) {
            return;
        }
        if (propName.equals("mbean-enabled")) {
            if (spr == null) {
                return;
            }
            if (enabled) {
                logger.log(Level.INFO, "NCLS-MNTG-00109");
                this.spmd.registerAllGmbal();
            } else {
                logger.log(Level.INFO, "NCLS-MNTG-00110");
                this.spmd.unregisterAllGmbal();
            }
        } else if (propName.equals("dtrace-enabled")) {
            logger.log(Level.INFO, "NCLS-MNTG-00111");
            this.probeProviderFactory.dtraceEnabledChanged(enabled);
        } else if (propName.equals("monitoring-enabled")) {
            this.probeProviderFactory.monitoringEnabledChanged(enabled);
            if (enabled) {
                logger.log(Level.INFO, "NCLS-MNTG-00112");
                this.enableMonitoring(true);
            } else {
                logger.log(Level.INFO, "NCLS-MNTG-00113");
                this.disableMonitoringForProbeProviders();
                if (this.spmd != null) {
                    this.spmd.disableAllStatsProviders();
                }
            }
        }
    }

    private void enableMonitoringForProbeProviders(boolean isDiscoverXMLProviders) {
        this.discoverProbeProviders();
        this.registry.register(this);
        if (isDiscoverXMLProviders) {
            this.discoverXMLProviders();
        }
        this.setStatsProviderManagerDelegate();
        this.probeProviderFactory.addProbeProviderEventListener((ProbeProviderEventListener)new ProcessProbes());
    }

    private void disableMonitoringForProbeProviders() {
        this.registry.unregister(this);
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private boolean parseLevelsBoolean(String s) {
        return !this.ok(s) || !s.equals("OFF");
    }

    private class ProcessProbes
    implements ProbeProviderEventListener {
        private ProcessProbes() {
        }

        public <T> void probeProviderAdded(String moduleProviderName, String moduleName, String probeProviderName, String invokerId, Class<T> providerClazz, T provider) {
            MonitoringBootstrap.this.handleFutureStatsProviders();
        }
    }
}

