/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BinaryLogicalOperatorNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class IsNode
extends BinaryLogicalOperatorNode {
    private boolean notMe;

    IsNode(ValueNode valueNode, ValueNode valueNode2, boolean bl, ContextManager contextManager) {
        super(valueNode, valueNode2, "is", contextManager);
        this.notMe = bl;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        super.bindExpression(fromList, subqueryList, list);
        this.leftOperand.checkIsBoolean();
        this.rightOperand.checkIsBoolean();
        this.setType(this.leftOperand.getTypeServices());
        return this;
    }

    @Override
    ValueNode eliminateNots(boolean bl) throws StandardException {
        if (bl) {
            this.notMe = !this.notMe;
        }
        this.leftOperand = this.leftOperand.eliminateNots(false);
        this.rightOperand = this.rightOperand.eliminateNots(false);
        return this;
    }

    @Override
    public ValueNode putAndsOnTop() throws StandardException {
        this.leftOperand = this.leftOperand.putAndsOnTop();
        this.rightOperand = this.rightOperand.putAndsOnTop();
        return this;
    }

    @Override
    public boolean verifyPutAndsOnTop() {
        return this.leftOperand.verifyPutAndsOnTop() && this.rightOperand.verifyPutAndsOnTop();
    }

    @Override
    public ValueNode changeToCNF(boolean bl) throws StandardException {
        this.leftOperand = this.leftOperand.changeToCNF(false);
        this.rightOperand = this.rightOperand.changeToCNF(false);
        return this;
    }

    @Override
    public boolean verifyChangeToCNF() {
        return this.leftOperand.verifyChangeToCNF() && this.rightOperand.verifyChangeToCNF();
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        String string = this.notMe ? "isNot" : "is";
        this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder);
        this.rightOperand.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.BooleanDataValue", string, "org.apache.derby.iapi.types.BooleanDataValue", 1);
    }
}

