/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.data.provider.RowKey;
import com.sun.webui.jsf.component.TableRowGroup;
import com.sun.webui.jsf.util.MessageUtil;
import jakarta.el.ValueExpression;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIData;
import jakarta.faces.component.UIForm;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.FacesEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public final class Form
extends UIForm {
    private VirtualFormDescriptor submittedVirtualForm;
    private static final String VF_DELIM_1 = ",";
    private static final String VF_DELIM_2 = "|";
    private static final String ID_SEP = String.valueOf(':');
    public static final char ID_WILD_CHAR = '*';
    private static final String ID_WILD = String.valueOf('*');
    private transient Map<EditableValueHolder, Object> erasedMap = new HashMap<EditableValueHolder, Object>();
    private transient Set<EditableValueHolder> nonDefaultRetainStatusEvhs = new HashSet<EditableValueHolder>();
    private static final boolean DEFAULT_RETAIN_STATUS = true;
    private boolean autoComplete = false;
    private boolean autoCompleteSet = false;
    private String enctype = null;
    private VirtualFormDescriptor[] internalVirtualForms = null;
    private String onClick = null;
    private String onDblClick = null;
    private String onKeyDown = null;
    private String onKeyPress = null;
    private String onKeyUp = null;
    private String onMouseDown = null;
    private String onMouseMove = null;
    private String onMouseOut = null;
    private String onMouseOver = null;
    private String onMouseUp = null;
    private String onReset = null;
    private String onSubmit = null;
    private String style = null;
    private String styleClass = null;
    private String target = null;
    private VirtualFormDescriptor[] virtualForms = null;
    private String virtualFormsConfig = null;
    private boolean visible = false;
    private boolean visibleSet = false;

    public Form() {
        this.setRendererType("com.sun.webui.jsf.Form");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.Form";
    }

    public void setId(String id) {
        super.setId(id);
    }

    public void setRendered(boolean rendered) {
        super.setRendered(rendered);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.submittedVirtualForm = null;
        this.erasedMap.clear();
        this.decode(context);
        if (!this.isSubmitted()) {
            return;
        }
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processDecodes(context);
        }
        if (this.submittedVirtualForm != null && !Form.childrenAreKnownToParticipate((UIComponent)this, this.submittedVirtualForm)) {
            this.eraseVirtualFormNonParticipants((UIComponent)this, null, null);
        }
    }

    public void queueEvent(FacesEvent event) {
        UIComponent sourceComp;
        VirtualFormDescriptor virtualFormComponentSubmits;
        FacesEvent relevantEvent = event;
        if (event instanceof TableRowGroup.WrapperEvent) {
            TableRowGroup.WrapperEvent wrapperEvent = (TableRowGroup.WrapperEvent)event;
            relevantEvent = wrapperEvent.getFacesEvent();
        }
        if (relevantEvent instanceof ActionEvent && this.submittedVirtualForm == null && (virtualFormComponentSubmits = this.getVFormCompSubmits(sourceComp = relevantEvent.getComponent())) != null) {
            this.submittedVirtualForm = virtualFormComponentSubmits;
        }
        super.queueEvent(event);
    }

    public void setSubmittedVirtualForm(VirtualFormDescriptor vfd) {
        if (this.submittedVirtualForm == null && vfd != null) {
            this.submittedVirtualForm = vfd;
        }
    }

    public void setVirtualForms(VirtualFormDescriptor[] vfds) {
        this.setVirtualForms(vfds, true);
    }

    private void setVirtualForms(VirtualFormDescriptor[] vfds, boolean sync) {
        this.doSetVirtualForms(vfds);
        if (sync) {
            String configStr = Form.generateVFormsConfig(vfds);
            this.setVirtualFormsConfig(configStr, false);
        }
    }

    public void setVirtualFormsConfig(String configStr) {
        this.setVirtualFormsConfig(configStr, true);
    }

    private void setVirtualFormsConfig(String configStr, boolean sync) {
        this.doSetVirtualFormsConfig(configStr);
        if (sync) {
            VirtualFormDescriptor[] vfds = Form.generateVirtualForms(configStr);
            this.setVirtualForms(vfds, false);
        }
    }

    private VirtualFormDescriptor getVFormCompSubmitsByFQId(String fqId) {
        if (!Form.isValidFullyQualifiedId(fqId)) {
            return null;
        }
        VirtualFormDescriptor vfd = this.getVFormCompSubmitsByFQId(fqId, this.getVirtualForms());
        if (vfd != null) {
            return vfd;
        }
        vfd = this.getVFormCompSubmitsByFQId(fqId, this.getInternalVirtualForms());
        return vfd;
    }

    private VirtualFormDescriptor getVFormCompSubmitsByFQId(String fqId, VirtualFormDescriptor[] vfds) {
        if (vfds == null || vfds.length < 1) {
            return null;
        }
        String currentFqId = fqId;
        while (currentFqId.length() > 0) {
            for (int v = 0; v < vfds.length; ++v) {
                VirtualFormDescriptor vfd = vfds[v];
                String[] submitters = vfd.getSubmittingIds();
                for (int s = 0; submitters != null && s < submitters.length; ++s) {
                    boolean fqIdMatches;
                    String submitter = submitters[s];
                    if (submitter == null) continue;
                    String wildSuffix = ID_SEP + ID_WILD;
                    if (submitter.endsWith(wildSuffix)) {
                        submitter = submitter.substring(0, submitter.length() - wildSuffix.length());
                    }
                    if (submitter.length() < 1 || !(fqIdMatches = Form.fQIdMatchesPattern(currentFqId, submitter))) continue;
                    return vfd;
                }
            }
            int lastIndexOfSep = currentFqId.lastIndexOf(ID_SEP);
            currentFqId = currentFqId.substring(0, lastIndexOfSep);
        }
        return null;
    }

    private int getVirtualFormCount() {
        VirtualFormDescriptor[] vfds = this.getVirtualForms();
        VirtualFormDescriptor[] ivfds = this.getInternalVirtualForms();
        int count = vfds == null ? 0 : vfds.length;
        if (ivfds == null) {
            return count;
        }
        return count + ivfds.length;
    }

    private VirtualFormDescriptor getVFormCompSubmits(UIComponent component) {
        if (this.getVirtualFormCount() < 1) {
            return null;
        }
        String fqId = Form.getFullyQualifiedId(component);
        VirtualFormDescriptor vfd = this.getVFormCompSubmitsByFQId(fqId);
        return vfd;
    }

    public VirtualFormDescriptor getVFormCompSubmits(String id) {
        if (this.getVirtualFormCount() < 1) {
            return null;
        }
        if (Form.isValidFullyQualifiedId(id)) {
            return this.getVFormCompSubmitsByFQId(id);
        }
        UIComponent component = this.findComponentById(id);
        return this.getVFormCompSubmits(component);
    }

    public UIComponent findComponentById(String id) {
        if (id == null) {
            return null;
        }
        if (id.length() == 0 || id.endsWith(ID_WILD) || !id.equals(ID_SEP) && id.endsWith(ID_SEP)) {
            return null;
        }
        String fqId = Form.getFullyQualifiedId((UIComponent)this);
        if (Form.fQIdMatchesPattern(fqId, id)) {
            return this;
        }
        return this.searchKidsRecursivelyForId((UIComponent)this, id);
    }

    private UIComponent searchKidsRecursivelyForId(UIComponent parent, String id) {
        Iterator kids = parent.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            String fqId = Form.getFullyQualifiedId(kid);
            boolean fqIdMatches = Form.fQIdMatchesPattern(fqId, id);
            if (fqIdMatches) {
                return kid;
            }
            UIComponent match = this.searchKidsRecursivelyForId(kid, id);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private boolean participatesInSubmittedVirtualForm(UIComponent component) {
        if (this.submittedVirtualForm == null) {
            return false;
        }
        String fqId = Form.getFullyQualifiedId(component);
        return this.submittedVirtualForm.hasParticipant(fqId);
    }

    public static VirtualFormDescriptor[] generateVirtualForms(String configStr) {
        if (configStr == null) {
            return null;
        }
        String cfg = configStr;
        if ((cfg = cfg.trim()).length() < 1) {
            return new VirtualFormDescriptor[0];
        }
        StringTokenizer st = new StringTokenizer(cfg, VF_DELIM_1);
        ArrayList<String> vfs = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String vf = st.nextToken();
            if ((vf = vf.trim()).length() <= 0) continue;
            vfs.add(vf);
        }
        ArrayList<VirtualFormDescriptor> descriptors = new ArrayList<VirtualFormDescriptor>();
        for (int i = 0; i < vfs.size(); ++i) {
            String vf = (String)vfs.get(i);
            st = new StringTokenizer(vf, VF_DELIM_2);
            String[] parts = new String[3];
            for (int partIndex = 0; partIndex < parts.length && st.hasMoreTokens(); ++partIndex) {
                String part = st.nextToken();
                if ((part = part.trim()).length() <= 0) continue;
                parts[partIndex] = part;
            }
            if (parts[0] == null) continue;
            VirtualFormDescriptor vfd = new VirtualFormDescriptor();
            vfd.setName(parts[0]);
            descriptors.add(vfd);
            if (parts[1] != null) {
                String pidString = parts[1];
                st = new StringTokenizer(pidString);
                ArrayList<String> pidList = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String pid = st.nextToken();
                    pidList.add(pid.trim());
                }
                String[] pids = pidList.toArray(new String[pidList.size()]);
                vfd.setParticipatingIds(pids);
            }
            if (parts[2] == null) continue;
            String sidString = parts[2];
            st = new StringTokenizer(sidString);
            ArrayList<String> sidList = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String sid = st.nextToken();
                sidList.add(sid.trim());
            }
            String[] sids = sidList.toArray(new String[sidList.size()]);
            vfd.setSubmittingIds(sids);
        }
        return descriptors.toArray(new VirtualFormDescriptor[descriptors.size()]);
    }

    public static String generateVFormsConfig(VirtualFormDescriptor[] descs) {
        if (descs == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (VirtualFormDescriptor desc : descs) {
            String vf;
            if (desc == null || (vf = desc.toString()).length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(" , ");
            }
            sb.append(vf);
        }
        return sb.toString();
    }

    public static String getFullyQualifiedId(UIComponent component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Form) {
            return ID_SEP;
        }
        String compId = component.getId();
        if (compId == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(compId);
        boolean formEncountered = false;
        for (UIComponent currentComp = component.getParent(); currentComp != null; currentComp = currentComp.getParent()) {
            sb.insert(0, ID_SEP);
            if (currentComp instanceof Form) {
                formEncountered = true;
                break;
            }
            String currentCompId = currentComp.getId();
            if (currentCompId == null) {
                return null;
            }
            sb.insert(0, currentCompId);
        }
        if (formEncountered) {
            return sb.toString();
        }
        return null;
    }

    public static boolean isValidFullyQualifiedId(String id) {
        return id != null && id.startsWith(ID_SEP) && (id.length() == 1 || !id.endsWith(ID_SEP)) && !id.endsWith(ID_WILD) && id.indexOf(32) == -1;
    }

    public static boolean fQIdMatchesPattern(String fqId, String pattern) {
        if (!Form.isValidFullyQualifiedId(fqId)) {
            return false;
        }
        if (pattern == null || pattern.length() < 1 || pattern.indexOf(32) != -1) {
            return false;
        }
        if (pattern.endsWith(ID_SEP) && !pattern.equals(ID_SEP)) {
            return false;
        }
        String wildSuffix = ID_SEP + ID_WILD;
        int indexOfWildInPattern = pattern.indexOf(ID_WILD);
        if (indexOfWildInPattern != -1) {
            if (indexOfWildInPattern != pattern.length() - 1) {
                return false;
            }
            if (!pattern.endsWith(wildSuffix)) {
                return false;
            }
        }
        if (pattern.equals(wildSuffix)) {
            return true;
        }
        if (pattern.endsWith(wildSuffix)) {
            String patternPrefix = pattern.substring(0, pattern.length() - wildSuffix.length());
            if (patternPrefix.startsWith(ID_SEP)) {
                return fqId.equals(patternPrefix) || fqId.startsWith(patternPrefix + ID_SEP);
            }
            return fqId.endsWith(ID_SEP + patternPrefix) || fqId.contains(ID_SEP + patternPrefix + ID_SEP);
        }
        if (pattern.startsWith(ID_SEP)) {
            return fqId.equals(pattern);
        }
        return fqId.endsWith(ID_SEP + pattern);
    }

    public void addInternalVirtualForm(VirtualFormDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        VirtualFormDescriptor[] oldDescriptors = this.getInternalVirtualForms();
        if (oldDescriptors != null) {
            for (int i = 0; i < oldDescriptors.length; ++i) {
                String name;
                if (oldDescriptors[i] == null || (name = oldDescriptors[i].getName()) == null || !name.equals(descriptor.getName())) continue;
                oldDescriptors[i] = descriptor;
                return;
            }
        }
        int oldLength = oldDescriptors != null ? oldDescriptors.length : 0;
        VirtualFormDescriptor[] newDescriptors = new VirtualFormDescriptor[oldLength + 1];
        if (oldLength > 0) {
            System.arraycopy(oldDescriptors, 0, newDescriptors, 0, oldLength);
        }
        newDescriptors[oldLength] = descriptor;
        this.setInternalVirtualForms(newDescriptors);
    }

    private static boolean childrenAreKnownToParticipate(UIComponent component, VirtualFormDescriptor vfd) {
        if (vfd == null) {
            return false;
        }
        String fqId = Form.getFullyQualifiedId(component);
        if (fqId == null) {
            return false;
        }
        String[] participants = vfd.getParticipatingIds();
        for (int i = 0; participants != null && i < participants.length; ++i) {
            String participant = participants[i];
            String wildSuffix = ID_SEP + ID_WILD;
            if (participant == null || !participant.endsWith(wildSuffix) || !Form.fQIdMatchesPattern(fqId, participant)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eraseVirtualFormNonParticipants(UIComponent parent, Object[] contextualTables, Object[] contextualRows) {
        Map<EditableValueHolder, Object> map = this.erasedMap;
        synchronized (map) {
            Iterator kids = parent.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                if (kid instanceof EditableValueHolder && !this.participatesInSubmittedVirtualForm(kid)) {
                    EditableValueHolder kidEvh = (EditableValueHolder)kid;
                    Object submittedValueToErase = kidEvh.getSubmittedValue();
                    if (contextualTables == null) {
                        this.erasedMap.put(kidEvh, submittedValueToErase);
                    } else {
                        this.addTableValuesEntry(this.erasedMap, kidEvh, 0, contextualTables, contextualRows, submittedValueToErase);
                    }
                    kidEvh.setSubmittedValue(null);
                }
                if (Form.childrenAreKnownToParticipate(kid, this.submittedVirtualForm)) continue;
                if (kid instanceof UIData) {
                    UIData kidTable = (UIData)kid;
                    int originalRowIndex = kidTable.getRowIndex();
                    int rowIndex = 0;
                    kidTable.setRowIndex(rowIndex);
                    while (kidTable.isRowAvailable()) {
                        Object[] localContextualTables = Form.appendToArray(contextualTables, kidTable);
                        Object[] localContextualRows = Form.appendToArray(contextualRows, rowIndex);
                        this.eraseVirtualFormNonParticipants((UIComponent)kidTable, localContextualTables, localContextualRows);
                        kidTable.setRowIndex(++rowIndex);
                    }
                    kidTable.setRowIndex(originalRowIndex);
                    continue;
                }
                if (kid instanceof TableRowGroup) {
                    TableRowGroup group = (TableRowGroup)kid;
                    RowKey[] rowKeys = group.getRowKeys();
                    RowKey oldRowKey = group.getRowKey();
                    if (rowKeys != null) {
                        for (RowKey rowKey : rowKeys) {
                            group.setRowKey(rowKey);
                            if (!group.isRowAvailable()) continue;
                            Object[] localContextualTables = Form.appendToArray(contextualTables, (Object)group);
                            Object[] localContextualRows = Form.appendToArray(contextualRows, rowKey);
                            this.eraseVirtualFormNonParticipants((UIComponent)group, localContextualTables, localContextualRows);
                        }
                    }
                    group.setRowKey(oldRowKey);
                    continue;
                }
                this.eraseVirtualFormNonParticipants(kid, contextualTables, contextualRows);
            }
        }
    }

    private void addTableValuesEntry(Map map, Object mapKey, int c, Object[] contextualTables, Object[] contextualRows, Object submittedValueToErase) {
        TableValues tv = (TableValues)map.get(mapKey);
        if (tv == null) {
            tv = new TableValues(contextualTables[c]);
            map.put(mapKey, tv);
        }
        Map values = tv.getValues();
        if (c == contextualTables.length - 1) {
            values.put(contextualRows[c], submittedValueToErase);
        } else {
            this.addTableValuesEntry(values, contextualRows[c], c + 1, contextualTables, contextualRows, submittedValueToErase);
        }
    }

    private static Object[] appendToArray(Object[] array, Object item) {
        Object[] result;
        if (array == null) {
            result = new Object[]{item};
        } else {
            result = new Object[array.length + 1];
            System.arraycopy(array, 0, result, 0, array.length);
            result[array.length] = item;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreNonParticipatingSubmittedValues() {
        Map<EditableValueHolder, Object> map = this.erasedMap;
        synchronized (map) {
            for (Map.Entry<EditableValueHolder, Object> entry : this.erasedMap.entrySet()) {
                EditableValueHolder evh = entry.getKey();
                boolean evhAppearsInSet = this.nonDefaultRetainStatusEvhs.contains(evh);
                boolean discards = evhAppearsInSet;
                if (discards) continue;
                Object erasedMapValue = entry.getValue();
                if (erasedMapValue instanceof TableValues) {
                    TableValues tv = (TableValues)erasedMapValue;
                    this.restoreTableValues(tv, evh);
                    continue;
                }
                evh.setSubmittedValue(erasedMapValue);
            }
            this.nonDefaultRetainStatusEvhs.clear();
        }
    }

    private void restoreTableValues(TableValues tv, EditableValueHolder evh) {
        TableRowGroup rowGroup;
        Iterator<Object> rowIterator;
        Object oldRow;
        UIData uidata;
        Object table = tv.getTable();
        Map values = tv.getValues();
        if (table instanceof UIData) {
            uidata = (UIData)table;
            int iOldRow = uidata.getRowIndex();
            oldRow = iOldRow;
            ArrayList rowList = new ArrayList();
            rowList.addAll(values.keySet());
            Collections.sort(rowList);
            rowIterator = rowList.iterator();
        } else {
            rowGroup = (TableRowGroup)((Object)table);
            oldRow = rowGroup.getRowKey();
            rowIterator = values.keySet().iterator();
        }
        while (rowIterator.hasNext()) {
            Object row = rowIterator.next();
            if (table instanceof UIData) {
                UIData uidata2 = (UIData)table;
                Integer rowInt = (Integer)row;
                int iRow = rowInt;
                uidata2.setRowIndex(iRow);
            } else {
                TableRowGroup rowGroup2 = (TableRowGroup)((Object)table);
                RowKey rowKey = (RowKey)row;
                rowGroup2.setRowKey(rowKey);
            }
            Object rowValue = values.get(row);
            if (rowValue instanceof TableValues) {
                TableValues rowValueTv = (TableValues)rowValue;
                this.restoreTableValues(rowValueTv, evh);
                continue;
            }
            evh.setSubmittedValue(rowValue);
        }
        if (table instanceof UIData) {
            uidata = (UIData)table;
            Integer oldRowInt = (Integer)oldRow;
            int iOldRow = oldRowInt;
            uidata.setRowIndex(iOldRow);
        } else {
            rowGroup = (TableRowGroup)((Object)table);
            Object oldRowKey = oldRow;
            rowGroup.setRowKey((RowKey)oldRowKey);
        }
    }

    public void discardSubmittedValue(EditableValueHolder inputField) {
        UIComponent uicInputField;
        if (inputField == null) {
            throw new IllegalArgumentException(Form.getMessage("nullInputField", null));
        }
        if (inputField instanceof UIComponent && this.participatesInSubmittedVirtualForm(uicInputField = (UIComponent)inputField)) {
            throw new IllegalArgumentException(Form.getMessage("supplyNonParticipatingInputField", new Object[]{uicInputField.getId(), "discardSubmittedValue"}));
        }
        ArrayList<EditableValueHolder> evhCollection = new ArrayList<EditableValueHolder>();
        evhCollection.add(inputField);
        this.setRetainWhenNonParticipating(evhCollection, false);
    }

    public void discardSubmittedValues(String virtualFormName) {
        VirtualFormDescriptor vfd = this.getVFormByName(virtualFormName);
        if (vfd == null) {
            throw new IllegalArgumentException(Form.getMessage("unrecognizedVfName", new Object[]{virtualFormName}));
        }
        if (vfd == this.submittedVirtualForm) {
            throw new IllegalArgumentException(Form.getMessage("supplyUnsubmittedVirtualForm", new Object[]{virtualFormName, "discardSubmittedValues"}));
        }
        this.setRetainWhenNonParticipating(vfd, false);
    }

    private void setRetainWhenNonParticipating(VirtualFormDescriptor vfd, boolean retain) {
        String[] pids = vfd.getParticipatingIds();
        if (pids == null || pids.length < 1) {
            return;
        }
        ArrayList<EditableValueHolder> evhList = new ArrayList<EditableValueHolder>();
        for (String pid : pids) {
            UIComponent uic = this.findComponentById(pid);
            if (!(uic instanceof EditableValueHolder)) continue;
            evhList.add((EditableValueHolder)uic);
        }
        this.setRetainWhenNonParticipating(evhList, retain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRetainWhenNonParticipating(List<EditableValueHolder> evhs, boolean retain) {
        if (evhs == null || evhs.size() < 1) {
            return;
        }
        Map<EditableValueHolder, Object> map = this.erasedMap;
        synchronized (map) {
            boolean shouldContain;
            boolean bl = shouldContain = !retain;
            if (shouldContain) {
                this.nonDefaultRetainStatusEvhs.addAll(evhs);
            } else {
                this.nonDefaultRetainStatusEvhs.removeAll(evhs);
            }
        }
    }

    private VirtualFormDescriptor getVFormByName(String vFormName) {
        if (vFormName == null) {
            return null;
        }
        VirtualFormDescriptor[] vfds = this.getVirtualForms();
        for (int i = 0; vfds != null && i < vfds.length; ++i) {
            if (!vFormName.equals(vfds[i].getName())) continue;
            return vfds[i];
        }
        return null;
    }

    private static String getMessage(String key, Object[] args) {
        String baseName = Form.class.getPackage().getName() + ".Bundle";
        return MessageUtil.getMessage(FacesContext.getCurrentInstance(), baseName, key, args);
    }

    public String getEnctype() {
        String encType = this.doGetEnctype();
        if (encType == null || encType.length() == 0) {
            encType = "application/x-www-form-urlencoded";
            this.setEnctype(encType);
        }
        return encType;
    }

    public boolean isAutoComplete() {
        if (this.autoCompleteSet) {
            return this.autoComplete;
        }
        ValueExpression vb = this.getValueExpression("autoComplete");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setAutoComplete(boolean newAutoComplete) {
        this.autoComplete = newAutoComplete;
        this.autoCompleteSet = true;
    }

    private String doGetEnctype() {
        if (this.enctype != null) {
            return this.enctype;
        }
        ValueExpression vb = this.getValueExpression("enctype");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return "application/x-www-form-urlencoded";
    }

    public void setEnctype(String newEnctype) {
        this.enctype = newEnctype;
    }

    public VirtualFormDescriptor[] getInternalVirtualForms() {
        if (this.internalVirtualForms != null) {
            return this.internalVirtualForms;
        }
        ValueExpression vb = this.getValueExpression("internalVirtualForms");
        if (vb != null) {
            return (VirtualFormDescriptor[])vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setInternalVirtualForms(VirtualFormDescriptor[] newInternalVirtualForms) {
        this.internalVirtualForms = newInternalVirtualForms;
    }

    public String getOnClick() {
        if (this.onClick != null) {
            return this.onClick;
        }
        ValueExpression vb = this.getValueExpression("onClick");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnClick(String newOnClick) {
        this.onClick = newOnClick;
    }

    public String getOnDblClick() {
        if (this.onDblClick != null) {
            return this.onDblClick;
        }
        ValueExpression vb = this.getValueExpression("onDblClick");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnDblClick(String newOnDblClick) {
        this.onDblClick = newOnDblClick;
    }

    public String getOnKeyDown() {
        if (this.onKeyDown != null) {
            return this.onKeyDown;
        }
        ValueExpression vb = this.getValueExpression("onKeyDown");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyDown(String newOnKeyDown) {
        this.onKeyDown = newOnKeyDown;
    }

    public String getOnKeyPress() {
        if (this.onKeyPress != null) {
            return this.onKeyPress;
        }
        ValueExpression vb = this.getValueExpression("onKeyPress");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyPress(String newOnKeyPress) {
        this.onKeyPress = newOnKeyPress;
    }

    public String getOnKeyUp() {
        if (this.onKeyUp != null) {
            return this.onKeyUp;
        }
        ValueExpression vb = this.getValueExpression("onKeyUp");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyUp(String newOnKeyUp) {
        this.onKeyUp = newOnKeyUp;
    }

    public String getOnMouseDown() {
        if (this.onMouseDown != null) {
            return this.onMouseDown;
        }
        ValueExpression vb = this.getValueExpression("onMouseDown");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseDown(String newOnMouseDown) {
        this.onMouseDown = newOnMouseDown;
    }

    public String getOnMouseMove() {
        if (this.onMouseMove != null) {
            return this.onMouseMove;
        }
        ValueExpression vb = this.getValueExpression("onMouseMove");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseMove(String newOnMouseMove) {
        this.onMouseMove = newOnMouseMove;
    }

    public String getOnMouseOut() {
        if (this.onMouseOut != null) {
            return this.onMouseOut;
        }
        ValueExpression vb = this.getValueExpression("onMouseOut");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseOut(String newOnMouseOut) {
        this.onMouseOut = newOnMouseOut;
    }

    public String getOnMouseOver() {
        if (this.onMouseOver != null) {
            return this.onMouseOver;
        }
        ValueExpression vb = this.getValueExpression("onMouseOver");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseOver(String newOnMouseOver) {
        this.onMouseOver = newOnMouseOver;
    }

    public String getOnMouseUp() {
        if (this.onMouseUp != null) {
            return this.onMouseUp;
        }
        ValueExpression vb = this.getValueExpression("onMouseUp");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseUp(String newOnMouseUp) {
        this.onMouseUp = newOnMouseUp;
    }

    public String getOnReset() {
        if (this.onReset != null) {
            return this.onReset;
        }
        ValueExpression vb = this.getValueExpression("onReset");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnReset(String newOnReset) {
        this.onReset = newOnReset;
    }

    public String getOnSubmit() {
        if (this.onSubmit != null) {
            return this.onSubmit;
        }
        ValueExpression vb = this.getValueExpression("onSubmit");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnSubmit(String newOnSubmit) {
        this.onSubmit = newOnSubmit;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression vb = this.getValueExpression("style");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression vb = this.getValueExpression("styleClass");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String newStyleClass) {
        this.styleClass = newStyleClass;
    }

    public String getTarget() {
        if (this.target != null) {
            return this.target;
        }
        ValueExpression vb = this.getValueExpression("target");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setTarget(String newTarget) {
        this.target = newTarget;
    }

    public VirtualFormDescriptor[] getVirtualForms() {
        if (this.virtualForms != null) {
            return this.virtualForms;
        }
        ValueExpression vb = this.getValueExpression("virtualForms");
        if (vb != null) {
            return (VirtualFormDescriptor[])vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    private void doSetVirtualForms(VirtualFormDescriptor[] newVirtualForms) {
        this.virtualForms = newVirtualForms;
    }

    public String getVirtualFormsConfig() {
        if (this.virtualFormsConfig != null) {
            return this.virtualFormsConfig;
        }
        ValueExpression vb = this.getValueExpression("virtualFormsConfig");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    private void doSetVirtualFormsConfig(String newVirtualFormsConfig) {
        this.virtualFormsConfig = newVirtualFormsConfig;
    }

    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.autoComplete = (Boolean)values[1];
        this.autoCompleteSet = (Boolean)values[2];
        this.enctype = (String)values[3];
        this.internalVirtualForms = (VirtualFormDescriptor[])values[4];
        this.onClick = (String)values[5];
        this.onDblClick = (String)values[6];
        this.onKeyDown = (String)values[7];
        this.onKeyPress = (String)values[8];
        this.onKeyUp = (String)values[9];
        this.onMouseDown = (String)values[10];
        this.onMouseMove = (String)values[11];
        this.onMouseOut = (String)values[12];
        this.onMouseOver = (String)values[13];
        this.onMouseUp = (String)values[14];
        this.onReset = (String)values[15];
        this.onSubmit = (String)values[16];
        this.style = (String)values[17];
        this.styleClass = (String)values[18];
        this.target = (String)values[19];
        this.virtualForms = (VirtualFormDescriptor[])values[20];
        this.virtualFormsConfig = (String)values[21];
        this.visible = (Boolean)values[22];
        this.visibleSet = (Boolean)values[23];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.autoComplete ? Boolean.TRUE : Boolean.FALSE, this.autoCompleteSet ? Boolean.TRUE : Boolean.FALSE, this.enctype, this.internalVirtualForms, this.onClick, this.onDblClick, this.onKeyDown, this.onKeyPress, this.onKeyUp, this.onMouseDown, this.onMouseMove, this.onMouseOut, this.onMouseOver, this.onMouseUp, this.onReset, this.onSubmit, this.style, this.styleClass, this.target, this.virtualForms, this.virtualFormsConfig, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visibleSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }

    private static final class TableValues {
        private final Object table;
        private final Map values;

        TableValues(Object newTable) {
            this.table = newTable;
            this.values = new HashMap();
        }

        public Object getTable() {
            return this.table;
        }

        public Map getValues() {
            return this.values;
        }
    }

    public static final class VirtualFormDescriptor
    implements Serializable {
        private static final long serialVersionUID = 7348674581125090187L;
        private String name;
        private String[] participatingIds;
        private String[] submittingIds;

        public VirtualFormDescriptor() {
        }

        public VirtualFormDescriptor(String newName) {
            this.setName(newName);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String newName) {
            if (newName == null) {
                throw new IllegalArgumentException(Form.getMessage("nullVfName", null));
            }
            String zName = newName.trim();
            if (zName.length() < 1) {
                throw new IllegalArgumentException(Form.getMessage("vfNameWhitespaceOnly", null));
            }
            this.name = zName;
        }

        public String[] getParticipatingIds() {
            return this.participatingIds;
        }

        public void setParticipatingIds(String[] newParticipatingIds) {
            for (int i = 0; newParticipatingIds != null && i < newParticipatingIds.length; ++i) {
                if (newParticipatingIds[i] == null) {
                    throw new IllegalArgumentException(Form.getMessage("nullParticipatingIdAtIndex", new Object[]{i}));
                }
                newParticipatingIds[i] = newParticipatingIds[i].trim();
                if (newParticipatingIds[i].length() >= 1) continue;
                throw new IllegalArgumentException(Form.getMessage("whitespaceOnlyParticipatingIdAtIndex", new Object[]{i}));
            }
            this.participatingIds = newParticipatingIds;
        }

        public String[] getSubmittingIds() {
            return this.submittingIds;
        }

        public void setSubmittingIds(String[] newSubmittingIds) {
            for (int i = 0; newSubmittingIds != null && i < newSubmittingIds.length; ++i) {
                if (newSubmittingIds[i] == null) {
                    throw new IllegalArgumentException(Form.getMessage("nullSubmittingIdAtIndex", new Object[]{i}));
                }
                newSubmittingIds[i] = newSubmittingIds[i].trim();
                if (newSubmittingIds[i].length() >= 1) continue;
                throw new IllegalArgumentException(Form.getMessage("whitespaceOnlySubmittingIdAtIndex", new Object[]{i}));
            }
            this.submittingIds = newSubmittingIds;
        }

        public boolean isSubmittedBy(String fqId) {
            if (!Form.isValidFullyQualifiedId(fqId)) {
                return false;
            }
            for (int i = 0; this.submittingIds != null && i < this.submittingIds.length; ++i) {
                if (!Form.fQIdMatchesPattern(fqId, this.submittingIds[i])) continue;
                return true;
            }
            return false;
        }

        public boolean hasParticipant(String fqId) {
            if (!Form.isValidFullyQualifiedId(fqId)) {
                return false;
            }
            for (int i = 0; this.participatingIds != null && i < this.participatingIds.length; ++i) {
                if (!Form.fQIdMatchesPattern(fqId, this.participatingIds[i])) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            int i;
            if (this.name == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.name);
            sb.append(" | ");
            for (i = 0; this.participatingIds != null && i < this.participatingIds.length; ++i) {
                sb.append(this.participatingIds[i]);
                sb.append(' ');
            }
            sb.append("| ");
            for (i = 0; this.submittingIds != null && i < this.submittingIds.length; ++i) {
                sb.append(this.submittingIds[i]);
                sb.append(' ');
            }
            return sb.toString().trim();
        }
    }
}

