/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work.context;

import com.sun.enterprise.connectors.work.LogFacade;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.util.Utility;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.glassfish.epicyro.config.helper.Caller;
import org.glassfish.epicyro.config.helper.CallerPrincipal;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.UserNameAndPassword;

public class ConnectorCallbackHandler
implements CallbackHandler {
    private static final Logger logger = LogFacade.getLogger();
    private static final List<String> supportedCallbacks = List.of(GroupPrincipalCallback.class.getName(), CallerPrincipalCallback.class.getName());
    @LogMessageInfo(message="Unsupported callback {0} during credential mapping.", comment="Unsupported callback class.", level="WARNING", cause="Resource adapter has used a callback that is not supported by application server.", action="Check whether the callback in question is supported by application server.", publish=true)
    private static final String RAR_UNSUPPORT_CALLBACK = "AS-RAR-05012";
    private final CallbackHandler handler;
    private boolean needMapping;
    private final Map<Principal, Principal> securityMap;
    private final Subject executionSubject;

    public ConnectorCallbackHandler(Subject executionSubject, CallbackHandler handler, Map<Principal, Principal> securityMap) {
        this.handler = handler;
        if (!Utility.isEmpty(securityMap)) {
            this.needMapping = true;
            logger.finest("translation required for security info ");
        } else {
            logger.finest("no translation required for security info ");
        }
        this.executionSubject = executionSubject;
        this.securityMap = securityMap;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        Callback[] mappedCallbacks = callbacks;
        if (callbacks != null) {
            ArrayList<Callback> asCallbacks = new ArrayList<Callback>();
            boolean hasCallerPrincipalCallback = this.hasCallerPrincipalCallback(callbacks);
            if (this.needMapping) {
                for (Callback callback : callbacks) {
                    boolean callbackSupported = false;
                    for (String supportedCallback : supportedCallbacks) {
                        try {
                            if (!Class.forName(supportedCallback).isAssignableFrom(callback.getClass())) continue;
                            callbackSupported = true;
                            asCallbacks.add(this.handleSupportedCallback(callback));
                        }
                        catch (ClassNotFoundException cnfe) {
                            logger.log(Level.FINEST, "class not found", cnfe);
                        }
                    }
                    if (callbackSupported) continue;
                    UnsupportedCallbackException uce = new UnsupportedCallbackException(callback);
                    logger.log(Level.WARNING, RAR_UNSUPPORT_CALLBACK, new Object[]{callback.getClass().getName(), uce});
                    throw uce;
                }
                mappedCallbacks = new Callback[asCallbacks.size()];
                for (int i = 0; i < asCallbacks.size(); ++i) {
                    mappedCallbacks[i] = (Callback)asCallbacks.get(i);
                }
            }
            this.handler.handle(mappedCallbacks);
            this.processResults(mappedCallbacks, hasCallerPrincipalCallback);
        }
    }

    private boolean hasCallerPrincipalCallback(Callback[] callbacks) {
        if (callbacks != null) {
            for (Callback callback : callbacks) {
                if (!(callback instanceof CallerPrincipalCallback)) continue;
                return true;
            }
        }
        return false;
    }

    private void processResults(Callback[] mappedCallbacks, boolean hasCallerPrincipalCallback) {
        if (mappedCallbacks != null) {
            Set<Principal> principals;
            Subject subject = new Subject();
            if (!hasCallerPrincipalCallback && (principals = this.executionSubject.getPrincipals()) != null && principals.size() == 1) {
                for (Principal principal : principals) {
                    Principal mappedPrincipal = null;
                    mappedPrincipal = this.needMapping ? this.getMappedPrincipal(principal, null) : principal;
                    if (mappedPrincipal == null) continue;
                    subject.getPrincipals().add(mappedPrincipal);
                }
                subject.getPublicCredentials().addAll(this.executionSubject.getPublicCredentials());
                subject.getPrivateCredentials().addAll(this.executionSubject.getPrivateCredentials());
            }
            for (Callback callback : mappedCallbacks) {
                if (callback instanceof CallerPrincipalCallback) {
                    CallerPrincipalCallback callerPrincipalCallback = (CallerPrincipalCallback)callback;
                    Caller caller = this.getCaller(callerPrincipalCallback.getSubject());
                    if (caller != null) {
                        Principal glassFishCallerPrincipal = this.getGlassFishCallerPrincipal(caller);
                        subject.getPrincipals().add(glassFishCallerPrincipal);
                        for (String group : caller.getGroups()) {
                            subject.getPrincipals().add((Principal)new Group(group));
                        }
                    }
                    this.copySubject(subject, callerPrincipalCallback.getSubject());
                    continue;
                }
                if (callback instanceof GroupPrincipalCallback) {
                    GroupPrincipalCallback groupPrincipalCallback = (GroupPrincipalCallback)callback;
                    this.copySubject(subject, groupPrincipalCallback.getSubject());
                    continue;
                }
                if (!(callback instanceof PasswordValidationCallback)) continue;
                PasswordValidationCallback passwordValidationCallback = (PasswordValidationCallback)callback;
                this.copySubject(subject, passwordValidationCallback.getSubject());
            }
            SecurityContext.setCurrent((SecurityContext)new SecurityContext(subject));
        }
    }

    private Caller getCaller(Subject subject) {
        Set<Caller> callers = subject.getPrincipals(Caller.class);
        if (callers.isEmpty()) {
            return null;
        }
        return callers.iterator().next();
    }

    private Principal getGlassFishCallerPrincipal(Caller caller) {
        Principal callerPrincipal = caller.getCallerPrincipal();
        if (!(callerPrincipal instanceof CallerPrincipal)) {
            return callerPrincipal;
        }
        if (callerPrincipal.getName() == null) {
            return SecurityContext.getDefaultCallerPrincipal();
        }
        return new UserNameAndPassword(callerPrincipal.getName());
    }

    private void copySubject(Subject target, Subject source) {
        target.getPrincipals().addAll(source.getPrincipals());
        target.getPublicCredentials().addAll(source.getPublicCredentials());
        target.getPrivateCredentials().addAll(source.getPrivateCredentials());
    }

    private Callback handleSupportedCallback(Callback callback) throws UnsupportedCallbackException {
        if (callback instanceof CallerPrincipalCallback) {
            return this.handleCallerPrincipalCallbackWithMapping((CallerPrincipalCallback)callback);
        }
        if (callback instanceof GroupPrincipalCallback) {
            return this.handleGroupPrincipalCallbackWithMapping((GroupPrincipalCallback)callback);
        }
        throw new UnsupportedCallbackException(callback);
    }

    private Callback handleCallerPrincipalCallbackWithMapping(CallerPrincipalCallback callerPrincipalCallback) {
        return new CallerPrincipalCallback(callerPrincipalCallback.getSubject(), this.getMappedPrincipal(callerPrincipalCallback.getPrincipal(), callerPrincipalCallback.getName()));
    }

    private Callback handleGroupPrincipalCallbackWithMapping(GroupPrincipalCallback groupPrincipalCallback) {
        String[] groups = groupPrincipalCallback.getGroups();
        ArrayList<String> asGroupNames = new ArrayList<String>();
        for (String groupName : groups) {
            Group mappedGroup = (Group)this.securityMap.get(new Group(groupName));
            if (mappedGroup == null) continue;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("got mapped group as [" + groupName + "] for eis-group [" + mappedGroup.getName() + "]");
            }
            asGroupNames.add(mappedGroup.getName());
        }
        String[] asGroupsString = new String[asGroupNames.size()];
        for (int i = 0; i < asGroupNames.size(); ++i) {
            asGroupsString[i] = (String)asGroupNames.get(i);
        }
        return new GroupPrincipalCallback(groupPrincipalCallback.getSubject(), asGroupsString);
    }

    private Principal getMappedPrincipal(Principal eisPrincipal, String eisName) {
        Principal asPrincipal;
        if (eisPrincipal != null) {
            asPrincipal = this.securityMap.get(eisPrincipal);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("got mapped principal as [" + String.valueOf(asPrincipal) + "] for eis-group [" + eisPrincipal.getName() + "]");
            }
        } else if (eisName != null) {
            asPrincipal = this.securityMap.get(new UserNameAndPassword(eisName));
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("got mapped principal as [" + String.valueOf(asPrincipal) + "] for eis-group [" + eisName + "]");
            }
        } else {
            asPrincipal = null;
        }
        return asPrincipal;
    }
}

