/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.util.Utility;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.SkipIfPortableExtensionPresent;
import jakarta.enterprise.inject.spi.Extension;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.cdi.CDILoggerInfo;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.InstalledLibrariesResolver;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.javaee.core.deployment.ApplicationHolder;
import org.glassfish.weld.BeanDeploymentArchiveImpl;
import org.glassfish.weld.FilteringClassLoader;
import org.glassfish.weld.RootBeanDeploymentArchive;
import org.glassfish.weld.connector.WeldUtils;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.CDI11Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.bootstrap.spi.helpers.MetadataImpl;
import org.jboss.weld.lite.extension.translator.LiteExtensionTranslator;

public class DeploymentImpl
implements CDI11Deployment {
    private static final Logger LOG = CDILoggerInfo.getLogger();
    private static final String IS_EMBEDDED_EJB_CONTAINER = "org.glassfish.ejb.embedded.active";
    private List<RootBeanDeploymentArchive> rarRootBdas;
    private List<RootBeanDeploymentArchive> ejbRootBdas;
    private List<RootBeanDeploymentArchive> warRootBdas;
    private List<RootBeanDeploymentArchive> libJarRootBdas;
    private List<BeanDeploymentArchive> beanDeploymentArchives;
    private DeploymentContext context;
    private final Map<String, BeanDeploymentArchive> idToBeanDeploymentArchive = new HashMap<String, BeanDeploymentArchive>();
    private SimpleServiceRegistry simpleServiceRegistry;
    private final Map<ClassLoader, BeanDeploymentArchive> extensionBDAMap = new HashMap<ClassLoader, BeanDeploymentArchive>();
    private Iterable<Metadata<Extension>> extensions;
    private final Collection<EjbDescriptor> deployedEjbs = new LinkedList<EjbDescriptor>();
    private ArchiveFactory archiveFactory;
    private boolean earContextAppLibBdasProcessed;

    public DeploymentImpl(ReadableArchive archive, Collection<EjbDescriptor> ejbs, DeploymentContext context, ArchiveFactory archiveFactory) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "AS-CDI-00018", new Object[]{archive.getName()});
        }
        this.archiveFactory = archiveFactory;
        this.beanDeploymentArchives = new ArrayList<BeanDeploymentArchive>();
        this.context = context;
        this.libJarRootBdas = this.scanForLibJars(archive, ejbs, context);
        if (!Utility.isEmpty(this.libJarRootBdas)) {
            return;
        }
        this.createModuleBda(archive, ejbs, context);
    }

    public BeanDeploymentArchive loadBeanDeploymentArchive(Class<?> beanClass) {
        BeanDeploymentArchiveImpl newBeanDeploymentArchive;
        BeansXml beansXml;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "AS-CDI-00020", new Object[]{beanClass});
        }
        for (BeanDeploymentArchive beanDeploymentArchive : this.beanDeploymentArchives) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "AS-CDI-00021", new Object[]{beanClass, beanDeploymentArchive.getId()});
            }
            if (((BeanDeploymentArchiveImpl)beanDeploymentArchive).getModuleBeanClasses().contains(beanClass.getName())) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "AS-CDI-00022", new Object[]{beanClass.getName(), beanDeploymentArchive});
                }
                return beanDeploymentArchive;
            }
            if (beanDeploymentArchive.getBeanDeploymentArchives().isEmpty()) continue;
            for (BeanDeploymentArchive subBeanDeploymentArchive : beanDeploymentArchive.getBeanDeploymentArchives()) {
                Collection<String> moduleBeanClassNames = ((BeanDeploymentArchiveImpl)subBeanDeploymentArchive).getModuleBeanClasses();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "AS-CDI-00023", new Object[]{beanClass, subBeanDeploymentArchive.getId()});
                }
                if (!moduleBeanClassNames.contains(beanClass.getName())) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "AS-CDI-00022", new Object[]{beanClass.getName(), subBeanDeploymentArchive});
                }
                return subBeanDeploymentArchive;
            }
        }
        ClassLoader classLoaderKey = null;
        classLoaderKey = System.getProperty(IS_EMBEDDED_EJB_CONTAINER) != null ? this.getClass().getClassLoader() : beanClass.getClassLoader();
        BeanDeploymentArchive extensionBeanDeploymentArchive = this.extensionBDAMap.get(classLoaderKey);
        if (extensionBeanDeploymentArchive != null) {
            return extensionBeanDeploymentArchive;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "AS-CDI-00024", new Object[]{beanClass});
        }
        if ((beansXml = (newBeanDeploymentArchive = new BeanDeploymentArchiveImpl(beanClass.getName(), new ArrayList(List.of(beanClass)), new CopyOnWriteArrayList<URL>(), new HashSet<EjbDescriptor>(), this.context)).getBeansXml()) != null && beansXml.getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.NONE)) {
            return null;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "AS-CDI-00025", new Object[0]);
        }
        for (BeanDeploymentArchive beanDeploymentArchive : this.beanDeploymentArchives) {
            beanDeploymentArchive.getBeanDeploymentArchives().add(newBeanDeploymentArchive);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "AS-CDI-00026", new Object[]{beanClass, newBeanDeploymentArchive});
        }
        this.beanDeploymentArchives.add(newBeanDeploymentArchive);
        this.idToBeanDeploymentArchive.put(newBeanDeploymentArchive.getId(), newBeanDeploymentArchive);
        this.extensionBDAMap.put(beanClass.getClassLoader(), newBeanDeploymentArchive);
        return newBeanDeploymentArchive;
    }

    public ServiceRegistry getServices() {
        if (this.simpleServiceRegistry == null) {
            this.simpleServiceRegistry = new SimpleServiceRegistry();
        }
        return this.simpleServiceRegistry;
    }

    public Iterable<Metadata<Extension>> getExtensions() {
        if (this.extensions != null) {
            return this.extensions;
        }
        ArrayList<Metadata<Extension>> extensionsList = new ArrayList<Metadata<Extension>>();
        final List<Class<? extends BuildCompatibleExtension>> buildExtensions = this.getBuildCompatibleExtensions();
        if (!buildExtensions.isEmpty()) {
            try {
                LiteExtensionTranslator extension = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<LiteExtensionTranslator>(){

                    @Override
                    public LiteExtensionTranslator run() {
                        return new LiteExtensionTranslator(buildExtensions, Thread.currentThread().getContextClassLoader());
                    }
                }) : new LiteExtensionTranslator(buildExtensions, Thread.currentThread().getContextClassLoader());
                extensionsList.add((Metadata<Extension>)new MetadataImpl((Object)extension));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (BeanDeploymentArchive beanDeploymentArchive : this.getBeanDeploymentArchives()) {
            if (beanDeploymentArchive instanceof RootBeanDeploymentArchive) continue;
            FilteringClassLoader classLoader = new FilteringClassLoader(((BeanDeploymentArchiveImpl)beanDeploymentArchive).getModuleClassLoaderForBDA());
            this.extensions = ((WeldBootstrap)this.context.getTransientAppMetaData("org.glassfish.weld.WeldBootstrap", WeldBootstrap.class)).loadExtensions((ClassLoader)classLoader);
            if (this.extensions == null) continue;
            for (Metadata<Extension> beanDeploymentArchiveExtension : this.extensions) {
                extensionsList.add(beanDeploymentArchiveExtension);
            }
        }
        return extensionsList;
    }

    public List<BeanDeploymentArchive> getBeanDeploymentArchives() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "AS-CDI-00019", new Object[]{this.beanDeploymentArchives});
        }
        if (!this.beanDeploymentArchives.isEmpty()) {
            return this.beanDeploymentArchives;
        }
        return Collections.emptyList();
    }

    public BeanDeploymentArchive getBeanDeploymentArchive(Class<?> beanClass) {
        if (beanClass == null) {
            return null;
        }
        ClassLoader classLoader = beanClass.getClassLoader();
        for (BeanDeploymentArchive beanDeploymentArchive : this.beanDeploymentArchives) {
            BeanDeploymentArchiveImpl beanDeploymentArchiveImpl = (BeanDeploymentArchiveImpl)beanDeploymentArchive;
            if (!beanDeploymentArchiveImpl.getKnownClasses().contains(beanClass.getName()) || !beanDeploymentArchiveImpl.getModuleClassLoaderForBDA().equals(classLoader)) continue;
            return beanDeploymentArchive;
        }
        RootBeanDeploymentArchive rootBda = this.findRootBda(classLoader, this.ejbRootBdas);
        if (rootBda == null && (rootBda = this.findRootBda(classLoader, this.warRootBdas)) == null && (rootBda = this.findRootBda(classLoader, this.libJarRootBdas)) == null) {
            rootBda = this.findRootBda(classLoader, this.rarRootBdas);
        }
        return rootBda;
    }

    public String toString() {
        StringBuilder valBuff = new StringBuilder();
        for (BeanDeploymentArchive bda : this.getBeanDeploymentArchives()) {
            valBuff.append(bda.toString());
        }
        return valBuff.toString();
    }

    public void scanArchive(ReadableArchive archive, Collection<EjbDescriptor> ejbs, DeploymentContext context) {
        if (this.libJarRootBdas == null) {
            this.libJarRootBdas = this.scanForLibJars(archive, ejbs, context);
            if (!Utility.isEmpty(this.libJarRootBdas)) {
                return;
            }
        }
        this.context = context;
        this.createModuleBda(archive, ejbs, context);
    }

    public void buildDeploymentGraph() {
        BeanDeploymentArchive rarModuleBda;
        BeanDeploymentArchive libJarModuleBda;
        if (this.ejbRootBdas != null) {
            for (RootBeanDeploymentArchive ejbRootBda : this.ejbRootBdas) {
                int idx;
                BeanDeploymentArchive ejbModuleBda = ejbRootBda.getModuleBda();
                boolean modifiedArchive = false;
                for (RootBeanDeploymentArchive otherEjbRootBda : this.ejbRootBdas) {
                    BeanDeploymentArchive otherEjbModuleBda = otherEjbRootBda.getModuleBda();
                    if (otherEjbModuleBda.getId().equals(ejbModuleBda.getId())) continue;
                    ejbRootBda.getBeanDeploymentArchives().add(otherEjbRootBda);
                    ejbRootBda.getBeanDeploymentArchives().add(otherEjbModuleBda);
                    ejbModuleBda.getBeanDeploymentArchives().add(otherEjbModuleBda);
                    modifiedArchive = true;
                }
                if (this.libJarRootBdas != null) {
                    for (RootBeanDeploymentArchive libJarRootBda : this.libJarRootBdas) {
                        libJarModuleBda = libJarRootBda.getModuleBda();
                        ejbRootBda.getBeanDeploymentArchives().add(libJarRootBda);
                        ejbRootBda.getBeanDeploymentArchives().add(libJarModuleBda);
                        ejbModuleBda.getBeanDeploymentArchives().add(libJarRootBda);
                        ejbModuleBda.getBeanDeploymentArchives().add(libJarModuleBda);
                        modifiedArchive = true;
                    }
                }
                if (this.rarRootBdas != null) {
                    for (RootBeanDeploymentArchive rarRootBda : this.rarRootBdas) {
                        rarModuleBda = rarRootBda.getModuleBda();
                        ejbRootBda.getBeanDeploymentArchives().add(rarRootBda);
                        ejbRootBda.getBeanDeploymentArchives().add(rarModuleBda);
                        ejbModuleBda.getBeanDeploymentArchives().add(rarRootBda);
                        ejbModuleBda.getBeanDeploymentArchives().add(rarModuleBda);
                        modifiedArchive = true;
                    }
                }
                if (!modifiedArchive || (idx = this.getBeanDeploymentArchives().indexOf(ejbModuleBda)) < 0) continue;
                this.getBeanDeploymentArchives().remove(idx);
                this.getBeanDeploymentArchives().add(ejbModuleBda);
            }
        }
        if (this.warRootBdas != null) {
            boolean modifiedArchive = false;
            for (RootBeanDeploymentArchive warRootBda : this.warRootBdas) {
                BeanDeploymentArchive warModuleBda = warRootBda.getModuleBda();
                if (this.ejbRootBdas != null) {
                    for (RootBeanDeploymentArchive ejbRootBda : this.ejbRootBdas) {
                        BeanDeploymentArchive ejbModuleBda = ejbRootBda.getModuleBda();
                        warRootBda.getBeanDeploymentArchives().add(ejbRootBda);
                        warRootBda.getBeanDeploymentArchives().add(ejbModuleBda);
                        warModuleBda.getBeanDeploymentArchives().add(ejbRootBda);
                        warModuleBda.getBeanDeploymentArchives().add(ejbModuleBda);
                        for (BeanDeploymentArchive oneBda : warModuleBda.getBeanDeploymentArchives()) {
                            oneBda.getBeanDeploymentArchives().add(ejbRootBda);
                            oneBda.getBeanDeploymentArchives().add(ejbModuleBda);
                        }
                        modifiedArchive = true;
                    }
                }
                if (this.libJarRootBdas != null) {
                    for (RootBeanDeploymentArchive libJarRootBda : this.libJarRootBdas) {
                        libJarModuleBda = libJarRootBda.getModuleBda();
                        warRootBda.getBeanDeploymentArchives().add(libJarRootBda);
                        warRootBda.getBeanDeploymentArchives().add(libJarModuleBda);
                        warModuleBda.getBeanDeploymentArchives().add(libJarRootBda);
                        warModuleBda.getBeanDeploymentArchives().add(libJarModuleBda);
                        for (BeanDeploymentArchive oneBda : warModuleBda.getBeanDeploymentArchives()) {
                            oneBda.getBeanDeploymentArchives().add(libJarRootBda);
                            oneBda.getBeanDeploymentArchives().add(libJarModuleBda);
                        }
                        modifiedArchive = true;
                    }
                }
                if (this.rarRootBdas != null) {
                    for (RootBeanDeploymentArchive rarRootBda : this.rarRootBdas) {
                        rarModuleBda = rarRootBda.getModuleBda();
                        warRootBda.getBeanDeploymentArchives().add(rarRootBda);
                        warRootBda.getBeanDeploymentArchives().add(rarModuleBda);
                        warModuleBda.getBeanDeploymentArchives().add(rarRootBda);
                        warModuleBda.getBeanDeploymentArchives().add(rarModuleBda);
                        for (BeanDeploymentArchive oneBda : warModuleBda.getBeanDeploymentArchives()) {
                            oneBda.getBeanDeploymentArchives().add(rarRootBda);
                            oneBda.getBeanDeploymentArchives().add(rarModuleBda);
                        }
                        modifiedArchive = true;
                    }
                }
                if (!modifiedArchive) continue;
                int idx = this.getBeanDeploymentArchives().indexOf(warModuleBda);
                if (idx >= 0) {
                    this.getBeanDeploymentArchives().remove(idx);
                    this.getBeanDeploymentArchives().add(warModuleBda);
                }
                modifiedArchive = false;
            }
        }
        this.addDependentBdas();
    }

    public void cleanup() {
        if (this.ejbRootBdas != null) {
            this.ejbRootBdas.clear();
        }
        if (this.warRootBdas != null) {
            this.warRootBdas.clear();
        }
        if (this.libJarRootBdas != null) {
            this.libJarRootBdas.clear();
        }
        if (this.rarRootBdas != null) {
            this.rarRootBdas.clear();
        }
        if (this.idToBeanDeploymentArchive != null) {
            this.idToBeanDeploymentArchive.clear();
        }
    }

    public BeanDeploymentArchive getBeanDeploymentArchiveForArchive(String archiveId) {
        return this.idToBeanDeploymentArchive.get(archiveId);
    }

    public Iterator<RootBeanDeploymentArchive> getLibJarRootBdas() {
        if (this.libJarRootBdas == null) {
            return null;
        }
        return this.libJarRootBdas.iterator();
    }

    public Iterator<RootBeanDeploymentArchive> getRarRootBdas() {
        if (this.rarRootBdas == null) {
            return null;
        }
        return this.rarRootBdas.iterator();
    }

    public Collection<EjbDescriptor> getDeployedEjbs() {
        return this.deployedEjbs;
    }

    protected void addDeployedEjbs(Collection<EjbDescriptor> ejbs) {
        if (ejbs != null) {
            this.deployedEjbs.addAll(ejbs);
        }
    }

    private List<Class<? extends BuildCompatibleExtension>> getBuildCompatibleExtensions() {
        return ServiceLoader.load(BuildCompatibleExtension.class, Thread.currentThread().getContextClassLoader()).stream().map(ServiceLoader.Provider::get).map(e -> e.getClass()).filter(e -> !e.isAnnotationPresent(SkipIfPortableExtensionPresent.class)).collect(Collectors.toList());
    }

    private void addBeanDeploymentArchives(RootBeanDeploymentArchive bda) {
        WeldUtils.BDAType moduleBDAType = bda.getModuleBDAType();
        if (moduleBDAType.equals((Object)WeldUtils.BDAType.WAR)) {
            if (this.warRootBdas == null) {
                this.warRootBdas = new ArrayList<RootBeanDeploymentArchive>();
            }
            this.warRootBdas.add(bda);
        } else if (moduleBDAType.equals((Object)WeldUtils.BDAType.JAR)) {
            if (this.ejbRootBdas == null) {
                this.ejbRootBdas = new ArrayList<RootBeanDeploymentArchive>();
            }
            this.ejbRootBdas.add(bda);
        } else if (moduleBDAType.equals((Object)WeldUtils.BDAType.RAR)) {
            if (this.rarRootBdas == null) {
                this.rarRootBdas = new ArrayList<RootBeanDeploymentArchive>();
            }
            this.rarRootBdas.add(bda);
        }
    }

    private void addDependentBdas() {
        HashSet<BeanDeploymentArchive> additionalBdas = new HashSet<BeanDeploymentArchive>();
        for (BeanDeploymentArchive oneBda : this.beanDeploymentArchives) {
            BeanDeploymentArchiveImpl beanDeploymentArchiveImpl = (BeanDeploymentArchiveImpl)oneBda;
            Collection<BeanDeploymentArchive> subBdas = beanDeploymentArchiveImpl.getBeanDeploymentArchives();
            for (BeanDeploymentArchive subBda : subBdas) {
                if (subBda.getBeanClasses().size() <= 0) continue;
                additionalBdas.add(subBda);
            }
        }
        for (BeanDeploymentArchive oneBda : additionalBdas) {
            if (this.beanDeploymentArchives.contains(oneBda)) continue;
            this.beanDeploymentArchives.add(oneBda);
        }
    }

    private List<RootBeanDeploymentArchive> scanForLibJars(ReadableArchive archive, Collection<EjbDescriptor> ejbs, DeploymentContext context) {
        String libDir;
        ArrayList<ReadableArchive> libJars = new ArrayList<ReadableArchive>();
        ApplicationHolder holder = (ApplicationHolder)context.getModuleMetaData(ApplicationHolder.class);
        if (holder != null && holder.app != null && !Utility.isEmpty((String)(libDir = holder.app.getLibraryDirectory()))) {
            Enumeration entries = archive.entries(libDir);
            while (entries.hasMoreElements()) {
                String entryName = (String)entries.nextElement();
                if (!entryName.endsWith(".jar") || entryName.indexOf(47, libDir.length() + 1) != -1) continue;
                try {
                    ReadableArchive jarInLib = archive.getSubArchive(entryName);
                    if (jarInLib.exists("META-INF/beans.xml") || WeldUtils.isImplicitBeanArchive((DeploymentContext)context, (ReadableArchive)jarInLib)) {
                        libJars.add(jarInLib);
                        continue;
                    }
                    jarInLib.close();
                }
                catch (IOException e) {
                    LOG.log(Level.FINE, "AS-CDI-00027", new Object[]{e});
                }
            }
        }
        if (holder == null || libJars.isEmpty()) {
            return this.libJarRootBdas;
        }
        libDir = holder.app.getLibraryDirectory();
        for (ReadableArchive libJarArchive : libJars) {
            this.createLibJarBda(libJarArchive, ejbs, libDir);
        }
        return this.libJarRootBdas;
    }

    private void createLibJarBda(ReadableArchive libJarArchive, Collection<EjbDescriptor> ejbs, String libDir) {
        this.createLibJarBda(new RootBeanDeploymentArchive(libJarArchive, ejbs, this.context, libDir + "/" + libJarArchive.getName()));
    }

    private void createLibJarBda(RootBeanDeploymentArchive rootLibBda) {
        BeanDeploymentArchive libModuleBda = rootLibBda.getModuleBda();
        BeansXml moduleBeansXml = libModuleBda.getBeansXml();
        if (moduleBeansXml == null || !moduleBeansXml.getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.NONE)) {
            this.addBdaToDeploymentBdas(rootLibBda);
            this.addBdaToDeploymentBdas(libModuleBda);
            if (this.libJarRootBdas == null) {
                this.libJarRootBdas = new ArrayList<RootBeanDeploymentArchive>();
            }
            for (RootBeanDeploymentArchive existingLibJarRootBda : this.libJarRootBdas) {
                rootLibBda.getBeanDeploymentArchives().add(existingLibJarRootBda);
                rootLibBda.getBeanDeploymentArchives().add(existingLibJarRootBda.getModuleBda());
                rootLibBda.getModuleBda().getBeanDeploymentArchives().add(existingLibJarRootBda);
                rootLibBda.getModuleBda().getBeanDeploymentArchives().add(existingLibJarRootBda.getModuleBda());
                existingLibJarRootBda.getBeanDeploymentArchives().add(rootLibBda);
                existingLibJarRootBda.getBeanDeploymentArchives().add(rootLibBda.getModuleBda());
                existingLibJarRootBda.getModuleBda().getBeanDeploymentArchives().add(rootLibBda);
                existingLibJarRootBda.getModuleBda().getBeanDeploymentArchives().add(rootLibBda.getModuleBda());
            }
            this.libJarRootBdas.add(rootLibBda);
        }
    }

    private RootBeanDeploymentArchive findRootBda(ClassLoader classLoader, List<RootBeanDeploymentArchive> rootBdas) {
        if (Utility.isAnyNull((Object[])new Object[]{rootBdas, classLoader})) {
            return null;
        }
        for (RootBeanDeploymentArchive rootBeanDeploymentArchive : rootBdas) {
            if (!classLoader.equals(rootBeanDeploymentArchive.getModuleClassLoaderForBDA())) continue;
            return rootBeanDeploymentArchive;
        }
        return null;
    }

    private void createModuleBda(ReadableArchive archive, Collection<EjbDescriptor> ejbs, DeploymentContext context) {
        DeploymentContextImpl deploymentContext;
        ExtendedDeploymentContext parentContext;
        RootBeanDeploymentArchive rootBda = new RootBeanDeploymentArchive(archive, ejbs, context);
        BeanDeploymentArchive moduleBda = rootBda.getModuleBda();
        BeansXml moduleBeansXml = moduleBda.getBeansXml();
        if (moduleBeansXml == null || !moduleBeansXml.getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.NONE)) {
            this.addBdaToDeploymentBdas(rootBda);
            this.addBdaToDeploymentBdas(moduleBda);
            this.addBeanDeploymentArchives(rootBda);
        }
        if (!this.earContextAppLibBdasProcessed && context instanceof DeploymentContextImpl && (parentContext = (deploymentContext = (DeploymentContextImpl)context).getParentContext()) != null) {
            this.processBdasForAppLibs(parentContext.getSource(), (DeploymentContext)parentContext);
            parentContext.getSource();
            this.earContextAppLibBdasProcessed = true;
        }
        this.processBdasForAppLibs(archive, context);
    }

    private void addBdaToDeploymentBdas(BeanDeploymentArchive bda) {
        if (!this.beanDeploymentArchives.contains(bda)) {
            this.beanDeploymentArchives.add(bda);
            this.idToBeanDeploymentArchive.put(bda.getId(), bda);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBdasForAppLibs(ReadableArchive archive, DeploymentContext context) {
        ArrayList<RootBeanDeploymentArchive> libBdas;
        block12: {
            libBdas = new ArrayList<RootBeanDeploymentArchive>();
            try {
                List rootArchiveAppLibs = context.getAppLibs();
                Set currentArchiveAppLibNames = InstalledLibrariesResolver.getInstalledLibraries((ReadableArchive)archive);
                if (Utility.isAnyEmpty((Object[])new Object[]{rootArchiveAppLibs, currentArchiveAppLibNames})) break block12;
                block9: for (URI rootArchiveAppLib : rootArchiveAppLibs) {
                    for (String currentArchiveAppLibName : currentArchiveAppLibNames) {
                        if (!rootArchiveAppLib.getPath().endsWith(currentArchiveAppLibName)) continue;
                        ReadableArchive libArchive = null;
                        try {
                            libArchive = this.archiveFactory.openArchive(rootArchiveAppLib);
                            if (!libArchive.exists("META-INF/beans.xml")) continue block9;
                            libBdas.add(new RootBeanDeploymentArchive(libArchive, Collections.emptyList(), context, archive.getName() + "_" + libArchive.getName()));
                            continue block9;
                        }
                        finally {
                            if (libArchive == null) continue block9;
                            try {
                                libArchive.close();
                            }
                            catch (Exception exception) {}
                            continue block9;
                        }
                    }
                }
            }
            catch (IOException | URISyntaxException exception) {
                // empty catch block
            }
        }
        for (RootBeanDeploymentArchive libBeanDeploymentArchive : libBdas) {
            this.createLibJarBda(libBeanDeploymentArchive);
        }
    }
}

