/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.FieldInfo;
import jakarta.enterprise.lang.model.types.Type;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.jboss.weld.lite.extension.translator.ClassInfoImpl;
import org.jboss.weld.lite.extension.translator.DeclarationInfoImpl;
import org.jboss.weld.lite.extension.translator.TypeImpl;

class FieldInfoImpl
extends DeclarationInfoImpl<Field, AnnotatedField<?>>
implements FieldInfo {
    private final String className;
    private final String name;

    FieldInfoImpl(AnnotatedField<?> cdiDeclaration, BeanManager bm) {
        super(cdiDeclaration.getJavaMember(), cdiDeclaration, bm);
        this.className = ((Field)this.reflection).getDeclaringClass().getName();
        this.name = ((Field)this.reflection).getName();
    }

    FieldInfoImpl(Field reflectionDeclaration, BeanManager bm) {
        super(reflectionDeclaration, null, bm);
        this.className = reflectionDeclaration.getDeclaringClass().getName();
        this.name = reflectionDeclaration.getName();
    }

    public String name() {
        return ((Field)this.reflection).getName();
    }

    public Type type() {
        return TypeImpl.fromReflectionType(((Field)this.reflection).getAnnotatedType(), this.bm);
    }

    public boolean isStatic() {
        return Modifier.isStatic(((Field)this.reflection).getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(((Field)this.reflection).getModifiers());
    }

    public int modifiers() {
        return ((Field)this.reflection).getModifiers();
    }

    public ClassInfo declaringClass() {
        return new ClassInfoImpl(this.bm.createAnnotatedType(((Field)this.reflection).getDeclaringClass()), this.bm);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldInfoImpl fieldInfo = (FieldInfoImpl)o;
        return Objects.equals(this.className, fieldInfo.className) && Objects.equals(this.name, fieldInfo.name);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.name);
    }
}

