/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Intercepted;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.Interceptor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import org.jboss.weld.bean.BeanIdentifiers;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.bean.builtin.BeanMetadataBean;
import org.jboss.weld.contexts.WeldCreationalContext;
import org.jboss.weld.literal.InterceptedLiteral;
import org.jboss.weld.logging.InterceptorLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.util.bean.SerializableForwardingBean;

public class InterceptedBeanMetadataBean
extends BeanMetadataBean {
    public InterceptedBeanMetadataBean(BeanManagerImpl beanManager) {
        this(new StringBeanIdentifier(BeanIdentifiers.forBuiltInBean(beanManager, Bean.class, Intercepted.class.getSimpleName())), beanManager);
    }

    protected InterceptedBeanMetadataBean(BeanIdentifier identifier, BeanManagerImpl beanManager) {
        super(identifier, beanManager);
    }

    @Override
    protected Bean<?> newInstance(InjectionPoint ip, CreationalContext<Bean<?>> ctx) {
        this.checkInjectionPoint(ip);
        WeldCreationalContext<Bean<?>> interceptorContext = this.getParentCreationalContext(ctx);
        WeldCreationalContext<Bean<?>> interceptedBeanContext = this.getParentCreationalContext(interceptorContext);
        Contextual<Bean<?>> interceptedContextual = interceptedBeanContext.getContextual();
        if (interceptedContextual instanceof Bean) {
            Bean bean = (Bean)interceptedContextual;
            if (bean instanceof Serializable) {
                return bean;
            }
            return SerializableForwardingBean.of(this.getBeanManager().getContextId(), bean);
        }
        InterceptorLogger.LOG.unableToDetermineInterceptedBean(ip);
        return null;
    }

    protected void checkInjectionPoint(InjectionPoint ip) {
        if (!(ip.getBean() instanceof Interceptor)) {
            throw InterceptorLogger.LOG.interceptedBeanCanOnlyBeInjectedIntoInterceptor(ip);
        }
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return Collections.singleton(InterceptedLiteral.INSTANCE);
    }

    @Override
    public String toString() {
        return "Implicit Bean [jakarta.enterprise.inject.spi.Bean] with qualifiers [@Intercepted]";
    }
}

