/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.schemadoc;

import com.sun.enterprise.admin.cli.schemadoc.ClassDef;
import com.sun.enterprise.admin.cli.schemadoc.Context;
import com.sun.enterprise.admin.cli.schemadoc.SchemaOutputFormat;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glassfish.api.admin.config.PropertyDesc;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.types.Property;

@Service(name="html")
public class HtmlFormat
implements SchemaOutputFormat {
    private final Set<ClassDef> toc = new HashSet<ClassDef>();
    private File dir;
    private Map<String, ClassDef> defs;

    @Override
    public void output(Context context) {
        this.dir = context.getDocDir();
        this.defs = context.getClassDefs();
        try (PrintWriter tocWriter = this.createWriter("toc.HTML");
             PrintWriter detail = this.createWriter("detail.HTML");){
            this.println(tocWriter, "<HTML><head><link rel=\"stylesheet\" type=\"text/css\" href=\"schemadoc.css\"><style>body{margin-left:-1em;}</style></head><body>");
            this.println(detail, "<HTML><head><link rel=\"stylesheet\" type=\"text/css\" href=\"schemadoc.css\"></head><body>");
            this.copyResources();
            this.buildToc(tocWriter, detail, this.defs.get(context.getRootClassName()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PrintWriter createWriter(String filename) {
        try {
            return new PrintWriter(new FileWriter(new File(this.dir, filename), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void buildToc(PrintWriter tocWriter, PrintWriter detail, ClassDef def) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (def != null) {
            if (!this.toc.contains(def)) {
                this.buildDetail(detail, def);
            }
            this.toc.add(def);
            this.println(tocWriter, "<ul>");
            this.println(tocWriter, "<li>" + this.link(def));
            for (Map.Entry<String, String> aggType : def.getAggregatedTypes().entrySet()) {
                if (Property.class.getName().equals(aggType.getValue()) || this.defs == null) continue;
                this.buildToc(tocWriter, detail, this.defs.get(aggType.getValue()));
            }
            for (ClassDef subclass : def.getSubclasses()) {
                this.buildToc(tocWriter, detail, subclass);
            }
            this.println(tocWriter, "</ul>");
            this.footer(tocWriter);
            this.footer(detail);
        }
    }

    private void buildDetail(PrintWriter detail, ClassDef def) {
        this.println(detail, "<p><table><tr>");
        this.println(detail, "<a name=\"" + def.getXmlName() + "\">");
        this.println(detail, String.format("<th colspan=\"4\" class=\"TableHeadingColor entity %s\">%s%s", def.isDeprecated() ? "deprecated" : "", def.getXmlName(), def.isDeprecated() ? " - DEPRECATED" : ""));
        this.println(detail, "</th></tr>");
        this.println(detail, "<colgroup><col width=\"35%\"></colgroup>");
        this.printHeaderRow(detail, "attribute", "type", "default", "required");
        Map<String, Attribute> map = def.getAttributes();
        if (map != null) {
            for (Map.Entry<String, Attribute> entry : map.entrySet()) {
                this.println(detail, String.format("<tr><td class=\"TableSubHeadingColor\">%s</td>", entry.getKey()));
                this.printAttributeData(detail, entry.getValue());
            }
        }
        this.println(detail, "</table>");
        this.printPropertyData(detail, def);
    }

    private void printAttributeData(PrintWriter detail, Attribute annotation) {
        this.printKeyValue(detail, annotation != null ? annotation.dataType().getName() : null);
        this.printKeyValue(detail, annotation != null ? annotation.defaultValue() : null);
        this.printKeyValue(detail, annotation != null && annotation.required());
    }

    private void printPropertyData(PrintWriter detail, ClassDef def) {
        Set<PropertyDesc> properties = def.getProperties();
        if (properties != null && !properties.isEmpty()) {
            this.println(detail, "<tr><td colspan=\"2\">");
            this.println(detail, "<table>");
            this.println(detail, "<tr class=\"TableHeadingColor\">");
            this.println(detail, "<th colspan=\"4\">Properties</th>");
            this.println(detail, "</tr>");
            this.println(detail, "<tr class=\"TableHeadingColor\">");
            this.println(detail, "<th>name</th>");
            this.println(detail, "<th>default</th>");
            this.println(detail, "<th>values</th>");
            this.println(detail, "<th>description</th>");
            this.println(detail, "</tr>");
            for (PropertyDesc property : properties) {
                this.println(detail, "<tr>");
                this.println(detail, String.format("<td class=\"TableSubHeadingColor\">%s</td>", property.name()));
                this.println(detail, String.format("<td class=\"nobreak\">%s</td>", property.defaultValue()));
                this.println(detail, String.format("<td>%s</td>", property.values().length == 0 ? "" : Arrays.toString(property.values())));
                this.println(detail, String.format("<td>%s</td>", property.description()));
                this.println(detail, "</tr>");
            }
            this.println(detail, "</table>");
            this.println(detail, "</td></tr>");
        }
    }

    private void printKeyValue(PrintWriter writer, Object value) {
        this.println(writer, "<td>");
        if (value != null) {
            if (value instanceof Class) {
                this.println(writer, ((Class)value).getSimpleName());
            } else {
                this.println(writer, value.toString().trim());
            }
        }
        this.println(writer, "</td>");
    }

    private String link(ClassDef def) {
        return String.format("<a %s target=\"detail\" href=\"detail.html#%s\">%s</a>", def.isDeprecated() ? "class=\"deprecated\"" : "", def.getXmlName(), def.getXmlName());
    }

    private void println(PrintWriter writer, String text) {
        writer.println(text);
        writer.flush();
    }

    private void printHeaderRow(PrintWriter writer, String ... values) {
        writer.println("<tr class=\"TableHeadingColor\">");
        for (String value : values) {
            writer.println(String.format("<th>%s</th>", value != null ? value.trim() : " "));
        }
        writer.println("</tr>");
    }

    private void footer(PrintWriter writer) {
        writer.println("</body></HTML>");
        writer.flush();
        writer.close();
    }

    private void copyResources() throws IOException {
        this.copy("/schemadoc.css");
        this.copy("/index.html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(String resource) throws IOException {
        InputStreamReader reader = null;
        try (PrintWriter writer = null;){
            try {
                int read;
                InputStream stream = this.getClass().getClassLoader().getResourceAsStream(resource);
                reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                writer = new PrintWriter(new File(this.dir, resource), StandardCharsets.UTF_8);
                char[] bytes = new char[8192];
                while ((read = reader.read(bytes)) != -1) {
                    writer.write(bytes, 0, read);
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }
}

