/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.util.Hashtable;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.asm.Label;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.BinaryLogicalExpression;
import org.glassfish.rmic.tools.tree.BooleanExpression;
import org.glassfish.rmic.tools.tree.CommaExpression;
import org.glassfish.rmic.tools.tree.ConditionVars;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.Vset;

public class OrExpression
extends BinaryLogicalExpression {
    public OrExpression(long where, Expression left, Expression right) {
        super(14, where, left, right);
    }

    @Override
    public void checkCondition(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp, ConditionVars cvars) {
        this.left.checkCondition(env, ctx, vset, exp, cvars);
        this.left = this.convert(env, ctx, Type.tBoolean, this.left);
        Vset vsTrue = cvars.vsTrue.copy();
        Vset vsFalse = cvars.vsFalse.copy();
        this.right.checkCondition(env, ctx, vsFalse, exp, cvars);
        this.right = this.convert(env, ctx, Type.tBoolean, this.right);
        cvars.vsTrue = cvars.vsTrue.join(vsTrue);
    }

    @Override
    Expression eval(boolean a, boolean b) {
        return new BooleanExpression(this.where, a || b);
    }

    @Override
    Expression simplify() {
        if (this.right.equals(false)) {
            return this.left;
        }
        if (this.left.equals(true)) {
            return this.left;
        }
        if (this.left.equals(false)) {
            return this.right;
        }
        if (this.right.equals(true)) {
            return new CommaExpression(this.where, this.left, this.right).simplify();
        }
        return this;
    }

    @Override
    void codeBranch(Environment env, Context ctx, Assembler asm, Label lbl, boolean whenTrue) {
        if (whenTrue) {
            this.left.codeBranch(env, ctx, asm, lbl, true);
            this.right.codeBranch(env, ctx, asm, lbl, true);
        } else {
            Label lbl2 = new Label();
            this.left.codeBranch(env, ctx, asm, lbl2, true);
            this.right.codeBranch(env, ctx, asm, lbl, false);
            asm.add(lbl2);
        }
    }
}

