/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.runtime;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.deployment.common.Descriptor;

public abstract class RuntimeDescriptor
extends Descriptor {
    private static final long serialVersionUID = 1L;
    private final PropertyChangeSupport propListeners = new PropertyChangeSupport((Object)this);

    public RuntimeDescriptor(RuntimeDescriptor other) {
        super((Descriptor)other);
    }

    public RuntimeDescriptor() {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propListeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propListeners.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String n, PropertyChangeListener l) {
        this.propListeners.addPropertyChangeListener(n, l);
    }

    public void removePropertyChangeListener(String n, PropertyChangeListener l) {
        this.propListeners.removePropertyChangeListener(n, l);
    }

    public void setValue(String name, Object value) {
        Object oldValue = this.getExtraAttribute(name);
        this.addExtraAttribute(name, value);
        this.propListeners.firePropertyChange(name, oldValue, value);
    }

    public <T> T getValue(String name) {
        return (T)this.getExtraAttribute(name);
    }

    protected void setValue(String name, int index, Object value) {
        List<Object> list = this.getIndexedProperty(name);
        list.set(index, value);
        this.setValue(name, list);
    }

    protected Object getValue(String name, int index) {
        List<Object> list = this.getIndexedProperty(name);
        return list.get(index);
    }

    protected int addValue(String name, Object value) {
        List<Object> list = this.getIndexedProperty(name);
        list.add(value);
        this.setValue(name, list);
        return list.indexOf(value);
    }

    protected int removeValue(String name, Object value) {
        List<Object> list = this.getIndexedProperty(name);
        int index = list.indexOf(value);
        list.remove(index);
        return index;
    }

    protected void removeValue(String name, int index) {
        List<Object> list = this.getIndexedProperty(name);
        list.remove(index);
    }

    protected Object[] getValues(String name) {
        List list = (List)this.getValue(name);
        if (list == null || list.isEmpty()) {
            return null;
        }
        Class<?> c = list.get(0).getClass();
        Object array = Array.newInstance(c, list.size());
        return list.toArray((Object[])array);
    }

    protected int size(String name) {
        List list = (List)this.getValue(name);
        return list == null ? 0 : list.size();
    }

    private List<Object> getIndexedProperty(String name) {
        List o = (List)this.getValue(name);
        if (o == null) {
            return new ArrayList<Object>();
        }
        return o;
    }

    public void setAttributeValue(String elementName, String attributeName, Object value) {
        int index = 0;
        while (this.getValue(elementName + "-" + index + "-" + attributeName) != null) {
            ++index;
        }
        this.setValue(elementName + "-" + index + "-" + attributeName, value);
    }

    public String getAttributeValue(String elementName, String attributeName) {
        return this.getAttributeValue(elementName, 0, attributeName);
    }

    @Deprecated
    public final void setAttributeValue(String attributeName, Object value) {
        this.setValue(attributeName, value);
    }

    @Deprecated
    public final String getAttributeValue(String attributeName) {
        return (String)this.getValue(attributeName);
    }

    public void setAttributeValue(String elementName, int index, String attributeName, Object value) {
        this.setValue(elementName + "-" + index + "-" + attributeName, value);
    }

    public String getAttributeValue(String elementName, int index, String attributeName) {
        return (String)this.getValue(elementName + "-" + index + "-" + attributeName);
    }
}

