/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.types.EntityManagerReference;
import com.sun.enterprise.deployment.util.DOLUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContextType;
import jakarta.persistence.SynchronizationType;
import java.util.HashMap;
import java.util.Map;

public class EntityManagerReferenceDescriptor
extends EnvironmentProperty
implements EntityManagerReference {
    private static final long serialVersionUID = 1L;
    private String unitName;
    private PersistenceContextType contextType = PersistenceContextType.TRANSACTION;
    private SynchronizationType synchronizationType = SynchronizationType.SYNCHRONIZED;
    private BundleDescriptor referringBundle;
    private final Map<String, String> properties = new HashMap<String, String>();

    public EntityManagerReferenceDescriptor(String name, String unitName, PersistenceContextType type) {
        super(name, "", "");
        this.unitName = unitName;
        this.contextType = type;
    }

    public EntityManagerReferenceDescriptor() {
    }

    @Override
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    @Override
    public String getUnitName() {
        return this.unitName;
    }

    @Override
    public String getInjectResourceType() {
        return EntityManager.class.getName();
    }

    @Override
    public void setInjectResourceType(String resourceType) {
    }

    @Override
    public void setPersistenceContextType(PersistenceContextType type) {
        this.contextType = type;
    }

    @Override
    public PersistenceContextType getPersistenceContextType() {
        return this.contextType;
    }

    @Override
    public SynchronizationType getSynchronizationType() {
        return this.synchronizationType;
    }

    @Override
    public void setSynchronizationType(SynchronizationType synchronizationType) {
        this.synchronizationType = synchronizationType;
    }

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    @Override
    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    @Override
    public void setReferringBundleDescriptor(BundleDescriptor referringBundle) {
        this.referringBundle = referringBundle;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public BundleDescriptor getReferringBundleDescriptor() {
        return this.referringBundle;
    }

    public boolean isConflict(EntityManagerReferenceDescriptor other) {
        return this.getName().equals(other.getName()) && (!DOLUtils.equals(this.getUnitName(), other.getUnitName()) || !DOLUtils.equals(this.getPersistenceContextType(), other.getPersistenceContextType()) || !this.properties.equals(other.properties) || this.isConflictResourceGroup(other));
    }
}

