/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.util.cache;

import com.sun.appserv.util.cache.BaseCache;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public class LruCache
extends BaseCache {
    public static final long NO_TIMEOUT = -1L;
    protected LruCacheItem head;
    protected LruCacheItem tail;
    protected int trimCount;
    protected int listSize;
    protected long timeout = -1L;
    protected int defaultMaxEntries = 8192;
    protected boolean isUnbounded = false;

    public LruCache() {
    }

    public LruCache(int defaultMaxEntries) {
        this.defaultMaxEntries = defaultMaxEntries;
    }

    public void init(int maxEntries, long timeout, float loadFactor, Properties props) {
        if (maxEntries <= 0) {
            maxEntries = this.defaultMaxEntries;
            this.isUnbounded = true;
        }
        this.setTimeout(timeout);
        super.init(maxEntries, loadFactor, props);
    }

    public void setTimeout(long timeout) {
        if (timeout > 0L) {
            this.timeout = timeout;
        }
    }

    @Override
    protected BaseCache.CacheItem createItem(int hashCode, Object key, Object value, int size) {
        return new LruCacheItem(hashCode, key, value, size);
    }

    protected BaseCache.CacheItem trimLru(long currentTime) {
        if (this.tail == null) {
            return null;
        }
        LruCacheItem trimItem = this.tail;
        if (this.tail != this.head) {
            this.tail = trimItem.lPrev;
            if (this.tail == null) {
                this.head = null;
                this.tail = null;
            } else {
                this.tail.lNext = null;
                trimItem.lPrev = null;
            }
        } else {
            this.head = null;
            this.tail = null;
        }
        trimItem.isTrimmed = true;
        trimItem.lPrev = null;
        ++this.trimCount;
        --this.listSize;
        return trimItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BaseCache.CacheItem itemAdded(BaseCache.CacheItem item) {
        boolean updateThreshold = false;
        BaseCache.CacheItem overflow = null;
        if (!(item instanceof LruCacheItem)) {
            return null;
        }
        LruCacheItem lc = (LruCacheItem)item;
        lc.lastAccessed = System.currentTimeMillis();
        LruCache lruCache = this;
        synchronized (lruCache) {
            if (this.head != null) {
                this.head.lPrev = lc;
                lc.lNext = this.head;
                lc.lPrev = null;
                this.head = lc;
            } else {
                this.head = this.tail = lc;
                lc.lNext = null;
                lc.lPrev = null;
            }
            ++this.listSize;
            if (this.isThresholdReached()) {
                if (!this.isUnbounded) {
                    overflow = this.trimLru(lc.lastAccessed);
                } else {
                    updateThreshold = true;
                }
            }
        }
        if (updateThreshold) {
            super.handleOverflow();
        }
        return overflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void itemAccessed(BaseCache.CacheItem item) {
        if (this.head == null) {
            return;
        }
        if (item == null) {
            return;
        }
        if (!(item instanceof LruCacheItem)) {
            return;
        }
        LruCacheItem lc = (LruCacheItem)item;
        LruCache lruCache = this;
        synchronized (lruCache) {
            if (lc.isTrimmed) {
                return;
            }
            lc.lastAccessed = System.currentTimeMillis();
            LruCacheItem prev = lc.lPrev;
            LruCacheItem next = lc.lNext;
            if (prev != null) {
                lc.lPrev = null;
                lc.lNext = this.head;
                this.head.lPrev = lc;
                this.head = lc;
                prev.lNext = next;
                if (next != null) {
                    next.lPrev = prev;
                } else {
                    this.tail = prev;
                }
            }
        }
    }

    @Override
    protected void itemRefreshed(BaseCache.CacheItem item, int oldSize) {
        this.itemAccessed(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void itemRemoved(BaseCache.CacheItem item) {
        if (!(item instanceof LruCacheItem)) {
            return;
        }
        LruCacheItem l = (LruCacheItem)item;
        LruCache lruCache = this;
        synchronized (lruCache) {
            LruCacheItem prev = l.lPrev;
            LruCacheItem next = l.lNext;
            if (l.isTrimmed) {
                return;
            }
            if (prev != null) {
                prev.lNext = next;
            } else {
                this.head = next;
            }
            if (next != null) {
                next.lPrev = prev;
            } else {
                this.tail = prev;
            }
            l.lNext = null;
            l.lPrev = null;
            --this.listSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trimExpiredEntries(int maxCount) {
        long currentTime = System.currentTimeMillis();
        ArrayList<LruCacheItem> list = new ArrayList<LruCacheItem>();
        LruCache lruCache = this;
        synchronized (lruCache) {
            int count;
            LruCacheItem item = this.tail;
            for (count = 0; item != null && count < maxCount && this.timeout != -1L && item.lastAccessed + this.timeout <= currentTime; ++count) {
                item.isTrimmed = true;
                list.add(item);
                item = item.lPrev;
            }
            if (item != this.tail) {
                if (item != null) {
                    item.lNext = null;
                } else {
                    this.head = null;
                }
                this.tail = item;
            }
            this.listSize -= count;
            this.trimCount += count;
        }
        for (int index = list.size() - 1; index >= 0; --index) {
            this.trimItem((LruCacheItem)list.get(index));
        }
    }

    @Override
    public Object getStatByName(String key) {
        Object stat = super.getStatByName(key);
        if (stat == null && key != null) {
            if (key.equals("cache.LruCache.stat_lruListLength")) {
                stat = this.listSize;
            } else if (key.equals("cache.LruCache.stat_trimCount")) {
                stat = this.trimCount;
            }
        }
        return stat;
    }

    @Override
    public Map getStats() {
        Map stats = super.getStats();
        stats.put("cache.LruCache.stat_lruListLength", this.listSize);
        stats.put("cache.LruCache.stat_trimCount", this.trimCount);
        return stats;
    }

    protected static class LruCacheItem
    extends BaseCache.CacheItem {
        protected LruCacheItem lNext;
        protected LruCacheItem lPrev;
        protected boolean isTrimmed;
        protected long lastAccessed;

        protected LruCacheItem(int hashCode, Object key, Object value, int size) {
            super(hashCode, key, value, size);
        }

        public LruCacheItem getLNext() {
            return this.lNext;
        }

        public void setLNext(LruCacheItem item) {
            this.lNext = item;
        }

        public LruCacheItem getLPrev() {
            return this.lPrev;
        }

        public void setLPrev(LruCacheItem item) {
            this.lPrev = item;
        }

        public boolean isTrimmed() {
            return this.isTrimmed;
        }

        public void setTrimmed(boolean value) {
            this.isTrimmed = value;
        }

        public long getLastAccessed() {
            return this.lastAccessed;
        }

        public void setLastAccessed(long l) {
            this.lastAccessed = l;
        }
    }
}

