/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport.buffers;

import com.sun.enterprise.mgmt.transport.buffers.Buffer;
import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class BufferUtils {
    public static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
    public static final ByteBuffer[] EMPTY_BYTE_BUFFER_ARRAY = new ByteBuffer[0];

    public static ByteBuffer slice(ByteBuffer chunk, int size) {
        chunk.limit(chunk.position() + size);
        ByteBuffer view = chunk.slice();
        chunk.position(chunk.limit());
        chunk.limit(chunk.capacity());
        return view;
    }

    public static ByteBuffer slice(ByteBuffer byteBuffer, int position, int limit) {
        int oldPos = byteBuffer.position();
        int oldLimit = byteBuffer.limit();
        BufferUtils.setPositionLimit(byteBuffer, position, limit);
        ByteBuffer slice = byteBuffer.slice();
        BufferUtils.setPositionLimit(byteBuffer, oldPos, oldLimit);
        return slice;
    }

    public static String toStringContent(ByteBuffer byteBuffer, Charset charset, int position, int limit) {
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        if (byteBuffer.hasArray()) {
            try {
                return new String(byteBuffer.array(), position + byteBuffer.arrayOffset(), limit - position, charset.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        int oldPosition = byteBuffer.position();
        int oldLimit = byteBuffer.limit();
        BufferUtils.setPositionLimit(byteBuffer, position, limit);
        byte[] tmpBuffer = new byte[limit - position];
        byteBuffer.get(tmpBuffer);
        BufferUtils.setPositionLimit(byteBuffer, oldPosition, oldLimit);
        try {
            return new String(tmpBuffer, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void setPositionLimit(ByteBuffer buffer, int position, int limit) {
        buffer.limit(limit);
        buffer.position(position);
    }

    public static void setPositionLimit(Buffer buffer, int position, int limit) {
        buffer.limit(limit);
        buffer.position(position);
    }

    public static void put(ByteBuffer srcBuffer, int srcOffset, int length, ByteBuffer dstBuffer) {
        if (dstBuffer.remaining() < length) {
            throw new BufferOverflowException();
        }
        if (srcBuffer.hasArray() && dstBuffer.hasArray()) {
            System.arraycopy(srcBuffer.array(), srcBuffer.arrayOffset() + srcOffset, dstBuffer.array(), dstBuffer.arrayOffset() + dstBuffer.position(), length);
            dstBuffer.position(dstBuffer.position() + length);
        } else {
            int oldPos = srcBuffer.position();
            int oldLim = srcBuffer.limit();
            BufferUtils.setPositionLimit(srcBuffer, srcOffset, srcOffset + length);
            dstBuffer.put(srcBuffer);
            srcBuffer.position(oldPos);
            srcBuffer.limit(oldLim);
        }
    }

    public static void get(ByteBuffer srcBuffer, byte[] dstBytes, int dstOffset, int length) {
        if (srcBuffer.hasArray()) {
            if (length > srcBuffer.remaining()) {
                throw new BufferUnderflowException();
            }
            System.arraycopy(srcBuffer.array(), srcBuffer.arrayOffset() + srcBuffer.position(), dstBytes, dstOffset, length);
            srcBuffer.position(srcBuffer.position() + length);
        } else {
            srcBuffer.get(dstBytes, dstOffset, length);
        }
    }

    public static void put(byte[] srcBytes, int srcOffset, int length, ByteBuffer dstBuffer) {
        if (dstBuffer.hasArray()) {
            if (length > dstBuffer.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(srcBytes, srcOffset, dstBuffer.array(), dstBuffer.arrayOffset() + dstBuffer.position(), length);
            dstBuffer.position(dstBuffer.position() + length);
        } else {
            dstBuffer.put(srcBytes, srcOffset, length);
        }
    }
}

