/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.iiop;

import java.util.Hashtable;
import org.glassfish.rmic.iiop.BatchEnvironment;

class NameContext {
    private Hashtable<String, Name> table;
    private final boolean allowCollisions;

    public static synchronized NameContext forName(String name, boolean allowCollisions, BatchEnvironment env) {
        NameContext result = null;
        if (name == null) {
            name = "null";
        }
        if (env.nameContexts == null) {
            env.nameContexts = new Hashtable();
        } else {
            result = env.nameContexts.get(name);
        }
        if (result == null) {
            result = new NameContext(allowCollisions);
            env.nameContexts.put(name, result);
        }
        return result;
    }

    public NameContext(boolean allowCollisions) {
        this.allowCollisions = allowCollisions;
        this.table = new Hashtable();
    }

    public void assertPut(String name) throws Exception {
        String message = this.add(name);
        if (message != null) {
            throw new Exception(message);
        }
    }

    public void put(String name) {
        if (!this.allowCollisions) {
            throw new Error("Must use assertPut(name)");
        }
        this.add(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String add(String name) {
        String key = name.toLowerCase();
        Name value = this.table.get(key);
        if (value != null) {
            if (name.equals(value.name)) return null;
            if (!this.allowCollisions) return "\"" + name + "\" and \"" + value.name + "\"";
            value.collisions = true;
            return null;
        } else {
            this.table.put(key, new Name(name, false));
        }
        return null;
    }

    public String get(String name) {
        Name it = this.table.get(name.toLowerCase());
        String result = name;
        if (it.collisions) {
            int length = name.length();
            boolean allLower = true;
            for (int i = 0; i < length; ++i) {
                if (!Character.isUpperCase(name.charAt(i))) continue;
                result = result + "_";
                result = result + i;
                allLower = false;
            }
            if (allLower) {
                result = result + "_";
            }
        }
        return result;
    }

    public void clear() {
        this.table.clear();
    }

    public class Name {
        public String name;
        public boolean collisions;

        public Name(String name, boolean collisions) {
            this.name = name;
            this.collisions = collisions;
        }
    }
}

