/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.logviewer.backend;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.hk2.api.ServiceLocator;

public class LogFilterForInstance {
    public File downloadGivenInstanceLogFile(ServiceLocator habitat, Server targetServer, Domain domain, Logger logger, String instanceName, String domainRoot, String logFileName, String instanceLogFileName) throws IOException {
        File instanceLogFile;
        block41: {
            instanceLogFile = null;
            SSHLauncher sshL = this.getSSHL(habitat);
            String sNode = targetServer.getNodeRef();
            Nodes nodes = domain.getNodes();
            Node node = nodes.getNode(sNode);
            if (node.getType().equals("SSH")) {
                try {
                    sshL.init(node, logger);
                    try (SFTPClient sftpClient = sshL.getSFTPClient();){
                        SftpATTRS sftpFileAttributes;
                        long fileSizeOnNode;
                        Object loggingFile;
                        File logFileDirectoryOnServer = this.makingDirectory(domainRoot + File.separator + "logs" + File.separator + instanceName);
                        boolean noFileFound = true;
                        String loggingDir = this.getLoggingDirectoryForNode(instanceLogFileName, node, sNode, instanceName);
                        try {
                            Vector instanceLogFileNames = sftpClient.getSftpChannel().ls(loggingDir);
                            for (ChannelSftp.LsEntry file : instanceLogFileNames) {
                                if (!this.isAcceptable(file)) continue;
                                noFileFound = false;
                                break;
                            }
                        }
                        catch (Exception e) {
                            noFileFound = true;
                        }
                        if (noFileFound) {
                            loggingDir = this.getLoggingDirectoryForNodeWhenNoFilesFound(instanceLogFileName, node, sNode, instanceName);
                        }
                        if (!sftpClient.exists((String)(loggingFile = loggingDir + File.separator + logFileName))) {
                            loggingFile = loggingDir + File.separator + "server.log";
                        } else if (!sftpClient.exists((String)loggingFile)) {
                            loggingFile = instanceLogFileName;
                        }
                        long instanceLogFileSize = 0L;
                        instanceLogFile = new File(logFileDirectoryOnServer.getAbsolutePath() + File.separator + ((String)loggingFile).substring(((String)loggingFile).lastIndexOf(File.separator), ((String)loggingFile).length()));
                        if (instanceLogFile.exists()) {
                            instanceLogFileSize = instanceLogFile.length();
                        }
                        if (instanceLogFileSize == (fileSizeOnNode = (sftpFileAttributes = sftpClient._stat((String)loggingFile)).getSize())) break block41;
                        try (InputStream inputStream = sftpClient.getSftpChannel().get((String)loggingFile);
                             BufferedInputStream in = new BufferedInputStream(inputStream);
                             FileOutputStream file = new FileOutputStream(instanceLogFile);
                             BufferedOutputStream out = new BufferedOutputStream(file);){
                            int i;
                            while ((i = in.read()) != -1) {
                                out.write(i);
                            }
                            out.flush();
                        }
                    }
                }
                catch (JSchException ex) {
                    throw new IOException("Unable to download instance log file from SSH Node", ex);
                }
                catch (SftpException ex) {
                    throw new IOException("Unable to download instance log file from SSH Node", ex);
                }
            }
        }
        return instanceLogFile;
    }

    public void downloadAllInstanceLogFiles(ServiceLocator habitat, Server targetServer, Domain domain, Logger logger, String instanceName, String tempDirectoryOnServer, String instanceLogFileDirectory) throws IOException {
        SSHLauncher sshL = this.getSSHL(habitat);
        String sNode = targetServer.getNodeRef();
        Nodes nodes = domain.getNodes();
        Node node = nodes.getNode(sNode);
        if (node.getType().equals("SSH")) {
            try {
                sshL.init(node, logger);
                List<String> allInstanceLogFileName = this.getInstanceLogFileNames(habitat, targetServer, domain, logger, instanceName, instanceLogFileDirectory);
                boolean noFileFound = true;
                String sourceDir = this.getLoggingDirectoryForNode(instanceLogFileDirectory, node, sNode, instanceName);
                SFTPClient sftpClient = sshL.getSFTPClient();
                try {
                    Vector instanceLogFileNames = sftpClient.getSftpChannel().ls(sourceDir);
                    for (ChannelSftp.LsEntry file : instanceLogFileNames) {
                        if (!this.isAcceptable(file)) continue;
                        noFileFound = false;
                        break;
                    }
                }
                catch (Exception e) {
                    noFileFound = true;
                }
                if (noFileFound) {
                    sourceDir = this.getLoggingDirectoryForNodeWhenNoFilesFound(instanceLogFileDirectory, node, sNode, instanceName);
                }
                for (String element : allInstanceLogFileName) {
                    String remoteFileName = sourceDir + File.separator + String.valueOf(element);
                    InputStream inputStream = sftpClient.getSftpChannel().get(remoteFileName);
                    Files.copy(inputStream, Paths.get(tempDirectoryOnServer, new String[0]), new CopyOption[0]);
                }
                sftpClient.close();
            }
            catch (JSchException ex) {
                throw new IOException("Unable to download instance log file from SSH Node", ex);
            }
            catch (SftpException ex) {
                throw new IOException("Unable to download instance log file from SSH Node", ex);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> getInstanceLogFileNames(ServiceLocator habitat, Server targetServer, Domain domain, Logger logger, String instanceName, String instanceLogFileDetails) throws IOException {
        String sNode = targetServer.getNodeRef();
        Node node = domain.getNodes().getNode(sNode);
        ArrayList<String> instanceLogFileNamesAsString = new ArrayList<String>();
        if (node.isLocal()) {
            String fileName;
            String loggingDir = this.getLoggingDirectoryForNode(instanceLogFileDetails, node, sNode, instanceName);
            File logsDir = new File(loggingDir);
            File[] allLogFileNames = logsDir.listFiles();
            boolean noFileFound = true;
            if (allLogFileNames != null) {
                for (File file : allLogFileNames) {
                    fileName = file.getName();
                    if (!file.isFile() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                    instanceLogFileNamesAsString.add(fileName);
                    noFileFound = false;
                }
            }
            if (!noFileFound) return instanceLogFileNamesAsString;
            loggingDir = this.getLoggingDirectoryForNodeWhenNoFilesFound(instanceLogFileDetails, node, sNode, instanceName);
            logsDir = new File(loggingDir);
            for (File file : allLogFileNames = logsDir.listFiles()) {
                fileName = file.getName();
                if (!file.isFile() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                instanceLogFileNamesAsString.add(fileName);
            }
            return instanceLogFileNamesAsString;
        }
        if (!node.getType().equals("SSH")) return instanceLogFileNamesAsString;
        try {
            SSHLauncher sshL = this.getSSHL(habitat);
            sshL.init(node, logger);
            try (SFTPClient sftpClient = sshL.getSFTPClient();){
                Vector instanceLogFileNames;
                boolean noFileFound = true;
                String loggingDir = this.getLoggingDirectoryForNode(instanceLogFileDetails, node, sNode, instanceName);
                try {
                    instanceLogFileNames = sftpClient.getSftpChannel().ls(loggingDir);
                    for (ChannelSftp.LsEntry file : instanceLogFileNames) {
                        if (!this.isAcceptable(file)) continue;
                        instanceLogFileNamesAsString.add(file.getFilename());
                        noFileFound = false;
                    }
                }
                catch (Exception ex) {
                    noFileFound = true;
                }
                if (!noFileFound) return instanceLogFileNamesAsString;
                loggingDir = this.getLoggingDirectoryForNodeWhenNoFilesFound(instanceLogFileDetails, node, sNode, instanceName);
                instanceLogFileNames = sftpClient.getSftpChannel().ls(loggingDir);
                for (ChannelSftp.LsEntry file : instanceLogFileNames) {
                    if (!this.isAcceptable(file)) continue;
                    instanceLogFileNamesAsString.add(file.getFilename());
                }
                return instanceLogFileNamesAsString;
            }
        }
        catch (JSchException ex) {
            throw new IOException("Unable to download instance log file from SSH Node", ex);
        }
        catch (SftpException ex) {
            throw new IOException("Unable to download instance log file from SSH Node", ex);
        }
    }

    private SSHLauncher getSSHL(ServiceLocator habitat) {
        return (SSHLauncher)habitat.getService(SSHLauncher.class, new Annotation[0]);
    }

    private File makingDirectory(String path) {
        File targetDir = new File(path);
        boolean created = false;
        boolean deleted = false;
        if (targetDir.exists() && !(deleted = targetDir.delete())) {
            return targetDir;
        }
        created = targetDir.mkdir();
        if (created) {
            return targetDir;
        }
        return null;
    }

    public String getLoggingDirectoryForNode(String instanceLogFileDirectory, Node node, String sNode, String instanceName) {
        Object loggingDir = "";
        loggingDir = instanceLogFileDirectory.contains("${com.sun.aas.instanceRoot}/logs") && node.getNodeDir() != null ? node.getNodeDir() + File.separator + sNode + File.separator + instanceName + File.separator + "logs" : (instanceLogFileDirectory.contains("${com.sun.aas.instanceRoot}/logs") && node.getInstallDir() != null ? node.getInstallDir() + File.separator + "glassfish" + File.separator + "nodes" + File.separator + sNode + File.separator + instanceName + File.separator + "logs" : instanceLogFileDirectory.substring(0, instanceLogFileDirectory.lastIndexOf(File.separator)));
        return loggingDir;
    }

    public String getLoggingDirectoryForNodeWhenNoFilesFound(String instanceLogFileDirectory, Node node, String sNode, String instanceName) {
        Object loggingDir = "";
        loggingDir = node.getNodeDir() != null ? node.getNodeDir() + File.separator + sNode + File.separator + instanceName + File.separator + "logs" : (node.getInstallDir() != null ? node.getInstallDir() + File.separator + "glassfish" + File.separator + "nodes" + File.separator + sNode + File.separator + instanceName + File.separator + "logs" : instanceLogFileDirectory.substring(0, instanceLogFileDirectory.lastIndexOf(File.separator)));
        return loggingDir;
    }

    private boolean isAcceptable(ChannelSftp.LsEntry file) {
        if (file.getAttrs().isDir()) {
            return false;
        }
        String fileName = file.getFilename();
        return fileName.contains(".log") && !fileName.equals(".") && !fileName.equals("..") && !fileName.contains(".log.");
    }
}

