/*
 * Copyright 2016, Red Hat, Inc., and individual contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.cdi.tck.tests.full.extensions.lifecycle.broken.observerMethod;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.Reception;
import jakarta.enterprise.event.TransactionPhase;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ObserverMethod;

/**
 *
 * @author <a href="mailto:manovotn@redhat.com">Matej Novotny</a>
 */
public class ExtensionAddingCustomObserverMethod implements Extension {

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event) {
        // add custom observer which does not override notify method - should throw exception
        event.addObserverMethod(new ObserverMethod<Foo>() {
            @Override
            public Class<?> getBeanClass() {
                return AfterBeanDiscovery.class;
            }

            @Override
            public Type getObservedType() {
                return Foo.class;
            }

            @Override
            public Set<Annotation> getObservedQualifiers() {
                return Collections.emptySet();
            }

            @Override
            public Reception getReception() {
                return Reception.ALWAYS;
            }

            @Override
            public TransactionPhase getTransactionPhase() {
                return TransactionPhase.IN_PROGRESS;
            }
        });
    }
}
