/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.common.dual;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.dirigible.repository.ext.utils.RequestUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.ClientService;

public class DualParameters {
    private static final Logger logger = Logger.getLogger(DualParameters.class);
    public static final String RUNTIME_URL = "runtimeUrl";
    public static final String SERVICES_URL = "servicesUrl";
    public static final String RUNTIME_URL_DEFAULT = "";
    public static final String SERVICES_URL_DEFAULT = "";
    public static final String HC_LOCAL_HTTP_PORT = "HC_LOCAL_HTTP_PORT";
    public static final String HC_APPLICATION_URL = "HC_APPLICATION_URL";
    public static final String HC_APPLICATION = "HC_APPLICATION";
    public static final String HC_ACCOUNT = "HC_ACCOUNT";
    public static final String HC_REGION = "HC_REGION";
    public static final String HC_HOST = "HC_HOST";
    public static final String GUEST_USER = "guest";

    public static void initSystemParameters() {
        HttpServletRequest req = RWT.getRequest();
        String parameterHC_HOST = System.getProperty(HC_HOST);
        req.getSession().setAttribute(HC_HOST, (Object)parameterHC_HOST);
        String parameterHC_REGION = System.getProperty(HC_REGION);
        req.getSession().setAttribute(HC_REGION, (Object)parameterHC_REGION);
        String parameterHC_ACCOUNT = System.getProperty(HC_ACCOUNT);
        req.getSession().setAttribute(HC_ACCOUNT, (Object)parameterHC_ACCOUNT);
        String parameterHC_APPLICATION = System.getProperty(HC_APPLICATION);
        req.getSession().setAttribute(HC_APPLICATION, (Object)parameterHC_APPLICATION);
        String parameterHC_APPLICATION_URL = System.getProperty(HC_APPLICATION_URL);
        req.getSession().setAttribute(HC_APPLICATION_URL, (Object)parameterHC_APPLICATION_URL);
        String parameterHC_LOCAL_HTTP_PORT = System.getProperty(HC_LOCAL_HTTP_PORT);
        req.getSession().setAttribute(HC_LOCAL_HTTP_PORT, (Object)parameterHC_LOCAL_HTTP_PORT);
    }

    public static String get(String name) {
        String parameter = (String)RWT.getRequest().getSession().getAttribute(name);
        return parameter;
    }

    public static Object getObject(String name) {
        Object parameter = RWT.getRequest().getSession().getAttribute(name);
        return parameter;
    }

    public static void set(String name, String value) {
        RWT.getRequest().getSession().setAttribute(name, (Object)value);
    }

    public static void setObject(String name, Object value) {
        RWT.getRequest().getSession().setAttribute(name, value);
    }

    public static String getRuntimeUrl() {
        String runtimeUrl = DualParameters.get(RUNTIME_URL);
        if (runtimeUrl == null) {
            runtimeUrl = "";
        }
        return runtimeUrl;
    }

    public static String getServicesUrl() {
        String servicesUrl;
        String runtimeUrl = DualParameters.get(RUNTIME_URL);
        if (runtimeUrl == null || "".equals(runtimeUrl)) {
            runtimeUrl = RWT.getRequest().getContextPath();
        }
        if ((servicesUrl = DualParameters.get(SERVICES_URL)) == null) {
            servicesUrl = "";
        }
        return String.valueOf(runtimeUrl) + servicesUrl;
    }

    public static <T extends ClientService> T getService(Class<T> clazz) {
        return (T)RWT.getClient().getService(clazz);
    }

    public static String getContextPath() {
        return RWT.getRequest().getContextPath();
    }

    public static HttpServletRequest getRequest() {
        return RWT.getRequest();
    }

    public static String getUserName() {
        String user = GUEST_USER;
        try {
            user = RWT.getRequest().getRemoteUser();
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        if (user == null && !DualParameters.isRolesEnabled().booleanValue()) {
            user = RequestUtils.getCookieValue((HttpServletRequest)RWT.getRequest(), (String)"dirigible_anonymous_user");
        }
        if (user == null) {
            user = GUEST_USER;
        }
        return user;
    }

    public static Boolean isRolesEnabled() {
        Boolean rolesEnabled = Boolean.parseBoolean(DualParameters.get("enableRoles"));
        return rolesEnabled;
    }

    public static boolean isUserInRole(String role) {
        if (DualParameters.isRolesEnabled().booleanValue()) {
            return RWT.getRequest().isUserInRole(role);
        }
        return true;
    }

    public static String getSessionId() {
        String sessionId = RWT.getRequest().getSession(true).getId();
        return sessionId;
    }

    public static final boolean isRAP() {
        return true;
    }

    public static final boolean isRCP() {
        return false;
    }
}

