/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.bridge;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.ide.bridge.IInjector;

public class InitParametersInjector
implements IInjector {
    public static final String RUNTIME_URL = "runtimeUrl";
    public static final String SERVICES_URL = "servicesUrl";
    public static final String ENABLE_ROLES = "enableRoles";
    public static final String LOG_IN_SYSTEM_OUTPUT = "logInSystemOutput";
    public static final String JNDI_DEFAULT_DATASOURCE = "jndiDefaultDataSource";
    public static final String JNDI_CONNECTIVITY_CONFIGURATION = "jndiConnectivityService";
    public static final String JNDI_MAIL_SESSION = "jndiMailSession";
    public static final String SET_AUTO_COMMIT = "jdbcAutoCommit";

    @Override
    public void injectOnRequest(ServletConfig servletConfig, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Enumeration parameterNames = servletConfig.getInitParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String parameterValue = servletConfig.getInitParameter(parameterName);
            req.getSession().setAttribute(parameterName, (Object)parameterValue);
        }
    }

    @Override
    public void injectOnStart(ServletConfig servletConfig) throws ServletException, IOException {
        Enumeration parameterNames = servletConfig.getInitParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String parameterValue = servletConfig.getInitParameter(parameterName);
            System.getProperties().put(parameterName, parameterValue);
        }
    }

    public static String get(String key) {
        return System.getProperty(key);
    }
}

