/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.comgeneration.implementation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationChannel;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationChannelDestination;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationMediaInfo;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationModel;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.Link;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;

public class Analyzer {
    private CommunicationModel communicationModel;

    public CommunicationModel analyze(Application application) {
        this.communicationModel = new CommunicationModel();
        for (EventConnection connection : application.getFBNetwork().getEventConnections()) {
            this.collectChannels((Connection)connection);
        }
        for (EventConnection connection : application.getFBNetwork().getDataConnections()) {
            this.collectChannels((Connection)connection);
        }
        this.collectMediaInformation();
        return this.communicationModel;
    }

    public void collectChannels(Connection connection) {
        if (connection.getSourceElement().isMapped() && connection.getDestinationElement().isMapped() && connection.getSourceElement().getResource() != connection.getDestinationElement().getResource()) {
            List<Event> sourceEvents = Analyzer.getSourceEvents(connection);
            Resource sourceResource = connection.getSourceElement().getResource();
            Resource destinationResource = connection.getDestinationElement().getResource();
            BlockFBNetworkElement mappedElement = connection.getDestinationElement().getOpposite();
            boolean local = sourceResource.getDevice() == destinationResource.getDevice();
            for (Event sourceEvent : sourceEvents) {
                CommunicationChannel channel = this.getComChannel(local, sourceEvent, connection);
                if (channel == null) continue;
                CommunicationChannelDestination destination = channel.getDestination(destinationResource);
                destination.getConnection().add(connection);
                int portIndex = Analyzer.getPortIndex(connection, sourceEvent);
                List<IInterfaceElement> destinationPortList = destination.getDestinationPorts().get(portIndex);
                if (destinationPortList == null) {
                    destinationPortList = new ArrayList<IInterfaceElement>();
                    destination.getDestinationPorts().put(portIndex, destinationPortList);
                }
                destinationPortList.add(mappedElement.getInterfaceElement(connection.getDestination().getName()));
            }
        }
    }

    private static int getPortIndex(Connection connection, Event sourceEvent) {
        int portIndex = -2;
        if (connection instanceof EventConnection) {
            portIndex = -1;
        } else if (connection instanceof DataConnection) {
            portIndex = 0;
            for (With with : sourceEvent.getWith()) {
                if (with.getVariables().getName().equals(connection.getSource().getName())) break;
                ++portIndex;
            }
        }
        return portIndex;
    }

    private static List<Event> getSourceEvents(Connection connection) {
        ArrayList<Event> sourceEvents = new ArrayList<Event>();
        BlockFBNetworkElement mappedElement = connection.getSourceElement().getOpposite();
        if (connection instanceof EventConnection) {
            sourceEvents.add((Event)mappedElement.getInterfaceElement(connection.getSource().getName()));
        } else if (connection instanceof DataConnection) {
            for (With with : ((VarDeclaration)connection.getSource()).getWiths()) {
                if (!(with.eContainer() instanceof Event)) continue;
                sourceEvents.add((Event)mappedElement.getInterfaceElement(((Event)with.eContainer()).getName()));
            }
        }
        return sourceEvents;
    }

    private CommunicationChannel getComChannel(boolean local, Event sourceEvent, Connection connection) {
        CommunicationChannel channel = this.communicationModel.getChannels().get(sourceEvent);
        if (channel == null) {
            if (connection instanceof EventConnection) {
                channel = new CommunicationChannel();
                channel.setSourceEvent(sourceEvent);
                channel.setLocal(local);
                this.communicationModel.getChannels().put(sourceEvent, channel);
            }
        } else if (!local) {
            channel.setLocal(false);
        }
        return channel;
    }

    private void collectMediaInformation() {
        for (CommunicationChannel channel : this.communicationModel.getChannels().values()) {
            Analyzer.collectMediaInformation(channel);
        }
    }

    private static void collectMediaInformation(CommunicationChannel channel) {
        for (CommunicationChannelDestination destination : channel.getDestinations()) {
            Analyzer.collectMediaInformation(destination);
        }
    }

    private static void collectMediaInformation(CommunicationChannelDestination destination) {
        Device sourceDevice = (Device)destination.getCommunicationChannel().getSourceResource().eContainer();
        Device destinationDevice = (Device)destination.getDestinationResource().eContainer();
        for (Link sourceLink : sourceDevice.getInConnections()) {
            for (Link destinationLink : destinationDevice.getInConnections()) {
                if (sourceLink.getSegment() != destinationLink.getSegment()) continue;
                destination.getAvailableMedia().add(new CommunicationMediaInfo(sourceLink, destinationLink, sourceLink.getSegment()));
            }
        }
    }
}

