/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.commands.CommandUtil;
import org.eclipse.fordiac.ide.application.wizards.AbstractSaveAsWizard;
import org.eclipse.fordiac.ide.application.wizards.SaveAsWizardPage;
import org.eclipse.fordiac.ide.model.commands.change.ToggleSubAppRepresentationCommand;
import org.eclipse.fordiac.ide.model.commands.change.UpdateFBTypeCommand;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.helpers.ModelHelper;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.typemanagement.util.TypeFromTemplateCreator;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class SaveAsSubappWizard
extends AbstractSaveAsWizard {
    private static final String SUBAPP_SECTION = "SUBAPP_SECTION";
    private final SubApp subApp;

    public SaveAsSubappWizard(SubApp subApp, String windowTitle) {
        super(SUBAPP_SECTION);
        this.setWindowTitle(windowTitle);
        this.subApp = subApp;
    }

    public void addPages() {
        IProject project = ModelHelper.getProjectFromContextChecked((EObject)this.subApp);
        StructuredSelection selection = new StructuredSelection((Object)project);
        this.newFilePage = SaveAsWizardPage.createSaveAsSubAppWizardPage(Messages.SaveAsSubApplicationTypeAction_WizardPageName, (IStructuredSelection)selection);
        this.newFilePage.setFileName(this.subApp.getName());
        this.addPage((IWizardPage)this.newFilePage);
    }

    @Override
    public boolean performFinish() {
        if (this.perform()) {
            File template = SaveAsSubappWizard.getSubappTemplate();
            if (template == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.SaveAsSubApplicationTypeAction_TemplateMissingErrorTitle, (String)Messages.SaveAsSubApplicationTypeAction_TemplateMissingErrorMessage);
            } else {
                TypeFromTemplateCreator creator = this.getTypeCreator(template);
                try {
                    this.getContainer().run(true, true, arg_0 -> ((TypeFromTemplateCreator)creator).createTypeFromTemplate(arg_0));
                }
                catch (InvocationTargetException e) {
                    FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                }
                catch (InterruptedException e) {
                    FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                this.preformPostTypeCreationSteps(creator);
            }
        }
        return true;
    }

    private TypeFromTemplateCreator getTypeCreator(File template) {
        return new TypeFromTemplateCreator(this.getTargetTypeFile(), template, this.newFilePage.getPackageName()){

            protected void performTypeSpecificSetup(LibraryElement type) {
                SaveAsSubappWizard.this.performTypeSetup((SubAppType)type);
            }
        };
    }

    private void preformPostTypeCreationSteps(TypeFromTemplateCreator creator) {
        TypeEntry entry = creator.getTypeEntry();
        if (entry != null) {
            if (this.newFilePage.getReplaceSource()) {
                this.replaceWithType(entry);
            }
            if (this.newFilePage.getOpenType()) {
                SaveAsSubappWizard.openTypeEditor(entry);
            }
        }
    }

    private static File getSubappTemplate() {
        File[] fileList = SaveAsSubappWizard.getFilesFromTemplateFolder();
        if (fileList != null) {
            File[] fileArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileName = file.getName().toUpperCase();
                if (fileName.endsWith("SUB")) {
                    return file;
                }
                ++n2;
            }
        }
        return null;
    }

    private static File[] getFilesFromTemplateFolder() {
        String templateFolderPath = Platform.getInstallLocation().getURL().getFile();
        File templateFolder = new File(templateFolderPath + File.separatorChar + "template");
        return templateFolder.listFiles();
    }

    private static void openTypeEditor(TypeEntry entry) {
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(entry.getFile().getName());
        EditorUtils.openEditor((IEditorInput)new FileEditorInput(entry.getFile()), (String)desc.getId());
    }

    private void replaceWithType(TypeEntry entry) {
        CommandUtil.closeOpenedSubApp(this.subApp.getSubAppNetwork());
        IEditorPart currentActiveEditor = EditorUtils.getCurrentActiveEditor();
        if (currentActiveEditor != null) {
            CommandStack commandStack = (CommandStack)currentActiveEditor.getAdapter(CommandStack.class);
            UpdateFBTypeCommand cmd = new UpdateFBTypeCommand((BlockFBNetworkElement)this.subApp, entry);
            if (this.subApp.isUnfolded()) {
                CompoundCommand compoundCmd = new CompoundCommand();
                compoundCmd.add((Command)new ToggleSubAppRepresentationCommand(this.subApp));
                compoundCmd.add((Command)cmd);
                cmd = compoundCmd;
            }
            commandStack.execute((Command)cmd);
        }
    }

    private void performTypeSetup(SubAppType type) {
        this.performInterfaceSetup(type);
        type.setFBNetwork(FBNetworkHelper.copyFBNetWork((FBNetwork)this.subApp.getSubAppNetwork(), (InterfaceList)type.getInterfaceList()));
    }

    private void performInterfaceSetup(SubAppType type) {
        InterfaceList interfaceList = (InterfaceList)EcoreUtil.copy((EObject)this.subApp.getInterface());
        type.setInterfaceList(interfaceList);
    }

    @Override
    protected boolean askOverwrite() {
        return MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.SaveAsSubApplicationTypeAction_WizardOverrideTitle, (String)Messages.SaveAsSubApplicationTypeAction_WizardOverrideMessage);
    }

    @Override
    public IFile getTargetTypeFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(String.valueOf(this.newFilePage.getContainerFullPath()) + File.separator + this.newFilePage.getFileName() + ".SUB"));
    }
}

