/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextalgorithm.util;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.STMethod;
import org.eclipse.fordiac.ide.structuredtextalgorithm.util.STAlgorithmPartition;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCorePartition;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCoreReconciler;

public class STAlgorithmReconciler
implements STCoreReconciler {
    public void reconcile(LibraryElement dest, Optional<? extends STCorePartition> source) {
        if (dest instanceof BaseFBType) {
            STCorePartition sTCorePartition;
            BaseFBType baseFBType = (BaseFBType)dest;
            if (source.isPresent() && (sTCorePartition = source.get()) instanceof STAlgorithmPartition) {
                STAlgorithmPartition algorithmSource = (STAlgorithmPartition)sTCorePartition;
                STAlgorithmReconciler.reconcile((EList<ICallable>)baseFBType.getCallables(), algorithmSource);
            }
        }
    }

    public static void reconcile(EList<ICallable> dest, STAlgorithmPartition source) {
        if (STAlgorithmReconciler.checkDuplicates(source.getCallables())) {
            return;
        }
        if (STAlgorithmReconciler.checkDuplicates(dest)) {
            dest.removeIf(STAlgorithmReconciler::isSTElement);
        }
        dest.removeIf(destAlg -> STAlgorithmReconciler.isSTElement(destAlg) && source.getCallables().stream().noneMatch(sourceAlg -> Objects.equals(sourceAlg.getName(), destAlg.getName())));
        IntStream.range(0, source.getCallables().size()).forEach(index -> {
            ICallable sourceAlg = source.getCallables().get(index);
            Optional<ICallable> candidate = dest.stream().filter(STAlgorithmReconciler::isSTElement).filter(destAlg -> Objects.equals(sourceAlg.getName(), destAlg.getName())).findFirst();
            if (candidate.isPresent() && STAlgorithmReconciler.merge(candidate.get(), sourceAlg)) {
                dest.move(index, (Object)candidate.get());
            } else {
                candidate.ifPresent(arg_0 -> dest.remove(arg_0));
                dest.add(index, (Object)sourceAlg);
            }
        });
    }

    protected static boolean merge(ICallable dest, ICallable source) {
        if (dest instanceof STAlgorithm) {
            STAlgorithm destAlg = (STAlgorithm)dest;
            if (source instanceof STAlgorithm) {
                STAlgorithm sourceAlg = (STAlgorithm)source;
                return STAlgorithmReconciler.merge(destAlg, sourceAlg);
            }
        }
        if (dest instanceof STMethod) {
            STMethod destMethod = (STMethod)dest;
            if (source instanceof STMethod) {
                STMethod sourceMethod = (STMethod)source;
                return STAlgorithmReconciler.merge(destMethod, sourceMethod);
            }
        }
        return false;
    }

    protected static boolean merge(STAlgorithm dest, STAlgorithm source) {
        dest.setComment(source.getComment());
        dest.setText(source.getText());
        return true;
    }

    protected static boolean merge(STMethod dest, STMethod source) {
        dest.setComment(source.getComment());
        dest.setText(source.getText());
        ECollections.setEList((EList)dest.getInputParameters(), source.getInputParameters().stream().map(EcoreUtil::copy).toList());
        ECollections.setEList((EList)dest.getOutputParameters(), source.getOutputParameters().stream().map(EcoreUtil::copy).toList());
        ECollections.setEList((EList)dest.getInOutParameters(), source.getInOutParameters().stream().map(EcoreUtil::copy).toList());
        dest.setReturnType(source.getReturnType());
        return true;
    }

    protected static boolean checkDuplicates(List<? extends ICallable> list) {
        return list.stream().filter(STAlgorithmReconciler::isSTElement).map(INamedElement::getName).distinct().count() != list.stream().filter(STAlgorithmReconciler::isSTElement).count();
    }

    protected static boolean isSTElement(ICallable callable) {
        return callable instanceof STAlgorithm || callable instanceof STMethod;
    }
}

