/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.application.editparts.TargetInterfaceElement;
import org.eclipse.fordiac.ide.application.editparts.TargetInterfaceElementEditPart;
import org.eclipse.fordiac.ide.application.handlers.GotoParentHandler;
import org.eclipse.fordiac.ide.application.widgets.OppositeSelectionDialog;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.HiddenElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.fordiac.ide.ui.preferences.UIPreferenceConstants;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class FollowConnectionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        return Status.CANCEL_STATUS;
    }

    protected static FBNetwork getFBNetwork(IEditorPart editor) {
        FBNetwork network = (FBNetwork)editor.getAdapter(FBNetwork.class);
        if (network == null) {
            FBNetworkElement element = (FBNetworkElement)editor.getAdapter(FBNetworkElement.class);
            if (element instanceof SubApp) {
                SubApp subApp = (SubApp)element;
                return subApp.getSubAppNetwork();
            }
            if (element instanceof CFBInstance) {
                CFBInstance cfbInstance = (CFBInstance)element;
                return cfbInstance.getCfbNetwork();
            }
        }
        return network;
    }

    public void setEnabled(Object evaluationContext) {
        IStructuredSelection structSel;
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        IEditorPart editor = (IEditorPart)HandlerUtil.getVariable((Object)evaluationContext, (String)"activeEditor");
        if (selection instanceof IStructuredSelection && (structSel = (IStructuredSelection)selection).size() == 1) {
            this.setBaseEnabled(editor != null && this.isValidSelectedElement(structSel));
        } else {
            this.setBaseEnabled(false);
        }
    }

    protected boolean isValidSelectedElement(IStructuredSelection structSel) {
        return structSel.getFirstElement() instanceof InterfaceEditPart;
    }

    protected List<IInterfaceElement> getConnectionOposites(InterfaceEditPart iep) {
        IInterfaceElement ie = iep.getModel();
        EList<Connection> connList = this.getConnectionList(ie);
        boolean stepMode = UIPreferenceConstants.STORE.getBoolean("toggleJumpStep");
        if (stepMode) {
            if (this.isLeft()) {
                return connList.stream().map(Connection::getSource).toList();
            }
            return connList.stream().map(Connection::getDestination).toList();
        }
        if (this.useTargetPins(iep)) {
            return FollowConnectionHandler.getTargetPins(iep);
        }
        return connList.stream().map(con -> con.getSource().equals(ie) ? con.getDestination() : con.getSource()).toList();
    }

    protected List<IInterfaceElement> resolveTargetPins(List<IInterfaceElement> opposites, GraphicalViewer viewer) {
        ArrayList<IInterfaceElement> resolvedOpposites = new ArrayList<IInterfaceElement>();
        for (IInterfaceElement element : opposites) {
            EditPart ep = viewer.getEditPartForModel((Object)element);
            if (ep instanceof InterfaceEditPart) {
                InterfaceEditPart iep = (InterfaceEditPart)ep;
                if (FollowConnectionHandler.isExpandedSubappPin(element)) {
                    if (this.useTargetPins(iep)) {
                        resolvedOpposites.addAll(FollowConnectionHandler.getTargetPins(iep));
                        continue;
                    }
                    resolvedOpposites.addAll(this.getConnectionOposites(iep));
                    continue;
                }
            }
            resolvedOpposites.add(element);
        }
        return resolvedOpposites;
    }

    private boolean useTargetPins(InterfaceEditPart iep) {
        return !iep.getChildren().isEmpty() && (iep.getModel().isIsInput() && this.isLeft() || !iep.getModel().isIsInput() && !this.isLeft());
    }

    protected abstract boolean isLeft();

    protected abstract EList<Connection> getConnectionList(IInterfaceElement var1);

    private static List<IInterfaceElement> getTargetPins(InterfaceEditPart iep) {
        ArrayList<IInterfaceElement> result = new ArrayList<IInterfaceElement>();
        for (EditPart ep : iep.getChildren()) {
            Object object;
            Objects.requireNonNull(ep.getModel());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TargetInterfaceElement.GroupTargetInterfaceElement.class, TargetInterfaceElement.class}, (Object)object, n)) {
                case 0: {
                    TargetInterfaceElement.GroupTargetInterfaceElement gtIE = (TargetInterfaceElement.GroupTargetInterfaceElement)object;
                    result.addAll(gtIE.getRefElements());
                    break;
                }
                case 1: {
                    TargetInterfaceElement targetIE = (TargetInterfaceElement)object;
                    result.add(targetIE.getRefElement());
                    break;
                }
            }
        }
        return result;
    }

    protected static boolean isInsideSubappOrViewer(IInterfaceElement ie, FBNetwork fbNetwork) {
        FBNetworkElement fbnElement = ie.getFBNetworkElement();
        return (fbnElement instanceof SubApp || fbnElement instanceof CFBInstance) && !fbNetwork.equals(fbnElement.eContainer());
    }

    private static void showOppositeSelectionDialog(List<IInterfaceElement> opposites, ExecutionEvent event, GraphicalViewer viewer, IInterfaceElement originPin, IEditorPart editor) {
        FollowConnectionHandler.selectInterfaceElement(opposites.getFirst(), editor);
        viewer.flush();
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IFigure figure = ((InterfaceEditPart)selection.getFirstElement()).getFigure();
        OppositeSelectionDialog dialog = new OppositeSelectionDialog(opposites, originPin, viewer.getControl(), figure, editor);
        dialog.open();
    }

    protected IInterfaceElement getInternalOppositePin(ISelection selection) {
        InterfaceEditPart pin = (InterfaceEditPart)((IStructuredSelection)selection).getFirstElement();
        if (this.hasOpposites(pin)) {
            if (pin.isEvent()) {
                return this.getInternalOppositeEventPin(pin);
            }
            if (pin.isVariable()) {
                if (((VarDeclaration)pin.getModel()).isInOutVar()) {
                    return this.getInternalOppositeVarInOutPin(pin);
                }
                return this.getInternalOppositeVarPin(pin);
            }
            return this.getInternalOppositePlugOrSocketPin(pin);
        }
        return null;
    }

    protected abstract IInterfaceElement getInternalOppositeEventPin(InterfaceEditPart var1);

    protected abstract IInterfaceElement getInternalOppositeVarPin(InterfaceEditPart var1);

    protected abstract IInterfaceElement getInternalOppositeVarInOutPin(InterfaceEditPart var1);

    protected abstract IInterfaceElement getInternalOppositePlugOrSocketPin(InterfaceEditPart var1);

    protected boolean hasOpposites(InterfaceEditPart pin) {
        return false;
    }

    protected static void selectOpposites(ExecutionEvent event, GraphicalViewer viewer, IInterfaceElement originPin, List<IInterfaceElement> opposites, IEditorPart editor) {
        if (!opposites.isEmpty()) {
            if (opposites.size() == 1) {
                FollowConnectionHandler.selectInterfaceElement(opposites.getFirst(), editor);
            } else {
                FollowConnectionHandler.showOppositeSelectionDialog(opposites, event, viewer, originPin, editor);
            }
        }
    }

    protected static IInterfaceElement calcInternalOppositePin(EList<? extends IInterfaceElement> source, EList<? extends IInterfaceElement> destination, InterfaceEditPart pin) {
        int sourceIndex = source.stream().filter(HiddenElement::isVisible).toList().indexOf(pin.getModel());
        List<IInterfaceElement> visibleDestinations = destination.stream().filter(HiddenElement::isVisible).toList();
        if (sourceIndex == -1) {
            return visibleDestinations.getFirst();
        }
        if (visibleDestinations.size() - 1 < sourceIndex) {
            return visibleDestinations.get(visibleDestinations.size() - 1);
        }
        return visibleDestinations.get(sourceIndex);
    }

    protected static void gotoParent(ExecutionEvent event) throws ExecutionException {
        GotoParentHandler gotoParentHandler = new GotoParentHandler();
        gotoParentHandler.execute(event);
    }

    protected static boolean isEditorBorderPin(IInterfaceElement ie, FBNetwork fbNetwork) {
        FBNetworkElement fbnElement = ie.getFBNetworkElement();
        FBNetwork containedNetwork = null;
        if (fbnElement instanceof SubApp) {
            SubApp subapp = (SubApp)fbnElement;
            containedNetwork = subapp.getSubAppNetwork();
        } else if (fbnElement instanceof CFBInstance) {
            CFBInstance cfb = (CFBInstance)fbnElement;
            containedNetwork = cfb.getCfbNetwork();
        }
        return containedNetwork != null && containedNetwork.equals(fbNetwork);
    }

    protected static boolean isExpandedSubappPin(IInterfaceElement pin) {
        SubApp subapp;
        FBNetworkElement fBNetworkElement = pin.getFBNetworkElement();
        return fBNetworkElement instanceof SubApp && (subapp = (SubApp)fBNetworkElement).isUnfolded();
    }

    public static void selectInterfaceElement(IInterfaceElement element, IEditorPart editor) {
        GraphicalViewer currentViewer = HandlerHelper.getViewer((IEditorPart)editor);
        if (!HandlerHelper.selectElement((Object)element, (GraphicalViewer)currentViewer)) {
            TargetInterfaceElementEditPart.openInBreadCrumb(element);
        }
    }
}

