---
stage: none
group: unassigned
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Use GitLab

Get to know the GitLab end-to-end workflow. Configure permissions,
organize your work, create and secure your application, and analyze its performance. Report on team productivity throughout the process.

| | | |
|--|--|--|
| [**Manage your organization**](../topics/set_up_organization.md) **{chevron-right}**<br><br>Users, groups, namespaces, SSH keys.| [**Organize work with projects**](../user/project/organize_work_with_projects.md) **{chevron-right}**<br><br>Project visibility, search, badges, layout.| [**Plan and track work**](../topics/plan_and_track.md) **{chevron-right}**<br><br>Epics, issues, milestones, labels.|
| [**Learn Git**](../topics/git/index.md) **{chevron-right}**<br><br>Common commands and workflows. | [**Manage your code**](../topics/manage_code.md) **{chevron-right}**<br><br>Repositories, merge requests, remote development. | [**Use CI/CD to build your application**](../topics/build_your_application.md) **{chevron-right}**<br><br>Runners, jobs, pipelines, variables. |
| [**Secure your application**](../user/application_security/secure_your_application.md) **{chevron-right}**<br><br>Container, dependency, and vulnerability scans. | [**Deploy and release your application**](../topics/release_your_application.md) **{chevron-right}**<br><br>Environments, packages, review apps, GitLab Pages. | [**Manage your infrastructure**](../user/infrastructure/index.md) **{chevron-right}**<br><br>Terraform and Kubernetes deployments. |
| [**Monitor application performance**](../operations/index.md) **{chevron-right}**<br><br>Error tracking, incident management. | [**Monitor runner performance**](https://docs.gitlab.com/runner/monitoring/index.html) **{chevron-right}**<br><br>Prometheus metrics |[**Analyze GitLab usage**](../user/analytics/index.md) **{chevron-right}**<br><br>Instance, group, and project analytics. |
