/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		eval_phrases.lex
Dates:		7 Mar. 2006
Purpose:	Make sure all the phrases are properly parsed.
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |eval_phrases| Grammar.\fbreak
Make sure all the grammar phases are properly parsed.
This is due to my not programming a grammar sequencer 
to explicitly define the syntax of a grammar. 
I wanted to parse each phrase separately
by keyword triggering a descent procedure.\fbreak
\fbreak
Question: What source GPS do u align the error against?
i just place it to the beginning of the grammar file 
if there is no
previous phase seen.
A previous phase becomes the reference point to
the source file. If i was energetic, i should
get the last token of that phase
to be more accurate but today i'm lazy.
The message is adequate to correct the problem.
@/
fsm	
(fsm-id "eval_phrases.lex",fsm-filename eval_phrases,fsm-namespace NS_eval_phrases
,fsm-class Ceval_phrases{
	user-declaration
	public:
	CAbs_lr1_sym* gps_;
	void post_error(CAbs_lr1_sym* Err);
	void post_gps(CAbs_lr1_sym* Sym);
	***
	user-implementation
	void Ceval_phrases::post_error(CAbs_lr1_sym* Err){
	  using namespace NS_yacco2_T_enum;
	  Err->set_rc(*gps_,__FILE__,__LINE__);
	  if(gps_->enumerated_id__ == T_Enum::T_LR1_eog_){
			Err->set_line_no_and_pos_in_line(1,1);
	  }
	    parser__->add_token_to_error_queue(*Err);
	    parser__->set_abort_parse(true); 
	}
/@
@*3 |post_gps|.
@/
	void Ceval_phrases::post_gps(CAbs_lr1_sym* Sym){
	  gps_ = Sym;
	}
	***
	op
	  gps_=0;
	***
}
,fsm-version "1.0",fsm-date "8 Mar. 2006",fsm-debug "true"
,fsm-comments "Evaluate parse phrase sequencer: \n as i use a top / down approach to dispatching the various phrases.")
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Reval_phrases  

/@
Use the property of Rule's sequencing
within a production  to determine whether the 
parsed phrases were missed or out of sequence.
Report them as errors.
@/
(){
  ->  
     Rfsm_phrase 
     Rparallel_phrase  
     RT_enum_phrase  
     Rlr1_k_phrase  
     Rrc_phrase  
     Rterms_phrase 
     Rerr_sym_phrase  
	 Rrules_phrase  
	 eog 
  ->  eog{
  op
  	Ceval_phrases* fsm = (Ceval_phrases*) rule_info__.parser__->fsm_tbl__;
    fsm->post_error(new Err_empty_file);
    fsm->post_gps(sf->p1__);
  ***
  }
}


Rfsm_phrase  (){
  -> "fsm-phrase" {
  op
  	Ceval_phrases* fsm = (Ceval_phrases*) rule_info__.parser__->fsm_tbl__;
    fsm->post_gps(sf->p1__);
  ***
  }
  -> |?|{
  op
   	Ceval_phrases* fsm = (Ceval_phrases*) rule_info__.parser__->fsm_tbl__;
   fsm->post_gps(sf->p1__);
    fsm->post_error(new ERR_no_fsm_phrase);
  ***
  }
}
       
Rparallel_phrase  (){
  -> "parallel-parser-phrase" {
  op
  	Ceval_phrases* fsm = (Ceval_phrases*) rule_info__.parser__->fsm_tbl__;
    fsm->post_gps(sf->p1__);
  ***
  }
  -> 
}
      
RT_enum_phrase  (){
  -> "T-enum-phrase" {
  op
  	Ceval_phrases* fsm = (Ceval_phrases*) rule_info__.parser__->fsm_tbl__;
    fsm->post_gps(sf->p1__);
  ***
  }
  -> |?|{
  op
  	Ceval_phrases* fsm = (Ceval_phrases*) rule_info__.parser__->fsm_tbl__;
    fsm->post_gps(sf->p1__);
     fsm->post_error(new ERR_no_T_enum_phrase);
  ***
  }
}
      
Rerr_sym_phrase  (){
  -> "error-symbols-phrase" {
  op
  	Ceval_phrases* fsm = (Ceval_phrases*) rule_info__.parser__->fsm_tbl__;
    fsm->post_gps(sf->p1__);
  ***
  }
  -> |?|{
  op
  	Ceval_phrases* fsm = (Ceval_phrases*) rule_info__.parser__->fsm_tbl__;
     fsm->post_gps(sf->p1__);
     fsm->post_error(new ERR_no_errors_phrase);
  ***
  }
}

Rrc_phrase  (){
  -> "rc-phrase" {
  op
  	Ceval_phrases* fsm = (Ceval_phrases*) rule_info__.parser__->fsm_tbl__;
    fsm->post_gps(sf->p1__);
  ***
  }
  -> |?|{
  op
  	Ceval_phrases* fsm = (Ceval_phrases*) rule_info__.parser__->fsm_tbl__;
    fsm->post_gps(sf->p1__);
     fsm->post_error(new ERR_no_rc_phrase);
  ***
  }
}

Rlr1_k_phrase  (){
  -> "lr1-k-phrase" {
  op
  	Ceval_phrases* fsm = (Ceval_phrases*) rule_info__.parser__->fsm_tbl__;
    fsm->post_gps(sf->p1__);
  ***
  }
  -> |?|{
  op
  	Ceval_phrases* fsm = (Ceval_phrases*) rule_info__.parser__->fsm_tbl__;
    fsm->post_gps(sf->p1__);
     fsm->post_error(new ERR_no_lrk_phrase);
  ***
  }
}

Rterms_phrase  (){
  -> "terminals-phrase" {
  op
  	Ceval_phrases* fsm = (Ceval_phrases*) rule_info__.parser__->fsm_tbl__;
    fsm->post_gps(sf->p1__);
  ***
  }
  -> |?|{
  op
  	Ceval_phrases* fsm = (Ceval_phrases*) rule_info__.parser__->fsm_tbl__;
    fsm->post_gps(sf->p1__);
     fsm->post_error(new ERR_no_terminals_phrase);
  ***
  }
}

Rrules_phrase  (){
  -> "rules-phrase" {
  op
  	Ceval_phrases* fsm = (Ceval_phrases*) rule_info__.parser__->fsm_tbl__;
    fsm->post_gps(sf->p1__);
  ***
  }
  -> |?| {
  op
  	Ceval_phrases* fsm = (Ceval_phrases*) rule_info__.parser__->fsm_tbl__;
    fsm->post_gps(sf->p1__);
     fsm->post_error(new ERR_no_rules_phrase);
  ***
  }
}
}// end of rules
