/*
 *  option.h : standard option-parse module HEADER
 *             programed by T.IWAI
 */

#ifndef	NO_ARG_TYPE
typedef enum ARG_TYPE {
	BOOLTYPE, INTEGER, LONGINT, STRING, PROCEDURE, LENGTH,
	HIDDEN_BOOLEAN, HIDDEN_INTEGER, HIDDEN_LONGINT, HIDDEN_STRING,
	HIDDEN_PROCEDURE, HIDDEN_LENGTH, SKIP
} ARG_TYPE;

typedef struct {
	char *option;
	ARG_TYPE type;
	void far *var;
	char *message;
	unsigned int init;
	int	def;
	int top;
	int end;
}
ARG_TABLE;
#endif

void set_option(int, char **);
void set_config(char *);
void *SetPara(char *, int);

#define	NULL_STR	"^$"

#define	INIT_ENDCFG		0x0001
#define	INIT_DVIREAD	0x0002
#define INIT_PRINTER	0x0004
#define	INIT_NEWDIM		0x0008

#define	INIT_FONT		0x0030
#define	INIT_CHKFONT	0x0010
#define	INIT_FLSHFONT	0x0020
#define	INIT_VFONT		0x1000

#define	INIT_PIXEL		0x0040

#define	INIT_BUFFER		0x0700
#define	INIT_B_BUF		0x0100
#define	INIT_R_BUF		0x0200
#define	INIT_F_BUF		0x0400

#define	INIT_DECODE		0x0080
#define	INIT_TPIC		0x0800

#define	INIT_HYPER		0x2000
#define	INIT_BUTTON		0x4000
#define	INIT_VDPI		0x8000

#define	INIT_MH			0x10000
#define	INIT_MW			0x20000
#define	INIT_BRIGHT		0x40000
#define	INIT_BMP		0x80000

#define	INIT_METRIC		(INIT_PRINTER|INIT_NEWDIM|INIT_PIXEL|INIT_B_BUF|INIT_DECODE|INIT_TPIC)

#define	INIT_ALL		0xffffffff

/* end of file : option.h */
