/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.FlowLayout;
import com.izforge.izpack.gui.TwoColumnConstraints;
import com.izforge.izpack.gui.TwoColumnLayout;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.panels.PasswordGroup;
import com.izforge.izpack.panels.Processor;
import com.izforge.izpack.panels.RuleInputField;
import com.izforge.izpack.panels.UserInputPanelAutomationHelper;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;

public class UserInputPanel
extends IzPanel {
    private static final long serialVersionUID = 3257850965439886129L;
    private static final int POS_DISPLAYED = 0;
    private static final int POS_TYPE = 1;
    private static final int POS_VARIABLE = 2;
    private static final int POS_CONSTRAINTS = 3;
    private static final int POS_FIELD = 4;
    private static final int POS_PACKS = 5;
    private static final int POS_OS = 6;
    private static final int POS_TRUE = 7;
    private static final int POS_FALSE = 8;
    private static final int POS_MESSAGE = 9;
    private static final int POS_GROUP = 10;
    private static final String SPEC_FILE_NAME = "userInputSpec.xml";
    private static final String LANG_FILE_NAME = "userInputLang.xml";
    private static final String NODE_ID = "panel";
    private static final String FIELD_NODE_ID = "field";
    private static final String INSTANCE_IDENTIFIER = "order";
    private static final String TYPE = "type";
    private static final String DESCRIPTION = "description";
    private static final String VARIABLE = "variable";
    private static final String TEXT = "txt";
    private static final String KEY = "id";
    private static final String SPEC = "spec";
    private static final String SET = "set";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String ALIGNMENT = "align";
    private static final String LEFT = "left";
    private static final String CENTER = "center";
    private static final String RIGHT = "right";
    private static final String TOP = "top";
    private static final String ITALICS = "italic";
    private static final String BOLD = "bold";
    private static final String SIZE = "size";
    private static final String VALIDATOR = "validator";
    private static final String PROCESSOR = "processor";
    private static final String CLASS = "class";
    private static final String FIELD_LABEL = "label";
    private static final String TITLE_FIELD = "title";
    private static final String TEXT_FIELD = "text";
    private static final String TEXT_SIZE = "size";
    private static final String STATIC_TEXT = "staticText";
    private static final String COMBO_FIELD = "combo";
    private static final String COMBO_CHOICE = "choice";
    private static final String COMBO_VALUE = "value";
    private static final String RADIO_FIELD = "radio";
    private static final String RADIO_CHOICE = "choice";
    private static final String RADIO_VALUE = "value";
    private static final String SPACE_FIELD = "space";
    private static final String DIVIDER_FIELD = "divider";
    private static final String CHECK_FIELD = "check";
    private static final String RULE_FIELD = "rule";
    private static final String RULE_LAYOUT = "layout";
    private static final String RULE_SEPARATOR = "separator";
    private static final String RULE_RESULT_FORMAT = "resultFormat";
    private static final String RULE_PLAIN_STRING = "plainString";
    private static final String RULE_DISPLAY_FORMAT = "displayFormat";
    private static final String RULE_SPECIAL_SEPARATOR = "specialSeparator";
    private static final String RULE_ENCRYPTED = "processed";
    private static final String RULE_PARAM_NAME = "name";
    private static final String RULE_PARAM_VALUE = "value";
    private static final String RULE_PARAM = "param";
    private static final String PWD_FIELD = "password";
    private static final String PWD_INPUT = "pwd";
    private static final String PWD_SIZE = "size";
    private static final String SEARCH_FIELD = "search";
    private static final String SEARCH_BUTTON_FIELD = "autodetect";
    private static final String SEARCH_CHOICE = "choice";
    private static final String SEARCH_FILENAME = "filename";
    private static final String SEARCH_RESULT = "result";
    private static final String SEARCH_VALUE = "value";
    private static final String SEARCH_TYPE = "type";
    private static final String SEARCH_FILE = "file";
    private static final String SEARCH_DIRECTORY = "directory";
    private static final String SEARCH_PARENTDIR = "parentdir";
    private static final String SEARCH_CHECKFILENAME = "checkfilename";
    private static final String SELECTEDPACKS = "createForPack";
    private static final String UNSELECTEDPACKS = "createForUnselectedPack";
    protected static final String ATTRIBUTE_CONDITIONID_NAME = "conditionid";
    protected static final String VARIABLE_NODE = "variable";
    protected static final String ATTRIBUTE_VARIABLE_NAME = "name";
    protected static final String ATTRIBUTE_VARIABLE_VALUE = "value";
    private static final String NAME = "name";
    private static final String OS = "os";
    private static final String FAMILY = "family";
    private static int instanceCount = 0;
    protected int instanceNumber = 0;
    private boolean packsDefined = false;
    private InstallerFrame parentFrame;
    private XMLElement spec;
    private boolean haveSpec = false;
    private Vector uiElements = new Vector();
    private Vector buttonGroups = new Vector();
    private Vector passwordGroups = new Vector();
    private Vector passwordGroupsRead = new Vector();
    private Vector searchFields = new Vector();
    private Vector entries = new Vector();
    private LocaleDatabase langpack = null;

    public UserInputPanel(InstallerFrame parent, InstallData installData) {
        super(parent, installData);
        this.instanceNumber = instanceCount++;
        this.parentFrame = parent;
    }

    protected void init() {
        super.removeAll();
        this.uiElements.clear();
        TwoColumnLayout layout = new TwoColumnLayout(10, 5, 30, 25, 0);
        this.setLayout(layout);
        try {
            String resource = "userInputLang.xml_" + this.idata.localeISO3;
            this.langpack = new LocaleDatabase(ResourceManager.getInstance().getInputStream(resource));
        }
        catch (Throwable exception) {
            // empty catch block
        }
        try {
            this.readSpec();
        }
        catch (Throwable exception) {
            exception.printStackTrace();
        }
        if (!this.haveSpec) {
            return;
        }
        this.updateVariables();
        Vector fields = this.spec.getChildrenNamed(FIELD_NODE_ID);
        for (int i = 0; i < fields.size(); ++i) {
            XMLElement field = (XMLElement)fields.elementAt(i);
            String attribute = field.getAttribute("type");
            String conditionid = field.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
            if (conditionid != null && !this.parent.getRules().isConditionTrue(conditionid, this.idata.getVariables()) || attribute == null) continue;
            if (attribute.equals(RULE_FIELD)) {
                this.addRuleField(field);
                continue;
            }
            if (attribute.equals(TEXT_FIELD)) {
                this.addTextField(field);
                continue;
            }
            if (attribute.equals(COMBO_FIELD)) {
                this.addComboBox(field);
                continue;
            }
            if (attribute.equals(RADIO_FIELD)) {
                this.addRadioButton(field);
                continue;
            }
            if (attribute.equals(PWD_FIELD)) {
                this.addPasswordField(field);
                continue;
            }
            if (attribute.equals(SPACE_FIELD)) {
                this.addSpace(field);
                continue;
            }
            if (attribute.equals(DIVIDER_FIELD)) {
                this.addDivider(field);
                continue;
            }
            if (attribute.equals(CHECK_FIELD)) {
                this.addCheckBox(field);
                continue;
            }
            if (attribute.equals(STATIC_TEXT)) {
                this.addText(field);
                continue;
            }
            if (attribute.equals(TITLE_FIELD)) {
                this.addTitle(field);
                continue;
            }
            if (!attribute.equals(SEARCH_FIELD)) continue;
            this.addSearch(field);
        }
    }

    protected void updateUIElements() {
        boolean updated = false;
        VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
        for (int i = 0; i < this.uiElements.size(); ++i) {
            Object[] element = (Object[])this.uiElements.get(i);
            if (element[2] == null) continue;
            String value = this.idata.getVariable((String)element[2]);
            if (RADIO_FIELD.equals(element[1])) {
                JRadioButton choice = (JRadioButton)element[4];
                if (value == null) continue;
                if (value.equals(element[7])) {
                    choice.setSelected(true);
                } else {
                    choice.setSelected(false);
                }
                element[4] = choice;
            } else if (TEXT_FIELD.equals(element[1])) {
                JTextField textf = (JTextField)element[4];
                if (value == null) {
                    value = textf.getText();
                }
                textf.setText(vs.substitute(value, null));
                element[4] = textf;
            } else if (!CHECK_FIELD.equals(element[1]) && !SEARCH_FIELD.equals(element[1]) && RULE_FIELD.equals(element[1])) {
                RuleInputField rulef = (RuleInputField)element[4];
                if (value == null) {
                    value = rulef.getText();
                }
            }
            this.uiElements.set(i, element);
            updated = true;
        }
        if (updated) {
            super.invalidate();
        }
    }

    public boolean isValidated() {
        return this.readInput();
    }

    public void panelActivate() {
        this.init();
        if (this.spec == null) {
            this.emitError("User input specification could not be found.", "The specification for the user input panel could not be found. Please contact the packager.");
            this.parentFrame.skipPanel();
        }
        this.updateUIElements();
        Vector forPacks = this.spec.getChildrenNamed(SELECTEDPACKS);
        Vector forUnselectedPacks = this.spec.getChildrenNamed(UNSELECTEDPACKS);
        Vector forOs = this.spec.getChildrenNamed(OS);
        if (!(this.itemRequiredFor(forPacks) && this.itemRequiredForUnselected(forUnselectedPacks) && this.itemRequiredForOs(forOs))) {
            this.parentFrame.skipPanel();
            return;
        }
        if (!this.haveSpec) {
            this.parentFrame.skipPanel();
            return;
        }
        this.buildUI();
        this.validate();
        if (this.packsDefined) {
            this.parentFrame.lockPrevButton();
        }
    }

    public void makeXMLData(XMLElement panelRoot) {
        HashMap<String, String> entryMap = new HashMap<String, String>();
        for (int i = 0; i < this.entries.size(); ++i) {
            TextValuePair pair = (TextValuePair)this.entries.elementAt(i);
            entryMap.put(pair.toString(), pair.getValue());
        }
        new UserInputPanelAutomationHelper(entryMap).makeXMLData(this.idata, panelRoot);
    }

    private void buildUI() {
        for (int i = 0; i < this.uiElements.size(); ++i) {
            Object[] uiElement = (Object[])this.uiElements.elementAt(i);
            if (this.itemRequiredFor((Vector)uiElement[5]) && this.itemRequiredForOs((Vector)uiElement[6])) {
                try {
                    if (uiElement[0] == null || FALSE.equals(uiElement[0].toString())) {
                        this.add((Component)((JComponent)uiElement[4]), uiElement[3]);
                    }
                    uiElement[0] = true;
                    this.uiElements.remove(i);
                    this.uiElements.add(i, uiElement);
                }
                catch (Throwable exception) {
                    System.out.println("Internal format error in field: " + uiElement[1].toString());
                }
                continue;
            }
            try {
                if (uiElement[0] != null && TRUE.equals(uiElement[0].toString())) {
                    this.remove((JComponent)uiElement[4]);
                }
            }
            catch (Throwable exception) {
                System.out.println("Internal format error in field: " + uiElement[1].toString());
            }
            uiElement[0] = false;
            this.uiElements.remove(i);
            this.uiElements.add(i, uiElement);
        }
    }

    private boolean readInput() {
        String fieldType = null;
        Object[] field = null;
        this.passwordGroupsRead.clear();
        for (int i = 0; i < this.uiElements.size(); ++i) {
            boolean success;
            field = (Object[])this.uiElements.elementAt(i);
            if (field == null || !((Boolean)field[0]).booleanValue()) continue;
            fieldType = (String)field[1];
            if (fieldType.equals(RULE_FIELD) && !(success = this.readRuleField(field))) {
                return false;
            }
            if (!(fieldType.equals(PWD_FIELD) ? !(success = this.readPasswordField(field)) : (fieldType.equals(TEXT_FIELD) ? !(success = this.readTextField(field)) : (fieldType.equals(COMBO_FIELD) ? !(success = this.readComboBox(field)) : (fieldType.equals(RADIO_FIELD) ? !(success = this.readRadioButton(field)) : (fieldType.equals(CHECK_FIELD) ? !(success = this.readCheckBox(field)) : fieldType.equals(SEARCH_FIELD) && !(success = this.readSearch(field)))))))) continue;
            return false;
        }
        return true;
    }

    private void readSpec() throws Exception {
        InputStream input = null;
        String instance = Integer.toString(this.instanceNumber);
        try {
            input = this.parentFrame.getResource(SPEC_FILE_NAME);
        }
        catch (Exception exception) {
            this.haveSpec = false;
            return;
        }
        if (input == null) {
            this.haveSpec = false;
            return;
        }
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(new StdXMLBuilder());
        parser.setValidator(new NonValidator());
        parser.setReader(new StdXMLReader(input));
        XMLElement data = (XMLElement)parser.parse();
        if (data.hasChildren()) {
            Vector specElements = data.getChildrenNamed(NODE_ID);
            for (int i = 0; i < specElements.size(); ++i) {
                data = (XMLElement)specElements.elementAt(i);
                String attribute = data.getAttribute(INSTANCE_IDENTIFIER);
                if (!instance.equals(attribute)) continue;
                this.spec = data;
                input.close();
                this.haveSpec = true;
                return;
            }
            this.haveSpec = false;
            return;
        }
        this.haveSpec = false;
    }

    private void addTitle(XMLElement spec) {
        String title = this.getText(spec);
        boolean italic = this.getBoolean(spec, ITALICS, false);
        boolean bold = this.getBoolean(spec, BOLD, false);
        float multiplier = this.getFloat(spec, "size", 2.0f);
        int justify = this.getAlignment(spec);
        if (title != null) {
            JLabel label = new JLabel(title);
            Font font = label.getFont();
            float size = font.getSize();
            int style = 0;
            if (bold) {
                ++style;
            }
            if (italic) {
                style += 2;
            }
            font = font.deriveFont(style, size * multiplier);
            label.setFont(font);
            label.setAlignmentX(0.0f);
            TwoColumnConstraints constraints = new TwoColumnConstraints();
            constraints.align = justify;
            constraints.position = 9;
            this.add((Component)label, constraints);
        }
    }

    private void addRuleField(XMLElement spec) {
        String separator;
        String set;
        String layout;
        JLabel label;
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        XMLElement element = spec.getFirstChildNamed(SPEC);
        String variable = spec.getAttribute("variable");
        RuleInputField field = null;
        String validator = null;
        String message = null;
        boolean hasParams = false;
        String paramName = null;
        String paramValue = null;
        HashMap<String, String> validateParamMap = null;
        Vector validateParams = null;
        String processor = null;
        int resultFormat = 2;
        if (element != null) {
            label = new JLabel(this.getText(element));
            layout = element.getAttribute(RULE_LAYOUT);
            set = element.getAttribute(SET);
            separator = element.getAttribute(RULE_SEPARATOR);
            String format = element.getAttribute(RULE_RESULT_FORMAT);
            if (format != null) {
                if (format.equals(RULE_PLAIN_STRING)) {
                    resultFormat = 1;
                } else if (format.equals(RULE_DISPLAY_FORMAT)) {
                    resultFormat = 2;
                } else if (format.equals(RULE_SPECIAL_SEPARATOR)) {
                    resultFormat = 3;
                } else if (format.equals(RULE_ENCRYPTED)) {
                    resultFormat = 4;
                }
            }
        } else {
            return;
        }
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs);
        element = spec.getFirstChildNamed(VALIDATOR);
        if (element != null) {
            validator = element.getAttribute(CLASS);
            message = this.getText(element);
            validateParams = element.getChildrenNamed(RULE_PARAM);
            if (validateParams != null && validateParams.size() > 0) {
                hasParams = true;
                if (validateParamMap == null) {
                    validateParamMap = new HashMap<String, String>();
                }
                Iterator it = validateParams.iterator();
                while (it.hasNext()) {
                    element = (XMLElement)it.next();
                    paramName = element.getAttribute("name");
                    paramValue = element.getAttribute("value");
                    validateParamMap.put(paramName, paramValue);
                }
            }
        }
        if ((element = spec.getFirstChildNamed(PROCESSOR)) != null) {
            processor = element.getAttribute(CLASS);
        }
        field = hasParams ? new RuleInputField(layout, set, separator, validator, validateParamMap, processor, resultFormat, this.getToolkit(), this.idata) : new RuleInputField(layout, set, separator, validator, processor, resultFormat, this.getToolkit(), this.idata);
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 15;
        this.uiElements.add(new Object[]{null, FIELD_LABEL, null, constraints, label, forPacks, forOs});
        TwoColumnConstraints constraints2 = new TwoColumnConstraints();
        constraints2.position = 26;
        this.uiElements.add(new Object[]{null, RULE_FIELD, variable, constraints2, field, forPacks, forOs, null, null, message});
    }

    private boolean readRuleField(Object[] field) {
        RuleInputField ruleField = null;
        String variable = null;
        try {
            ruleField = (RuleInputField)field[4];
            variable = (String)field[2];
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || ruleField == null) {
            return true;
        }
        boolean success = ruleField.validateContents();
        if (!success) {
            String message = "";
            try {
                message = this.langpack.getString((String)field[9]);
                if ("".equals(message)) {
                    message = (String)field[9];
                }
            }
            catch (Throwable t) {
                message = (String)field[9];
            }
            JOptionPane.showMessageDialog(this.parentFrame, message, this.parentFrame.langpack.getString("UserInputPanel.error.caption"), 2);
            return false;
        }
        this.idata.setVariable(variable, ruleField.getText());
        this.entries.add(new TextValuePair(variable, ruleField.getText()));
        return true;
    }

    private void addTextField(XMLElement spec) {
        int size;
        String set;
        JLabel label;
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        XMLElement element = spec.getFirstChildNamed(SPEC);
        String variable = spec.getAttribute("variable");
        if (variable == null || variable.length() == 0) {
            return;
        }
        if (element != null) {
            label = new JLabel(this.getText(element));
            set = element.getAttribute(SET);
            if (set == null) {
                set = this.idata.getVariable(variable);
                if (set == null) {
                    set = "";
                }
            } else if (set != null && !"".equals(set)) {
                VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                set = vs.substitute(set, null);
            }
            try {
                size = Integer.parseInt(element.getAttribute("size"));
            }
            catch (Throwable exception) {
                size = 1;
            }
        } else {
            return;
        }
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs);
        JTextField field = new JTextField(set, size);
        field.setCaretPosition(0);
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 15;
        this.uiElements.add(new Object[]{null, FIELD_LABEL, null, constraints, label, forPacks, forOs});
        TwoColumnConstraints constraints2 = new TwoColumnConstraints();
        constraints2.position = 26;
        this.uiElements.add(new Object[]{null, TEXT_FIELD, variable, constraints2, field, forPacks, forOs});
    }

    private boolean readTextField(Object[] field) {
        JTextField textField = null;
        String variable = null;
        String value = null;
        try {
            textField = (JTextField)field[4];
            variable = (String)field[2];
            value = textField.getText();
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || value == null) {
            return true;
        }
        this.idata.setVariable(variable, value);
        this.entries.add(new TextValuePair(variable, value));
        return true;
    }

    private void addComboBox(XMLElement spec) {
        JLabel label;
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        XMLElement element = spec.getFirstChildNamed(SPEC);
        String variable = spec.getAttribute("variable");
        TextValuePair listItem = null;
        JComboBox<TextValuePair> field = new JComboBox<TextValuePair>();
        if (element != null) {
            label = new JLabel(this.getText(element));
            Vector choices = element.getChildrenNamed("choice");
            if (choices == null) {
                return;
            }
            for (int i = 0; i < choices.size(); ++i) {
                String processorClass = ((XMLElement)choices.elementAt(i)).getAttribute(PROCESSOR);
                if (processorClass != null && !"".equals(processorClass)) {
                    String choiceValues = "";
                    try {
                        choiceValues = ((Processor)Class.forName(processorClass).newInstance()).process(null);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    String set = ((XMLElement)choices.elementAt(i)).getAttribute(SET);
                    if (set == null) {
                        set = "";
                    }
                    if (set != null && !"".equals(set)) {
                        VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                        set = vs.substitute(set, null);
                    }
                    StringTokenizer tokenizer = new StringTokenizer(choiceValues, ":");
                    int counter = 0;
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        listItem = new TextValuePair(token, token);
                        field.addItem(listItem);
                        if (set.equals(token)) {
                            field.setSelectedIndex(field.getItemCount() - 1);
                        }
                        ++counter;
                    }
                    continue;
                }
                listItem = new TextValuePair(this.getText((XMLElement)choices.elementAt(i)), ((XMLElement)choices.elementAt(i)).getAttribute("value"));
                field.addItem(listItem);
                String set = ((XMLElement)choices.elementAt(i)).getAttribute(SET);
                if (set == null) continue;
                if (set != null && !"".equals(set)) {
                    VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                    set = vs.substitute(set, null);
                }
                if (!set.equals(TRUE)) continue;
                field.setSelectedIndex(i);
            }
        } else {
            return;
        }
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs);
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 15;
        this.uiElements.add(new Object[]{null, FIELD_LABEL, null, constraints, label, forPacks, forOs});
        TwoColumnConstraints constraints2 = new TwoColumnConstraints();
        constraints2.position = 26;
        this.uiElements.add(new Object[]{null, COMBO_FIELD, variable, constraints2, field, forPacks, forOs});
    }

    private boolean readComboBox(Object[] field) {
        String value;
        String variable;
        try {
            variable = (String)field[2];
            JComboBox comboBox = (JComboBox)field[4];
            value = ((TextValuePair)comboBox.getSelectedItem()).getValue();
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || value == null) {
            return true;
        }
        this.idata.setVariable(variable, value);
        this.entries.add(new TextValuePair(variable, value));
        return true;
    }

    private void addRadioButton(XMLElement spec) {
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        String variable = spec.getAttribute("variable");
        String value = null;
        XMLElement element = null;
        ButtonGroup group = new ButtonGroup();
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 29;
        constraints.indent = true;
        constraints.stretch = true;
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs);
        element = spec.getFirstChildNamed(SPEC);
        if (element != null) {
            Vector choices = element.getChildrenNamed("choice");
            if (choices == null) {
                return;
            }
            for (int i = 0; i < choices.size(); ++i) {
                JRadioButton choice = new JRadioButton();
                choice.setText(this.getText((XMLElement)choices.elementAt(i)));
                value = ((XMLElement)choices.elementAt(i)).getAttribute("value");
                group.add(choice);
                String set = ((XMLElement)choices.elementAt(i)).getAttribute(SET);
                if (set != null) {
                    if (set != null && !"".equals(set)) {
                        VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                        set = vs.substitute(set, null);
                    }
                    if (set.equals(TRUE)) {
                        choice.setSelected(true);
                    }
                }
                this.buttonGroups.add(group);
                this.uiElements.add(new Object[]{null, RADIO_FIELD, variable, constraints, choice, forPacks, forOs, value, null, null, group});
            }
        }
    }

    private boolean readRadioButton(Object[] field) {
        String variable = null;
        String value = null;
        JRadioButton button = null;
        try {
            button = (JRadioButton)field[4];
            if (!button.isSelected()) {
                return true;
            }
            variable = (String)field[2];
            value = (String)field[7];
        }
        catch (Throwable exception) {
            return true;
        }
        this.idata.setVariable(variable, value);
        this.entries.add(new TextValuePair(variable, value));
        return true;
    }

    private void addPasswordField(XMLElement spec) {
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        String variable = spec.getAttribute("variable");
        String validator = null;
        String message = null;
        String processor = null;
        XMLElement element = null;
        PasswordGroup group = null;
        int size = 0;
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs);
        element = spec.getFirstChildNamed(VALIDATOR);
        if (element != null) {
            validator = element.getAttribute(CLASS);
            message = this.getText(element);
        }
        if ((element = spec.getFirstChildNamed(PROCESSOR)) != null) {
            processor = element.getAttribute(CLASS);
        }
        group = new PasswordGroup(validator, processor);
        element = spec.getFirstChildNamed(SPEC);
        if (element != null) {
            Vector inputs = element.getChildrenNamed(PWD_INPUT);
            if (inputs == null) {
                return;
            }
            for (int i = 0; i < inputs.size(); ++i) {
                XMLElement fieldSpec = (XMLElement)inputs.elementAt(i);
                String set = fieldSpec.getAttribute(SET);
                if (set != null && !"".equals(set)) {
                    VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                    set = vs.substitute(set, null);
                }
                JLabel label = new JLabel(this.getText(fieldSpec));
                try {
                    size = Integer.parseInt(fieldSpec.getAttribute("size"));
                }
                catch (Throwable exception) {
                    size = 1;
                }
                JPasswordField field = new JPasswordField(set, size);
                field.setCaretPosition(0);
                TwoColumnConstraints constraints = new TwoColumnConstraints();
                constraints.position = 15;
                this.uiElements.add(new Object[]{null, FIELD_LABEL, null, constraints, label, forPacks, forOs});
                TwoColumnConstraints constraints2 = new TwoColumnConstraints();
                constraints2.position = 26;
                this.uiElements.add(new Object[]{null, PWD_FIELD, variable, constraints2, field, forPacks, forOs, null, null, message, group});
                group.addField(field);
            }
        }
        this.passwordGroups.add(group);
    }

    private boolean readPasswordField(Object[] field) {
        PasswordGroup group = null;
        String variable = null;
        String message = null;
        try {
            group = (PasswordGroup)field[10];
            variable = (String)field[2];
            message = (String)field[9];
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || this.passwordGroupsRead.contains(group)) {
            return true;
        }
        this.passwordGroups.add(group);
        boolean success = group.validateContents();
        if (!success) {
            JOptionPane.showMessageDialog(this.parentFrame, message, this.parentFrame.langpack.getString("UserInputPanel.error.caption"), 2);
            return false;
        }
        this.idata.setVariable(variable, group.getPassword());
        this.entries.add(new TextValuePair(variable, group.getPassword()));
        return true;
    }

    private void addCheckBox(XMLElement spec) {
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        String label = "";
        String set = null;
        String trueValue = null;
        String falseValue = null;
        String variable = spec.getAttribute("variable");
        XMLElement detail = spec.getFirstChildNamed(SPEC);
        if (variable == null) {
            return;
        }
        if (detail != null) {
            label = this.getText(detail);
            set = detail.getAttribute(SET);
            trueValue = detail.getAttribute(TRUE);
            falseValue = detail.getAttribute(FALSE);
        }
        JCheckBox checkbox = new JCheckBox(label);
        if (set != null) {
            if (set != null && !"".equals(set)) {
                VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                set = vs.substitute(set, null);
            }
            if (set.equals(FALSE)) {
                checkbox.setSelected(false);
            }
            if (set.equals(TRUE)) {
                checkbox.setSelected(true);
            }
        }
        XMLElement element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs);
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 29;
        constraints.stretch = true;
        constraints.indent = true;
        this.uiElements.add(new Object[]{null, CHECK_FIELD, variable, constraints, checkbox, forPacks, forOs, trueValue, falseValue});
    }

    private boolean readCheckBox(Object[] field) {
        String variable = null;
        String trueValue = null;
        String falseValue = null;
        JCheckBox box = null;
        try {
            box = (JCheckBox)field[4];
            variable = (String)field[2];
            trueValue = (String)field[7];
            if (trueValue == null) {
                trueValue = "";
            }
            if ((falseValue = (String)field[8]) == null) {
                falseValue = "";
            }
        }
        catch (Throwable exception) {
            return true;
        }
        if (box.isSelected()) {
            this.idata.setVariable(variable, trueValue);
            this.entries.add(new TextValuePair(variable, trueValue));
        } else {
            this.idata.setVariable(variable, falseValue);
            this.entries.add(new TextValuePair(variable, falseValue));
        }
        return true;
    }

    private void addSearch(XMLElement spec) {
        boolean showAutodetect;
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        XMLElement element = spec.getFirstChildNamed(SPEC);
        String variable = spec.getAttribute("variable");
        String filename = null;
        String check_filename = null;
        int search_type = 0;
        int result_type = 0;
        JComboBox<String> combobox = new JComboBox<String>();
        JLabel label = null;
        combobox.setEditable(true);
        if (element != null) {
            String result_type_str;
            label = new JLabel(this.getText(element));
            search_type = 2;
            String search_type_str = element.getAttribute("type");
            if (search_type_str != null) {
                if (search_type_str.equals(SEARCH_FILE)) {
                    search_type = 2;
                } else if (search_type_str.equals(SEARCH_DIRECTORY)) {
                    search_type = 1;
                }
            }
            if ((result_type_str = element.getAttribute(SEARCH_RESULT)) == null) {
                return;
            }
            if (result_type_str.equals(SEARCH_FILE)) {
                result_type = 2;
            } else if (result_type_str.equals(SEARCH_DIRECTORY)) {
                result_type = 1;
            } else if (result_type_str.equals(SEARCH_PARENTDIR)) {
                result_type = 3;
            } else {
                return;
            }
            filename = element.getAttribute(SEARCH_FILENAME);
            check_filename = element.getAttribute(SEARCH_CHECKFILENAME);
            Vector choices = element.getChildrenNamed("choice");
            if (choices == null) {
                return;
            }
            for (int i = 0; i < choices.size(); ++i) {
                XMLElement choice_el = (XMLElement)choices.elementAt(i);
                if (!OsConstraint.oneMatchesCurrentSystem(choice_el)) continue;
                String value = choice_el.getAttribute("value");
                combobox.addItem(value);
                String set = ((XMLElement)choices.elementAt(i)).getAttribute(SET);
                if (set == null) continue;
                if (set != null && !"".equals(set)) {
                    VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                    set = vs.substitute(set, null);
                }
                if (!set.equals(TRUE)) continue;
                combobox.setSelectedIndex(i);
            }
        } else {
            return;
        }
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs);
        TwoColumnConstraints westconstraint1 = new TwoColumnConstraints();
        westconstraint1.position = 15;
        this.uiElements.add(new Object[]{null, FIELD_LABEL, null, westconstraint1, label, forPacks, forOs});
        TwoColumnConstraints eastconstraint1 = new TwoColumnConstraints();
        eastconstraint1.position = 26;
        StringBuffer tooltiptext = new StringBuffer();
        if (filename != null && filename.length() > 0) {
            tooltiptext.append(MessageFormat.format(this.parentFrame.langpack.getString("UserInputPanel.search.location"), filename));
        }
        boolean bl = showAutodetect = check_filename != null && check_filename.length() > 0;
        if (showAutodetect) {
            tooltiptext.append(MessageFormat.format(this.parentFrame.langpack.getString("UserInputPanel.search.location.checkedfile"), check_filename));
        }
        if (tooltiptext.length() > 0) {
            combobox.setToolTipText(tooltiptext.toString());
        }
        this.uiElements.add(new Object[]{null, SEARCH_FIELD, variable, eastconstraint1, combobox, forPacks, forOs});
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(3));
        JButton autodetectButton = ButtonFactory.createButton(this.parentFrame.langpack.getString("UserInputPanel.search.autodetect"), this.idata.buttonsHColor);
        autodetectButton.setVisible(showAutodetect);
        autodetectButton.setToolTipText(this.parentFrame.langpack.getString("UserInputPanel.search.autodetect.tooltip"));
        buttonPanel.add(autodetectButton);
        JButton browseButton = ButtonFactory.createButton(this.parentFrame.langpack.getString("UserInputPanel.search.browse"), this.idata.buttonsHColor);
        buttonPanel.add(browseButton);
        TwoColumnConstraints eastonlyconstraint = new TwoColumnConstraints();
        eastonlyconstraint.position = 27;
        this.uiElements.add(new Object[]{null, SEARCH_BUTTON_FIELD, null, eastonlyconstraint, buttonPanel, forPacks, forOs});
        this.searchFields.add(new SearchField(filename, check_filename, this.parentFrame, combobox, autodetectButton, browseButton, search_type, result_type));
    }

    private boolean readSearch(Object[] field) {
        String variable = null;
        String value = null;
        JComboBox comboBox = null;
        try {
            variable = (String)field[2];
            comboBox = (JComboBox)field[4];
            for (int i = 0; i < this.searchFields.size(); ++i) {
                SearchField sf = (SearchField)this.searchFields.elementAt(i);
                if (!sf.belongsTo(comboBox)) continue;
                value = sf.getResult();
                break;
            }
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || value == null) {
            return true;
        }
        this.idata.setVariable(variable, value);
        this.entries.add(new TextValuePair(variable, value));
        return true;
    }

    private void addText(XMLElement spec) {
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        this.addDescription(spec, forPacks, forOs);
    }

    private void addSpace(XMLElement spec) {
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        JPanel panel = new JPanel();
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 29;
        constraints.stretch = true;
        this.uiElements.add(new Object[]{null, SPACE_FIELD, null, constraints, panel, forPacks, forOs});
    }

    private void addDivider(XMLElement spec) {
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        JPanel panel = new JPanel();
        String alignment = spec.getAttribute(ALIGNMENT);
        if (alignment != null) {
            if (alignment.equals(TOP)) {
                panel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
            } else {
                panel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
            }
        } else {
            panel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
        }
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 29;
        constraints.stretch = true;
        this.uiElements.add(new Object[]{null, DIVIDER_FIELD, null, constraints, panel, forPacks, forOs});
    }

    private void addDescription(XMLElement spec, Vector forPacks, Vector forOs) {
        String description;
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 29;
        constraints.stretch = true;
        if (spec != null && (description = this.getText(spec)) != null) {
            String alignment = spec.getAttribute(ALIGNMENT);
            int justify = 0;
            if (alignment != null) {
                if (alignment.equals(LEFT)) {
                    justify = 0;
                } else if (alignment.equals(CENTER)) {
                    justify = 1;
                } else if (alignment.equals(RIGHT)) {
                    justify = 2;
                }
            }
            JTextPane label = new JTextPane();
            label.setEditable(false);
            if (description.startsWith("<html>") && description.endsWith("</html>")) {
                label.setContentType("text/html");
            }
            label.setText(description);
            label.setBackground(UIManager.getColor("label.backgroud"));
            label.setMargin(new Insets(3, 0, 3, 0));
            this.uiElements.add(new Object[]{null, DESCRIPTION, null, constraints, label, forPacks, forOs});
        }
    }

    private boolean getBoolean(XMLElement element, String attribute, boolean defaultValue) {
        String value;
        boolean result = defaultValue;
        if (attribute != null && attribute.length() > 0 && (value = element.getAttribute(attribute)) != null) {
            if (value.equals(TRUE)) {
                result = true;
            } else if (value.equals(FALSE)) {
                result = false;
            }
        }
        return result;
    }

    private float getFloat(XMLElement element, String attribute, float defaultValue) {
        float result = defaultValue;
        if (attribute != null && attribute.length() > 0) {
            try {
                result = Float.parseFloat(element.getAttribute(attribute));
            }
            catch (Throwable exception) {
                // empty catch block
            }
        }
        return result;
    }

    private String getText(XMLElement element) {
        if (element == null) {
            return null;
        }
        String key = element.getAttribute(KEY);
        String text = null;
        if (key != null && this.langpack != null) {
            try {
                text = this.langpack.getString(key);
            }
            catch (Throwable exception) {
                text = null;
            }
        }
        if (text == null) {
            text = element.getAttribute(TEXT);
        }
        return text;
    }

    private int getAlignment(XMLElement element) {
        int result = 31;
        String value = element.getAttribute(ALIGNMENT);
        if (value != null) {
            if (value.equals(LEFT)) {
                result = 31;
            } else if (value.equals(CENTER)) {
                result = 35;
            } else if (value.equals(RIGHT)) {
                result = 47;
            }
        }
        return result;
    }

    public boolean itemRequiredForOs(Vector os) {
        if (os.size() == 0) {
            return true;
        }
        for (int i = 0; i < os.size(); ++i) {
            String family = ((XMLElement)os.elementAt(i)).getAttribute(FAMILY);
            boolean match = false;
            if ("windows".equals(family)) {
                match = OsVersion.IS_WINDOWS;
            } else if ("mac".equals(family)) {
                match = OsVersion.IS_OSX;
            } else if ("unix".equals(family)) {
                match = OsVersion.IS_UNIX;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    private boolean itemRequiredFor(Vector packs) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String selected = ((Pack)this.idata.selectedPacks.get((int)i)).name;
            for (int k = 0; k < packs.size(); ++k) {
                String required = ((XMLElement)packs.elementAt(k)).getAttribute("name", "");
                if (!selected.equals(required)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean itemRequiredForUnselected(Vector packs) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String selected = ((Pack)this.idata.selectedPacks.get((int)i)).name;
            for (int k = 0; k < packs.size(); ++k) {
                String required = ((XMLElement)packs.elementAt(k)).getAttribute("name", "");
                if (!selected.equals(required)) continue;
                return false;
            }
        }
        return true;
    }

    protected Vector getUiElements() {
        return this.uiElements;
    }

    protected void updateVariables() {
        Vector variables = this.spec.getChildrenNamed("variable");
        RulesEngine rules = this.parent.getRules();
        VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
        for (int i = 0; i < variables.size(); ++i) {
            XMLElement variable = (XMLElement)variables.elementAt(i);
            String vname = variable.getAttribute("name");
            String vvalue = variable.getAttribute("value");
            String conditionid = variable.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
            if (conditionid != null && !rules.isConditionTrue(conditionid, this.idata.getVariables()) || !OsConstraint.oneMatchesCurrentSystem(variable) || vname == null) continue;
            if (vvalue != null) {
                vvalue = vs.substitute(vvalue, null);
                this.idata.setVariable(vname, "");
                vvalue = vs.substitute(vvalue, null);
            }
            this.idata.setVariable(vname, vvalue);
        }
    }

    private class SearchField
    implements ActionListener {
        public static final int TYPE_DIRECTORY = 1;
        public static final int TYPE_FILE = 2;
        public static final int RESULT_DIRECTORY = 1;
        public static final int RESULT_FILE = 2;
        public static final int RESULT_PARENTDIR = 3;
        private String filename = null;
        private String checkFilename = null;
        private JButton autodetectButton = null;
        private JButton browseButton = null;
        private JComboBox pathComboBox = null;
        private int searchType = 1;
        private int resultType = 1;
        private InstallerFrame parent = null;

        public SearchField(String filename, String checkFilename, InstallerFrame parent, JComboBox combobox, JButton autobutton, JButton browsebutton, int search_type, int result_type) {
            this.filename = filename;
            this.checkFilename = checkFilename;
            this.parent = parent;
            this.autodetectButton = autobutton;
            this.browseButton = browsebutton;
            this.pathComboBox = combobox;
            this.searchType = search_type;
            this.resultType = result_type;
            this.autodetectButton.addActionListener(this);
            this.browseButton.addActionListener(this);
            ((JTextField)this.pathComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    this.checkNextButtonState();
                }

                public void insertUpdate(DocumentEvent e) {
                    this.checkNextButtonState();
                }

                public void removeUpdate(DocumentEvent e) {
                    this.checkNextButtonState();
                }

                private void checkNextButtonState() {
                    Document doc = ((JTextField)SearchField.this.pathComboBox.getEditor().getEditorComponent()).getDocument();
                    try {
                        if (SearchField.this.pathMatches(doc.getText(0, doc.getLength()))) {
                            SearchField.this.getInstallerFrame().unlockNextButton(false);
                        } else {
                            SearchField.this.getInstallerFrame().lockNextButton();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
            this.autodetect();
        }

        private InstallerFrame getInstallerFrame() {
            return this.parent;
        }

        public boolean belongsTo(JComboBox combobox) {
            return this.pathComboBox == combobox;
        }

        private boolean pathMatches(String path) {
            if (path != null) {
                File file = null;
                file = this.filename == null || this.searchType == 1 ? new File(path) : new File(path, this.filename);
                if (file.exists() && (this.searchType == 1 && file.isDirectory() || this.searchType == 2 && file.isFile())) {
                    if (this.checkFilename == null) {
                        return true;
                    }
                    file = new File(file, this.checkFilename);
                    return file.exists();
                }
            }
            return false;
        }

        public boolean autodetect() {
            int i;
            Vector<String> items = new Vector<String>();
            String selected = (String)this.pathComboBox.getSelectedItem();
            if (selected == null) {
                this.parent.lockNextButton();
                return false;
            }
            boolean found = false;
            for (int x = 0; x < this.pathComboBox.getItemCount(); ++x) {
                if (!((String)this.pathComboBox.getItemAt(x)).equals(selected)) continue;
                found = true;
            }
            if (!found) {
                this.pathComboBox.addItem(this.pathComboBox.getSelectedItem());
            }
            for (int i2 = 0; i2 < this.pathComboBox.getItemCount(); ++i2) {
                String path = (String)this.pathComboBox.getItemAt(i2);
                if (path.endsWith("*")) {
                    File dir = new File(path = path.substring(0, path.length() - 1));
                    if (!dir.isDirectory()) continue;
                    File[] subdirs = dir.listFiles();
                    for (int x = 0; x < subdirs.length; ++x) {
                        String search = subdirs[x].getAbsolutePath();
                        if (!this.pathMatches(search)) continue;
                        items.add(search);
                    }
                    continue;
                }
                if (!this.pathMatches(path)) continue;
                items.add(path);
            }
            items = new Vector(new HashSet(items));
            this.pathComboBox.removeAllItems();
            VariableSubstitutor vs = new VariableSubstitutor(UserInputPanel.this.idata.getVariables());
            for (i = 0; i < items.size(); ++i) {
                this.pathComboBox.addItem(vs.substitute((String)items.get(i), "plain"));
            }
            for (i = 0; i < this.pathComboBox.getItemCount(); ++i) {
                String path = (String)this.pathComboBox.getItemAt(i);
                if (!this.pathMatches(path)) continue;
                this.pathComboBox.setSelectedIndex(i);
                this.parent.unlockNextButton();
                return true;
            }
            if (this.pathMatches((String)this.pathComboBox.getSelectedItem())) {
                this.parent.unlockNextButton();
                return true;
            }
            this.parent.lockNextButton();
            return false;
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.autodetectButton) {
                if (!this.autodetect()) {
                    JOptionPane.showMessageDialog(this.parent, this.parent.langpack.getString("UserInputPanel.search.autodetect.failed.message"), this.parent.langpack.getString("UserInputPanel.search.autodetect.failed.caption"), 2);
                }
            } else if (event.getSource() == this.browseButton) {
                int result;
                JFileChooser chooser = new JFileChooser();
                if (this.resultType != 2) {
                    chooser.setFileSelectionMode(1);
                }
                if ((result = chooser.showOpenDialog(this.parent)) == 0) {
                    File f = chooser.getSelectedFile();
                    this.pathComboBox.setSelectedItem(f.getAbsolutePath());
                    if (this.resultType != 2 && !this.pathMatches(f.getAbsolutePath())) {
                        JOptionPane.showMessageDialog(this.parent, this.parent.langpack.getString("UserInputPanel.search.wrongselection.message"), this.parent.langpack.getString("UserInputPanel.search.wrongselection.caption"), 2);
                    }
                }
            }
        }

        public String getResult() {
            String item = (String)this.pathComboBox.getSelectedItem();
            if (item != null) {
                item = item.trim();
            }
            String path = item;
            File f = new File(item);
            if (!f.isDirectory()) {
                path = f.getParent();
            }
            if (this.resultType == 1) {
                return path;
            }
            if (this.resultType == 2) {
                if (this.filename != null) {
                    return path + File.separatorChar + this.filename;
                }
                return item;
            }
            if (this.resultType == 3) {
                File dir = new File(path);
                return dir.getParent();
            }
            return null;
        }
    }

    private static class TextValuePair {
        private String text = "";
        private String value = "";

        public TextValuePair(String text, String value) {
            this.text = text;
            this.value = value;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.text;
        }

        public String getValue() {
            return this.value;
        }
    }
}

