/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.clikt.output;

import com.github.ajalt.clikt.mpp.MppImplKt;
import com.github.ajalt.clikt.output.HelpFormatter;
import com.github.ajalt.clikt.output.Localization;
import com.github.ajalt.clikt.output.LocalizationKt;
import com.github.ajalt.clikt.output.TextKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001:\u0001JBe\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000fJ.\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020\u0005H\u0016J\u001e\u0010&\u001a\u00020\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020\u0005H\u0016J\u0016\u0010'\u001a\u00020\u00052\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050)H\u0014J\u0016\u0010*\u001a\u00020\u00072\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0#H\u0002J\u0010\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/H\u0014J\u0010\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0014J$\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00052\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000505H\u0014J\u0010\u00106\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0014J\u0010\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u0005H\u0014J\u0010\u00109\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0014J\u0018\u0010:\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u0005H\u0014J\u0018\u0010=\u001a\u00020\r2\u0006\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u0005H\u0014J\u001e\u0010>\u001a\u00020?*\u00060@j\u0002`A2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0014J\u001e\u0010B\u001a\u00020?*\u00060@j\u0002`A2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0014J\u0018\u0010C\u001a\u00020?*\u00060@j\u0002`A2\u0006\u0010!\u001a\u00020\u0005H\u0014J0\u0010D\u001a\u00020?*\u00060@j\u0002`A2\u0006\u00108\u001a\u00020\u00052\b\u00103\u001a\u0004\u0018\u00010\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020/0#H\u0014J\u001e\u0010E\u001a\u00020?*\u00060@j\u0002`A2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0014J\u0018\u0010F\u001a\u00020?*\u00060@j\u0002`A2\u0006\u0010 \u001a\u00020\u0005H\u0014J&\u0010G\u001a\u00020?*\u00060@j\u0002`A2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020\u0005H\u0014J\u001e\u0010H\u001a\u00020?*\u00060@j\u0002`A2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0#H\u0004J\u0018\u0010I\u001a\u00020?*\u00060@j\u0002`A2\u0006\u00108\u001a\u00020\u0005H\u0002R\u0014\u0010\n\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\t\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u000e\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0018\u0010\u001c\u001a\u00020\u0007*\u00020\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006K"}, d2={"Lcom/github/ajalt/clikt/output/CliktHelpFormatter;", "Lcom/github/ajalt/clikt/output/HelpFormatter;", "localization", "Lcom/github/ajalt/clikt/output/Localization;", "indent", "", "width", "", "maxWidth", "maxColWidth", "colSpacing", "requiredOptionMarker", "showDefaultValues", "", "showRequiredTag", "(Lcom/github/ajalt/clikt/output/Localization;Ljava/lang/String;Ljava/lang/Integer;ILjava/lang/Integer;ILjava/lang/String;ZZ)V", "getColSpacing", "()I", "getIndent", "()Ljava/lang/String;", "getLocalization", "()Lcom/github/ajalt/clikt/output/Localization;", "getMaxColWidth", "getRequiredOptionMarker", "getShowDefaultValues", "()Z", "getShowRequiredTag", "getWidth", "graphemeLength", "getGraphemeLength", "(Ljava/lang/String;)I", "formatHelp", "prolog", "epilog", "parameters", "", "Lcom/github/ajalt/clikt/output/HelpFormatter$ParameterHelp;", "programName", "formatUsage", "joinNamesForOption", "names", "", "measureFirstColumn", "rows", "Lcom/github/ajalt/clikt/output/CliktHelpFormatter$DefinitionRow;", "optionMetavar", "option", "Lcom/github/ajalt/clikt/output/HelpFormatter$ParameterHelp$Option;", "renderArgumentName", "name", "renderHelpText", "help", "tags", "", "renderOptionName", "renderSectionTitle", "title", "renderSubcommandName", "renderTag", "tag", "value", "shouldShowTag", "addArguments", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addCommands", "addEpilog", "addOptionGroup", "addOptions", "addProlog", "addUsage", "appendDefinitionList", "section", "DefinitionRow", "clikt"})
public class CliktHelpFormatter
implements HelpFormatter {
    @NotNull
    private final Localization localization;
    @NotNull
    private final String indent;
    private final int colSpacing;
    @Nullable
    private final String requiredOptionMarker;
    private final boolean showDefaultValues;
    private final boolean showRequiredTag;
    private final int width;
    private final int maxColWidth;

    public CliktHelpFormatter(@NotNull Localization localization, @NotNull String indent, @Nullable Integer width, int maxWidth, @Nullable Integer maxColWidth, int colSpacing, @Nullable String requiredOptionMarker, boolean showDefaultValues, boolean showRequiredTag) {
        int n;
        Intrinsics.checkNotNullParameter(localization, "localization");
        Intrinsics.checkNotNullParameter(indent, "indent");
        this.localization = localization;
        this.indent = indent;
        this.colSpacing = colSpacing;
        this.requiredOptionMarker = requiredOptionMarker;
        this.showDefaultValues = showDefaultValues;
        this.showRequiredTag = showRequiredTag;
        if (width == null) {
            String string = MppImplKt.readEnvvar("COLUMNS");
            int n2 = string != null ? Integer.parseInt(string) : maxWidth;
            n = Math.min(maxWidth, n2);
        } else {
            n = width;
        }
        this.width = n;
        Integer n3 = maxColWidth;
        this.maxColWidth = n3 != null ? n3 : (int)((double)this.width / 2.5);
    }

    public /* synthetic */ CliktHelpFormatter(Localization localization, String string, Integer n, int n2, Integer n3, int n4, String string2, boolean bl, boolean bl2, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 1) != 0) {
            localization = LocalizationKt.getDefaultLocalization();
        }
        if ((n5 & 2) != 0) {
            string = "  ";
        }
        if ((n5 & 4) != 0) {
            n = null;
        }
        if ((n5 & 8) != 0) {
            n2 = 78;
        }
        if ((n5 & 0x10) != 0) {
            n3 = null;
        }
        if ((n5 & 0x20) != 0) {
            n4 = 2;
        }
        if ((n5 & 0x40) != 0) {
            string2 = null;
        }
        if ((n5 & 0x80) != 0) {
            bl = false;
        }
        if ((n5 & 0x100) != 0) {
            bl2 = false;
        }
        this(localization, string, n, n2, n3, n4, string2, bl, bl2);
    }

    @NotNull
    protected final Localization getLocalization() {
        return this.localization;
    }

    @NotNull
    protected final String getIndent() {
        return this.indent;
    }

    protected final int getColSpacing() {
        return this.colSpacing;
    }

    @Nullable
    protected final String getRequiredOptionMarker() {
        return this.requiredOptionMarker;
    }

    protected final boolean getShowDefaultValues() {
        return this.showDefaultValues;
    }

    protected final boolean getShowRequiredTag() {
        return this.showRequiredTag;
    }

    protected final int getWidth() {
        return this.width;
    }

    protected final int getMaxColWidth() {
        return this.maxColWidth;
    }

    @Override
    @NotNull
    public String formatUsage(@NotNull List<? extends HelpFormatter.ParameterHelp> parameters, @NotNull String programName) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        Intrinsics.checkNotNullParameter(programName, "programName");
        StringBuilder $this$formatUsage_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.addUsage($this$formatUsage_u24lambda_u2d0, parameters, programName);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public String formatHelp(@NotNull String prolog, @NotNull String epilog, @NotNull List<? extends HelpFormatter.ParameterHelp> parameters, @NotNull String programName) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(prolog, "prolog");
        Intrinsics.checkNotNullParameter(epilog, "epilog");
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        Intrinsics.checkNotNullParameter(programName, "programName");
        StringBuilder $this$formatHelp_u24lambda_u2d1 = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.addUsage($this$formatHelp_u24lambda_u2d1, parameters, programName);
        this.addProlog($this$formatHelp_u24lambda_u2d1, prolog);
        this.addOptions($this$formatHelp_u24lambda_u2d1, parameters);
        this.addArguments($this$formatHelp_u24lambda_u2d1, parameters);
        this.addCommands($this$formatHelp_u24lambda_u2d1, parameters);
        this.addEpilog($this$formatHelp_u24lambda_u2d1, epilog);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    protected void addUsage(@NotNull StringBuilder $this$addUsage, @NotNull List<? extends HelpFormatter.ParameterHelp> parameters, @NotNull String programName) {
        String usageIndent;
        boolean bl;
        StringBuilder $this$addUsage_u24lambda_u2d5;
        StringBuilder stringBuilder;
        String prog;
        block17: {
            void $this$forEach$iv;
            void $this$filterIsInstanceTo$iv$iv;
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block16: {
                Intrinsics.checkNotNullParameter($this$addUsage, "<this>");
                Intrinsics.checkNotNullParameter(parameters, "parameters");
                Intrinsics.checkNotNullParameter(programName, "programName");
                prog = this.renderSectionTitle(this.localization.usageTitle()) + ' ' + programName;
                $this$addUsage_u24lambda_u2d5 = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$any$iv = parameters;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        HelpFormatter.ParameterHelp it = (HelpFormatter.ParameterHelp)element$iv;
                        boolean bl4 = false;
                        if (!(it instanceof HelpFormatter.ParameterHelp.Option)) continue;
                        bl2 = true;
                        break block16;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                $this$addUsage_u24lambda_u2d5.append(this.localization.optionsMetavar());
            }
            Iterable $this$filterIsInstance$iv = parameters;
            boolean $i$f$filterIsInstance = false;
            Iterator iterator2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof HelpFormatter.ParameterHelp.Argument)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HelpFormatter.ParameterHelp.Argument it = (HelpFormatter.ParameterHelp.Argument)element$iv;
                boolean bl5 = false;
                $this$addUsage_u24lambda_u2d5.append(" ");
                if (!it.getRequired()) {
                    $this$addUsage_u24lambda_u2d5.append("[");
                }
                $this$addUsage_u24lambda_u2d5.append(it.getName());
                if (!it.getRequired()) {
                    $this$addUsage_u24lambda_u2d5.append("]");
                }
                if (!it.getRepeatable()) continue;
                $this$addUsage_u24lambda_u2d5.append("...");
            }
            $this$any$iv = parameters;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    HelpFormatter.ParameterHelp it = (HelpFormatter.ParameterHelp)element$iv;
                    boolean bl6 = false;
                    if (!(it instanceof HelpFormatter.ParameterHelp.Subcommand)) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        if (bl) {
            $this$addUsage_u24lambda_u2d5.append(" ").append(this.localization.commandMetavar());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        String usage = string;
        if (((CharSequence)usage).length() == 0) {
            $this$addUsage.append(prog);
        } else if (this.getGraphemeLength(prog) >= this.width - 20 && this.getGraphemeLength(prog) + this.getGraphemeLength(usage) > this.width - 2) {
            $this$addUsage.append(prog).append("\n");
            usageIndent = StringsKt.repeat(" ", Math.min(this.width / 3, 11));
            TextKt.wrapText(usage, $this$addUsage, this.width, usageIndent, usageIndent);
        } else {
            usageIndent = StringsKt.repeat(" ", prog.length() + 1);
            TextKt.wrapText(usage, $this$addUsage, this.width, prog + ' ', usageIndent);
        }
    }

    protected void addProlog(@NotNull StringBuilder $this$addProlog, @NotNull String prolog) {
        Intrinsics.checkNotNullParameter($this$addProlog, "<this>");
        Intrinsics.checkNotNullParameter(prolog, "prolog");
        if (((CharSequence)prolog).length() > 0) {
            $this$addProlog.append("\n\n");
            TextKt.wrapText(prolog, $this$addProlog, this.width, "  ", "  ");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addOptions(@NotNull StringBuilder $this$addOptions, @NotNull List<? extends HelpFormatter.ParameterHelp> parameters) {
        void $this$forEach$iv;
        Iterable $this$sortedBy$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Intrinsics.checkNotNullParameter($this$addOptions, "<this>");
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        Iterable $this$filterIsInstance$iv = parameters;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof HelpFormatter.ParameterHelp.Group)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            HelpFormatter.ParameterHelp.Group group = (HelpFormatter.ParameterHelp.Group)element$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        Map groupsByName = destination$iv$iv2;
        $this$filterIsInstance$iv = parameters;
        $i$f$filterIsInstance = false;
        Iterable capacity$iv22 = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof HelpFormatter.ParameterHelp.Option)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterIsInstanceTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            HelpFormatter.ParameterHelp.Option it = (HelpFormatter.ParameterHelp.Option)element$iv$iv;
            boolean bl3 = false;
            String key$iv$iv = it.getGroupName();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = MapsKt.toList(destination$iv$iv);
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                boolean bl2 = it.getFirst() == null;
                it = (Pair)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl = false;
                return ComparisonsKt.compareValues(comparable, it.getFirst() == null);
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            StringBuilder stringBuilder;
            CliktHelpFormatter cliktHelpFormatter;
            List params;
            String title;
            block11: {
                block10: {
                    void it;
                    Pair pair2 = (Pair)element$iv;
                    boolean bl = false;
                    title = (String)pair2.component1();
                    params = (List)pair2.component2();
                    cliktHelpFormatter = this;
                    stringBuilder = $this$addOptions;
                    string = title;
                    if (string == null) break block10;
                    String bl3 = string;
                    StringBuilder stringBuilder2 = stringBuilder;
                    CliktHelpFormatter cliktHelpFormatter2 = cliktHelpFormatter;
                    boolean bl4 = false;
                    String string2 = (String)it + ':';
                    cliktHelpFormatter = cliktHelpFormatter2;
                    stringBuilder = stringBuilder2;
                    String string3 = string2;
                    string = string3;
                    if (string3 != null) break block11;
                }
                string = this.localization.optionsTitle();
            }
            HelpFormatter.ParameterHelp.Group group = (HelpFormatter.ParameterHelp.Group)groupsByName.get(title);
            cliktHelpFormatter.addOptionGroup(stringBuilder, string, group != null ? group.getHelp() : null, params);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addOptionGroup(@NotNull StringBuilder $this$addOptionGroup, @NotNull String title, @Nullable String help, @NotNull List<HelpFormatter.ParameterHelp.Option> parameters) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$addOptionGroup, "<this>");
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        Iterable $this$map$iv = parameters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HelpFormatter.ParameterHelp.Option option2 = (HelpFormatter.ParameterHelp.Option)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{this.joinNamesForOption(it.getNames())};
            List<String> names = CollectionsKt.mutableListOf(stringArray);
            if (!((Collection)it.getSecondaryNames()).isEmpty()) {
                ((Collection)names).add(this.joinNamesForOption(it.getSecondaryNames()));
            }
            collection.add(new DefinitionRow(CollectionsKt.joinToString$default(names, " / ", null, this.optionMetavar((HelpFormatter.ParameterHelp.Option)it), 0, null, null, 58, null), this.renderHelpText(it.getHelp(), it.getTags()), it.getTags().containsKey("required") ? this.requiredOptionMarker : null));
        }
        List options = (List)destination$iv$iv;
        if (!((Collection)options).isEmpty()) {
            $this$addOptionGroup.append("\n");
            this.section($this$addOptionGroup, title);
            if (help != null) {
                $this$addOptionGroup.append("\n");
            }
            String string = help;
            if (string != null) {
                TextKt.wrapText(string, $this$addOptionGroup, this.width, "  ", "  ");
            }
            if (help != null) {
                $this$addOptionGroup.append("\n\n");
            }
            this.appendDefinitionList($this$addOptionGroup, options);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addArguments(@NotNull StringBuilder $this$addArguments, @NotNull List<? extends HelpFormatter.ParameterHelp> parameters) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$addArguments, "<this>");
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        Iterable $this$filterIsInstance$iv = parameters;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof HelpFormatter.ParameterHelp.Argument)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HelpFormatter.ParameterHelp.Argument argument2 = (HelpFormatter.ParameterHelp.Argument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DefinitionRow(this.renderArgumentName(it.getName()), this.renderHelpText(it.getHelp(), it.getTags()), null, 4, null));
        }
        List arguments = (List)destination$iv$iv;
        if (!((Collection)arguments).isEmpty()) {
            boolean bl;
            block7: {
                Iterable $this$any$iv = arguments;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DefinitionRow it = (DefinitionRow)element$iv;
                        boolean bl2 = false;
                        boolean bl3 = ((CharSequence)it.getCol2()).length() > 0;
                        if (!bl3) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                $this$addArguments.append("\n");
                this.section($this$addArguments, this.localization.argumentsTitle());
                this.appendDefinitionList($this$addArguments, arguments);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addCommands(@NotNull StringBuilder $this$addCommands, @NotNull List<? extends HelpFormatter.ParameterHelp> parameters) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$addCommands, "<this>");
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        Iterable $this$filterIsInstance$iv = parameters;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof HelpFormatter.ParameterHelp.Subcommand)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HelpFormatter.ParameterHelp.Subcommand subcommand = (HelpFormatter.ParameterHelp.Subcommand)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DefinitionRow(this.renderSubcommandName(it.getName()), this.renderHelpText(it.getHelp(), it.getTags()), null, 4, null));
        }
        List commands = (List)destination$iv$iv;
        if (!((Collection)commands).isEmpty()) {
            $this$addCommands.append("\n");
            this.section($this$addCommands, this.localization.commandsTitle());
            this.appendDefinitionList($this$addCommands, commands);
        }
    }

    protected void addEpilog(@NotNull StringBuilder $this$addEpilog, @NotNull String epilog) {
        Intrinsics.checkNotNullParameter($this$addEpilog, "<this>");
        Intrinsics.checkNotNullParameter(epilog, "epilog");
        if (((CharSequence)epilog).length() > 0) {
            $this$addEpilog.append("\n\n");
            TextKt.wrapText$default(epilog, $this$addEpilog, this.width, null, null, 12, null);
        }
    }

    @NotNull
    protected String renderHelpText(@NotNull String help, @NotNull Map<String, String> tags) {
        Intrinsics.checkNotNullParameter(help, "help");
        Intrinsics.checkNotNullParameter(tags, "tags");
        String renderedTags2 = SequencesKt.joinToString$default(SequencesKt.filter(MapsKt.asSequence(tags), (Function1)new Function1<Map.Entry<? extends String, ? extends String>, Boolean>(this){
            final /* synthetic */ CliktHelpFormatter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<String, String> entry) {
                Intrinsics.checkNotNullParameter(entry, "<name for destructuring parameter 0>");
                String k = entry.getKey();
                String v = entry.getValue();
                return this.this$0.shouldShowTag(k, v);
            }
        }), " ", null, null, 0, null, new Function1<Map.Entry<? extends String, ? extends String>, CharSequence>(this){
            final /* synthetic */ CliktHelpFormatter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Map.Entry<String, String> entry) {
                Intrinsics.checkNotNullParameter(entry, "<name for destructuring parameter 0>");
                String k = entry.getKey();
                String v = entry.getValue();
                return this.this$0.renderTag(k, v);
            }
        }, 30, null);
        return ((CharSequence)renderedTags2).length() == 0 ? help : help + ' ' + renderedTags2;
    }

    protected boolean shouldShowTag(@NotNull String tag, @NotNull String value) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(value, "value");
        String string = tag;
        return Intrinsics.areEqual(string, "default") ? this.showDefaultValues && !StringsKt.isBlank(value) : (Intrinsics.areEqual(string, "required") ? this.showRequiredTag : true);
    }

    @NotNull
    protected String joinNamesForOption(@NotNull Set<String> names) {
        Intrinsics.checkNotNullParameter(names, "names");
        Iterable $this$sortedBy$iv = names;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.joinToString$default(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                String it = (String)a;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(StringsKt.startsWith$default(it, "--", false, 2, null));
                it = (String)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, StringsKt.startsWith$default(it, "--", false, 2, null));
            }
        }), ", ", null, null, 0, null, new Function1<String, CharSequence>(this){
            final /* synthetic */ CliktHelpFormatter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.this$0.renderOptionName(it);
            }
        }, 30, null);
    }

    @NotNull
    protected String renderTag(@NotNull String tag, @NotNull String value) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(value, "value");
        String string = tag;
        String t = Intrinsics.areEqual(string, "default") ? this.localization.helpTagDefault() : (Intrinsics.areEqual(string, "required") ? this.localization.helpTagRequired() : tag);
        return StringsKt.isBlank(value) ? '(' + t + ')' : '(' + t + ": " + value + ')';
    }

    @NotNull
    protected String renderOptionName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return name;
    }

    @NotNull
    protected String renderArgumentName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return name;
    }

    @NotNull
    protected String renderSubcommandName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return name;
    }

    @NotNull
    protected String renderSectionTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter(title, "title");
        return title;
    }

    @NotNull
    protected String optionMetavar(@NotNull HelpFormatter.ParameterHelp.Option option2) {
        Intrinsics.checkNotNullParameter(option2, "option");
        if (option2.getMetavar() == null) {
            return "";
        }
        String metavar = ' ' + option2.getMetavar();
        if (option2.getNvalues() > 1) {
            return metavar + "...";
        }
        return metavar;
    }

    protected final void appendDefinitionList(@NotNull StringBuilder $this$appendDefinitionList, @NotNull List<DefinitionRow> rows) {
        Intrinsics.checkNotNullParameter($this$appendDefinitionList, "<this>");
        Intrinsics.checkNotNullParameter(rows, "rows");
        if (rows.isEmpty()) {
            return;
        }
        int firstWidth = this.measureFirstColumn(rows);
        Iterator<DefinitionRow> iterator2 = rows.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            String string;
            String string2;
            int i = n++;
            DefinitionRow row2 = iterator2.next();
            String col1 = row2.component1();
            String col2 = row2.component2();
            String marker = row2.component3();
            if (i > 0) {
                $this$appendDefinitionList.append("\n");
            }
            CharSequence charSequence = marker;
            if (charSequence == null || charSequence.length() == 0) {
                string2 = this.indent;
            } else {
                CharSequence charSequence2;
                StringBuilder stringBuilder = new StringBuilder().append(marker);
                charSequence = StringsKt.drop(this.indent, this.getGraphemeLength(marker));
                if (charSequence.length() == 0) {
                    StringBuilder stringBuilder2 = stringBuilder;
                    boolean bl = false;
                    charSequence2 = " ";
                    stringBuilder = stringBuilder2;
                } else {
                    charSequence2 = charSequence;
                }
                string2 = stringBuilder.append((String)charSequence2).toString();
            }
            String firstIndent = string2;
            String subsequentIndent = StringsKt.repeat(" ", this.getGraphemeLength(firstIndent) + firstWidth + this.colSpacing);
            if (StringsKt.isBlank(col2)) {
                $this$appendDefinitionList.append(firstIndent).append(col1);
                continue;
            }
            if (this.getGraphemeLength(col1) > this.maxColWidth) {
                $this$appendDefinitionList.append(firstIndent).append(col1).append("\n");
                string = subsequentIndent;
            } else {
                StringBuilder stringBuilder;
                StringBuilder $this$appendDefinitionList_u24lambda_u2d18 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$appendDefinitionList_u24lambda_u2d18.append(firstIndent).append(col1);
                int n2 = firstWidth - this.getGraphemeLength(col1) + this.colSpacing;
                int n3 = 0;
                while (n3 < n2) {
                    int it = n3++;
                    boolean bl2 = false;
                    $this$appendDefinitionList_u24lambda_u2d18.append(" ");
                }
                String string3 = stringBuilder.toString();
                string = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "StringBuilder().apply(builderAction).toString()");
            }
            String initialIndent = string;
            TextKt.wrapText(col2, $this$appendDefinitionList, this.width, initialIndent, subsequentIndent);
        }
    }

    private final int measureFirstColumn(List<DefinitionRow> rows) {
        Object object;
        Object v0;
        Iterable $this$maxByOrNull$iv = rows;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                DefinitionRow it = (DefinitionRow)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = this.getGraphemeLength(it.getCol1());
                do {
                    Object e$iv = iterator$iv.next();
                    DefinitionRow it2 = (DefinitionRow)e$iv;
                    $i$a$-maxByOrNull-CliktHelpFormatter$measureFirstColumn$1 = false;
                    int v$iv = this.getGraphemeLength(it2.getCol1());
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return (object = (DefinitionRow)v0) != null && (object = ((DefinitionRow)object).getCol1()) != null ? RangesKt.coerceAtMost(this.getGraphemeLength((String)object), this.maxColWidth) : this.maxColWidth;
    }

    private final void section(StringBuilder $this$section, String title) {
        $this$section.append("\n").append(this.renderSectionTitle(title)).append("\n");
    }

    protected final int getGraphemeLength(@NotNull String $this$graphemeLength) {
        Intrinsics.checkNotNullParameter($this$graphemeLength, "<this>");
        return MppImplKt.getGraphemeLengthMpp($this$graphemeLength);
    }

    public CliktHelpFormatter() {
        this(null, null, null, 0, null, 0, null, false, false, 511, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/github/ajalt/clikt/output/CliktHelpFormatter$DefinitionRow;", "", "col1", "", "col2", "marker", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCol1", "()Ljava/lang/String;", "getCol2", "getMarker", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "clikt"})
    protected static final class DefinitionRow {
        @NotNull
        private final String col1;
        @NotNull
        private final String col2;
        @Nullable
        private final String marker;

        public DefinitionRow(@NotNull String col1, @NotNull String col2, @Nullable String marker) {
            Intrinsics.checkNotNullParameter(col1, "col1");
            Intrinsics.checkNotNullParameter(col2, "col2");
            this.col1 = col1;
            this.col2 = col2;
            this.marker = marker;
        }

        public /* synthetic */ DefinitionRow(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @NotNull
        public final String getCol1() {
            return this.col1;
        }

        @NotNull
        public final String getCol2() {
            return this.col2;
        }

        @Nullable
        public final String getMarker() {
            return this.marker;
        }

        @NotNull
        public final String component1() {
            return this.col1;
        }

        @NotNull
        public final String component2() {
            return this.col2;
        }

        @Nullable
        public final String component3() {
            return this.marker;
        }

        @NotNull
        public final DefinitionRow copy(@NotNull String col1, @NotNull String col2, @Nullable String marker) {
            Intrinsics.checkNotNullParameter(col1, "col1");
            Intrinsics.checkNotNullParameter(col2, "col2");
            return new DefinitionRow(col1, col2, marker);
        }

        public static /* synthetic */ DefinitionRow copy$default(DefinitionRow definitionRow, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = definitionRow.col1;
            }
            if ((n & 2) != 0) {
                string2 = definitionRow.col2;
            }
            if ((n & 4) != 0) {
                string3 = definitionRow.marker;
            }
            return definitionRow.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "DefinitionRow(col1=" + this.col1 + ", col2=" + this.col2 + ", marker=" + this.marker + ')';
        }

        public int hashCode() {
            int result = this.col1.hashCode();
            result = result * 31 + this.col2.hashCode();
            result = result * 31 + (this.marker == null ? 0 : this.marker.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DefinitionRow)) {
                return false;
            }
            DefinitionRow definitionRow = (DefinitionRow)other;
            if (!Intrinsics.areEqual(this.col1, definitionRow.col1)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.col2, definitionRow.col2)) {
                return false;
            }
            return Intrinsics.areEqual(this.marker, definitionRow.marker);
        }
    }
}

