/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UEllipse;

public class ActorHollow
extends AbstractTextBlock
implements TextBlock {
    private final double headDiam = 9.0;
    private final double bodyWidth = 25.0;
    private final double bodyHeight = 21.0;
    private final double neckHeight = 2.0;
    private final double armThickness = 5.0;
    private final double bodyThickness = 6.0;
    private final double legThickness = 6.0;
    private final Fashion fashion;

    public ActorHollow(Fashion fashion) {
        this.fashion = fashion;
    }

    @Override
    public void drawU(UGraphic ug) {
        UEllipse head = UEllipse.build(9.0, 9.0);
        double centerX = this.getPreferredWidth() / 2.0;
        UPath path = UPath.none();
        path.moveTo(-12.5, 0.0);
        path.lineTo(-12.5, 5.0);
        path.lineTo(-3.0, 5.0);
        path.lineTo(-3.0, 21.0 - (25.0 + 6.0 * Math.sqrt(2.0) - 6.0) / 2.0);
        path.lineTo(-12.5, 21.0 - 6.0 * Math.sqrt(2.0) / 2.0);
        path.lineTo(-(12.5 - 6.0 * Math.sqrt(2.0) / 2.0), 21.0);
        path.lineTo(0.0, 21.0 - (12.5 - 6.0 * Math.sqrt(2.0) / 2.0));
        path.lineTo(12.5 - 6.0 * Math.sqrt(2.0) / 2.0, 21.0);
        path.lineTo(12.5, 21.0 - 6.0 * Math.sqrt(2.0) / 2.0);
        path.lineTo(3.0, 21.0 - (25.0 + 6.0 * Math.sqrt(2.0) - 6.0) / 2.0);
        path.lineTo(3.0, 5.0);
        path.lineTo(12.5, 5.0);
        path.lineTo(12.5, 0.0);
        path.lineTo(-12.5, 0.0);
        path.closePath();
        if (this.fashion.getDeltaShadow() != 0.0) {
            head.setDeltaShadow(this.fashion.getDeltaShadow());
            path.setDeltaShadow(this.fashion.getDeltaShadow());
        }
        ug = this.fashion.apply(ug);
        ug.apply(new UTranslate(centerX - head.getWidth() / 2.0, this.thickness())).draw(head);
        ug.apply(new UTranslate(centerX, head.getHeight() + this.thickness() + 2.0)).draw(path);
    }

    private double thickness() {
        return this.fashion.getStroke().getThickness();
    }

    public double getPreferredWidth() {
        return 25.0 + this.thickness() * 2.0;
    }

    public double getPreferredHeight() {
        return 32.0 + this.thickness() * 2.0 + this.fashion.getDeltaShadow();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(this.getPreferredWidth(), this.getPreferredHeight());
    }
}

