/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.salt.element.AbstractElement;
import net.sourceforge.plantuml.salt.element.ElementMenuEntry;
import net.sourceforge.plantuml.salt.element.ElementMenuPopup;
import net.sourceforge.plantuml.style.ISkinSimple;

public class ElementMenuBar
extends AbstractElement {
    private final Collection<ElementMenuEntry> entries = new ArrayList<ElementMenuEntry>();
    private final Map<ElementMenuEntry, ElementMenuPopup> popups = new HashMap<ElementMenuEntry, ElementMenuPopup>();
    private final UFont font;
    private final ISkinSimple spriteContainer;

    public ElementMenuBar(UFont font, ISkinSimple spriteContainer) {
        this.font = font;
        this.spriteContainer = spriteContainer;
    }

    public void addEntry(String s) {
        this.entries.add(new ElementMenuEntry(s, this.font, this.spriteContainer));
    }

    public void addSubEntry(String s, String sub) {
        ElementMenuPopup popup = this.getPopup(this.getElementMenuEntry(s));
        popup.addEntry(sub);
    }

    private ElementMenuPopup getPopup(ElementMenuEntry s) {
        ElementMenuPopup popup = this.popups.get(s);
        if (popup == null) {
            popup = new ElementMenuPopup(this.font, this.spriteContainer);
            this.popups.put(s, popup);
        }
        return popup;
    }

    private ElementMenuEntry getElementMenuEntry(String n) {
        for (ElementMenuEntry entry : this.entries) {
            if (!entry.getText().equals(n)) continue;
            return entry;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public XDimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        double w = 0.0;
        double h = 0.0;
        for (ElementMenuEntry entry : this.entries) {
            XDimension2D dim = entry.getPreferredDimension(stringBounder, x, y);
            w += dim.getWidth() + 10.0;
            h = Math.max(h, dim.getHeight());
        }
        return new XDimension2D(w, h);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, XDimension2D dimToUse) {
        XDimension2D preferred = this.getPreferredDimension(ug.getStringBounder(), 0.0, 0.0);
        ug = ug.apply(this.getBlack());
        double x1 = 0.0;
        if (zIndex == 0) {
            ug.apply(this.getColorDD().bg()).draw(URectangle.build(dimToUse.getWidth(), dimToUse.getHeight()));
            for (ElementMenuEntry entry : this.entries) {
                entry.drawU(ug.apply(UTranslate.dx(x1)), zIndex, dimToUse);
                double w = entry.getPreferredDimension(ug.getStringBounder(), x1, 0.0).getWidth();
                entry.setX(x1);
                x1 += w + 10.0;
            }
            return;
        }
        if (zIndex == 1) {
            for (ElementMenuEntry entry : this.popups.keySet()) {
                entry.setBackground(this.getColorBB());
            }
            double y1 = preferred.getHeight();
            for (Map.Entry<ElementMenuEntry, ElementMenuPopup> ent : this.popups.entrySet()) {
                ElementMenuPopup p = ent.getValue();
                double xpopup = ent.getKey().getX();
                p.drawU(ug.apply(new UTranslate(xpopup, y1)), zIndex, p.getPreferredDimension(ug.getStringBounder(), xpopup, y1));
            }
        }
    }
}

