/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.StringTokenizer;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandPragma
extends SingleLineCommand2<TitledDiagram> {
    public static final CommandPragma ME = new CommandPragma();

    private CommandPragma() {
        super(CommandPragma.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandPragma.class.getName(), RegexLeaf.start(), new RegexLeaf("!pragma"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "NAME", "([A-Za-z_][A-Za-z_0-9]*)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "VALUE", "(.*)"))), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(TitledDiagram system, LineLocation location, RegexResult arg, ParserPass currentPass) {
        String name = StringUtils.goLowerCase(arg.get("NAME", 0));
        String value = arg.get("VALUE", 0);
        if (name.equalsIgnoreCase("svgsize")) {
            if (value.contains(" ")) {
                StringTokenizer st = new StringTokenizer(value);
                system.getSkinParam().setSvgSize(st.nextToken(), st.nextToken());
            }
        } else {
            system.getPragma().define(name, value);
            if (name.equalsIgnoreCase("graphviz_dot") && value.equalsIgnoreCase("jdot")) {
                return CommandExecutionResult.error("This directive has been renamed to '!pragma layout smetana'. Please update your diagram.");
            }
            if (name.equalsIgnoreCase("graphviz_dot")) {
                return CommandExecutionResult.error("This directive has been renamed to '!pragma layout " + value + "'. Please update your diagram.");
            }
            if (name.equalsIgnoreCase("layout") && value.equalsIgnoreCase("smetana")) {
                system.setUseSmetana(true);
            }
            if (name.equalsIgnoreCase("layout") && value.equalsIgnoreCase("elk")) {
                system.setUseElk(true);
            }
            if (name.equalsIgnoreCase("layout") && value.equalsIgnoreCase("vizjs")) {
                system.getSkinParam().setUseVizJs(true);
            }
        }
        return CommandExecutionResult.ok();
    }
}

