/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Vector;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.OracleKSEntry;
import oracle.security.pki.OracleLocalKeyId;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIECPrivateKey;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1OctetString;
import oracle.security.pki.internal.cert.CertificateRequest;
import oracle.security.pki.internal.cert.X500Name;
import oracle.security.pki.internal.pkcs12.PKCS12Bag;
import oracle.security.pki.internal.pkcs12.PKCS12CertBag;
import oracle.security.pki.internal.pkcs12.PKCS12KeyBag;
import oracle.security.pki.internal.pkcs12.PKCS12SecretBag;
import oracle.security.pki.internal.pkcs12.PKCS12ShroudedKeyBag;

class OracleKSIdentityEntry
extends OracleKSEntry {
    private PKCS12Bag c;
    private Certificate[] d;
    private CertificateRequest e;
    int b = -1;

    OracleKSIdentityEntry(PKCS12Bag pKCS12Bag, Certificate[] certificateArray) {
        this.c = pKCS12Bag;
        this.d = certificateArray;
    }

    OracleKSIdentityEntry(PKCS12Bag pKCS12Bag, Vector vector) {
        byte[] byArray;
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            throw new IllegalArgumentException("Incorrect bag type" + pKCS12Bag);
        }
        this.c = null;
        ASN1Object aSN1Object = ((PKCS12SecretBag)pKCS12Bag).f();
        if (aSN1Object instanceof ASN1OctetString) {
            try {
                byArray = ((ASN1OctetString)aSN1Object).b();
                this.e = new CertificateRequest(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        byArray = pKCS12Bag.c();
        this.b = OracleLocalKeyId.l(byArray);
        Vector<OraclePKIX509CertImpl> vector2 = new Vector<OraclePKIX509CertImpl>(vector.size());
        byte[] byArray2 = OracleLocalKeyId.c(OracleLocalKeyId.k(byArray), OracleLocalKeyId.l(byArray));
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12CertBag pKCS12CertBag = (PKCS12CertBag)vector.elementAt(i);
            if (!this.a(pKCS12CertBag.c(), byArray2)) continue;
            vector2.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.e()));
            vector.removeElementAt(i);
            if (!OraclePKIDebug.getDebugFlag()) break;
            try {
                OraclePKIDebug.a("Found certificate " + pKCS12CertBag.e());
            }
            catch (Exception exception) {
                OraclePKIDebug.a("Found certificate - Cannot be converted to string");
            }
            break;
        }
        if (vector2.size() == 0) {
            OraclePKIDebug.a("No certificate found for cert req " + byArray);
            this.d = null;
        } else {
            X509Certificate x509Certificate = (X509Certificate)vector2.lastElement();
            while (!x509Certificate.getIssuerDN().equals(x509Certificate.getSubjectDN())) {
                boolean bl = false;
                for (int i = 0; i < vector.size(); ++i) {
                    PKCS12CertBag pKCS12CertBag = (PKCS12CertBag)vector.elementAt(i);
                    if (!x509Certificate.getIssuerDN().equals(pKCS12CertBag.e().m())) continue;
                    bl = true;
                    vector2.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.e()));
                    x509Certificate = (X509Certificate)vector2.lastElement();
                    break;
                }
                if (bl) continue;
                OraclePKIDebug.a("Cert chain incomplete for key " + this.c);
                break;
            }
            OraclePKIDebug.a("Cert chain determined");
            this.d = new Certificate[vector2.size()];
            this.d = vector2.toArray(this.d);
        }
    }

    OracleKSIdentityEntry(PKCS12Bag pKCS12Bag, Vector vector, Vector vector2) throws IOException {
        Object object;
        Object object2;
        PKCS12Bag pKCS12Bag2;
        int n;
        Object object3;
        if (!(pKCS12Bag instanceof PKCS12KeyBag) && !(pKCS12Bag instanceof PKCS12ShroudedKeyBag)) {
            throw new IllegalArgumentException("Incorrect bag type" + pKCS12Bag);
        }
        this.c = pKCS12Bag;
        byte[] byArray = this.c.c();
        this.b = OracleLocalKeyId.l(byArray);
        byte[] byArray2 = "abcxyz".getBytes();
        byte[] byArray3 = null;
        String string = null;
        String string2 = null;
        PrivateKey privateKey = null;
        PublicKey publicKey = null;
        if (pKCS12Bag instanceof PKCS12KeyBag) {
            privateKey = ((PKCS12KeyBag)pKCS12Bag).e();
        } else if (pKCS12Bag instanceof PKCS12ShroudedKeyBag) {
            privateKey = ((PKCS12ShroudedKeyBag)pKCS12Bag).g();
        }
        if (privateKey != null) {
            string = privateKey.getAlgorithm();
        }
        if (string != null && string.equals("RSA")) {
            try {
                object3 = JCEUtil.getSignatureInstance("SHA256withRSA");
                ((Signature)object3).initSign(privateKey);
                ((Signature)object3).update(byArray2, 0, byArray2.length);
                byArray3 = ((Signature)object3).sign();
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (OraclePKIDebug.getDebugFlag()) {
                    generalSecurityException.printStackTrace();
                }
                throw new IOException(generalSecurityException.getLocalizedMessage());
            }
        }
        if (string != null && string.equals("EC")) {
            try {
                object3 = JCEUtil.getSignatureInstance("SHA256withECDSA");
                ((Signature)object3).initSign(privateKey);
                ((Signature)object3).update(byArray2, 0, byArray2.length);
                byArray3 = ((Signature)object3).sign();
            }
            catch (GeneralSecurityException generalSecurityException) {
                generalSecurityException.printStackTrace();
            }
        }
        object3 = new Vector(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            block35: {
                n = 0;
                pKCS12Bag2 = (PKCS12CertBag)vector.elementAt(i);
                publicKey = ((PKCS12CertBag)pKCS12Bag2).e().b();
                string2 = publicKey.getAlgorithm();
                if (string.equals(string2)) {
                    if (string2.equals("RSA")) {
                        try {
                            object2 = JCEUtil.getSignatureInstance("SHA256withRSA");
                            ((Signature)object2).initVerify(publicKey);
                            ((Signature)object2).update(byArray2, 0, byArray2.length);
                            n = ((Signature)object2).verify(byArray3) ? 1 : 0;
                            break block35;
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            if (!OraclePKIDebug.getDebugFlag()) continue;
                            generalSecurityException.printStackTrace();
                            continue;
                        }
                    }
                    if (string2.equals("EC")) {
                        try {
                            object2 = JCEUtil.getSignatureInstance("SHA256withECDSA");
                            ((Signature)object2).initVerify(publicKey);
                            ((Signature)object2).update(byArray2, 0, byArray2.length);
                            n = ((Signature)object2).verify(byArray3) ? 1 : 0;
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            generalSecurityException.printStackTrace();
                        }
                    }
                }
            }
            if (this.a(pKCS12Bag2.c(), byArray) && n != 0) {
                ((Vector)object3).addElement(new OraclePKIX509CertImpl(((PKCS12CertBag)pKCS12Bag2).e()));
                vector.removeElementAt(i);
                if (!OraclePKIDebug.getDebugFlag()) break;
                try {
                    OraclePKIDebug.a("Found certificate " + ((PKCS12CertBag)pKCS12Bag2).e());
                }
                catch (Exception exception) {
                    OraclePKIDebug.a("Found certificate - Cannot be converted to string");
                }
                break;
            }
            if (!OracleLocalKeyId.j(byArray)) {
                if (n == 0) continue;
                ((Vector)object3).addElement(new OraclePKIX509CertImpl(((PKCS12CertBag)pKCS12Bag2).e()));
                vector.removeElementAt(i);
                if (!OraclePKIDebug.getDebugFlag()) break;
                try {
                    OraclePKIDebug.a("Found certificate " + ((PKCS12CertBag)pKCS12Bag2).e());
                }
                catch (Exception exception) {
                    OraclePKIDebug.a("Found certificate - Cannot be converted to string");
                }
                break;
            }
            if (OracleLocalKeyId.d(pKCS12Bag2.c()) || n == 0) continue;
            ((Vector)object3).addElement(new OraclePKIX509CertImpl(((PKCS12CertBag)pKCS12Bag2).e()));
            vector.removeElementAt(i);
            if (!OraclePKIDebug.getDebugFlag()) break;
            try {
                OraclePKIDebug.a("Found certificate " + ((PKCS12CertBag)pKCS12Bag2).e());
            }
            catch (Exception exception) {
                OraclePKIDebug.a("Found certificate - Cannot be converted to string");
            }
            break;
        }
        byte[] byArray4 = OracleLocalKeyId.d(OracleLocalKeyId.k(byArray), OracleLocalKeyId.l(byArray));
        for (n = 0; n < vector2.size(); ++n) {
            pKCS12Bag2 = (PKCS12SecretBag)vector2.elementAt(n);
            if (!this.a(pKCS12Bag2.c(), byArray4) || !((object2 = ((PKCS12SecretBag)pKCS12Bag2).f()) instanceof ASN1OctetString)) continue;
            try {
                object = ((ASN1OctetString)object2).b();
                this.e = new CertificateRequest((byte[])object);
                vector2.removeElementAt(n);
                OraclePKIDebug.a("Found cert req " + this.e);
                break;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (((Vector)object3).size() == 0) {
            OraclePKIDebug.a("No certificate found for key " + this.c.c());
            this.d = null;
        } else {
            X509Certificate x509Certificate = (X509Certificate)((Vector)object3).lastElement();
            while (!x509Certificate.getIssuerDN().equals(x509Certificate.getSubjectDN())) {
                boolean bl = false;
                for (int i = 0; i < vector.size(); ++i) {
                    object = (PKCS12CertBag)vector.elementAt(i);
                    if (!x509Certificate.getIssuerDN().equals(((PKCS12CertBag)object).e().m())) continue;
                    bl = true;
                    ((Vector)object3).addElement(new OraclePKIX509CertImpl(((PKCS12CertBag)object).e()));
                    x509Certificate = (X509Certificate)((Vector)object3).lastElement();
                    break;
                }
                if (bl) continue;
                OraclePKIDebug.a("Cert chain incomplete for key " + this.c);
                break;
            }
            OraclePKIDebug.a("Cert chain determined");
            this.d = new Certificate[((Vector)object3).size()];
            this.d = ((Vector)object3).toArray(this.d);
        }
    }

    String a(byte[] byArray) {
        return new String("personaNum:" + OracleLocalKeyId.k(byArray) + "  componentNum:" + OracleLocalKeyId.l(byArray));
    }

    Key g() {
        PrivateKey privateKey = null;
        if (this.c instanceof PKCS12KeyBag) {
            privateKey = ((PKCS12KeyBag)this.c).e();
        } else if (this.c instanceof PKCS12ShroudedKeyBag) {
            privateKey = ((PKCS12ShroudedKeyBag)this.c).g();
        }
        if (privateKey instanceof RSAPrivateCrtKey) {
            return new OraclePKIRSAPrivateKey((RSAPrivateCrtKey)privateKey, this.e);
        }
        if (privateKey instanceof ECPrivateKey) {
            return new OraclePKIECPrivateKey((ECPrivateKey)privateKey, this.e);
        }
        if (this.e != null && this.c == null) {
            return new OraclePKIRSAPrivateKey(null, this.e);
        }
        return null;
    }

    @Override
    Certificate f() {
        if (this.d == null) {
            return null;
        }
        return this.d[0];
    }

    @Override
    Certificate[] e() {
        if (this.d == null) {
            return null;
        }
        return (Certificate[])this.d.clone();
    }

    @Override
    boolean d() {
        return true;
    }

    @Override
    String b() {
        String string = null;
        Certificate certificate = this.f();
        if (certificate instanceof X509Certificate) {
            OraclePKIDebug.a("Certificate for private key is " + certificate);
            X500Name x500Name = new X500Name(((X509Certificate)certificate).getSubjectDN().getName());
            string = "CN=" + x500Name.f();
            if (x500Name.f() == null) {
                string = "OU=" + x500Name.e();
            }
            return string;
        }
        return "";
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        if (byArray == null | byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    byte[] h() {
        if (this.c == null) {
            return null;
        }
        return this.c.c();
    }

    int i() {
        return this.b;
    }
}

