/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

public class InvokeDynamicSupport {
    public static boolean methodMissing(CacheEntry entry, CallType callType, String name2, IRubyObject caller2) {
        DynamicMethod method2 = entry.method;
        return method2.isUndefined() || callType == CallType.NORMAL && !name2.equals("method_missing") && !method2.isCallableFrom(caller2, callType);
    }

    public static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2) {
        return Helpers.selectMethodMissing(context, self2, entry.method.getVisibility(), name2, callType).call(context, self2, (RubyModule)self2.getMetaClass(), name2, arg2, Block.NULL_BLOCK);
    }

    public static RubyClass pollAndGetClass(ThreadContext context, IRubyObject self2) {
        context.callThreadPoll();
        return RubyBasicObject.getMetaClass(self2);
    }

    public static MethodHandle findStatic(Class target2, String name2, MethodType type2) {
        try {
            return MethodHandles.lookup().findStatic(target2, name2, type2);
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static MethodHandle findVirtual(Class target2, String name2, MethodType type2) {
        try {
            return MethodHandles.lookup().findVirtual(target2, name2, type2);
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
    }
}

