/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import org.jruby.api.Access;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class BuiltinClass
extends Operand {
    private final Type type;

    public BuiltinClass(Type type2) {
        this.type = type2;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.BUILTIN_CLASS;
    }

    public String toString() {
        return "<Class:" + String.valueOf((Object)this.type) + ">";
    }

    @Override
    public boolean canCopyPropagate() {
        return true;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
    }

    @Override
    public Operand cloneForInlining(CloneInfo ii) {
        return this;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.type.ordinal());
    }

    public static BuiltinClass decode(IRReaderDecoder d) {
        Type type2 = Type.fromOrdinal(d.decodeInt());
        return switch (type2.ordinal()) {
            case 1 -> d.getCurrentScope().getManager().getArrayClass();
            case 2 -> d.getCurrentScope().getManager().getHashClass();
            case 0 -> d.getCurrentScope().getManager().getObjectClass();
            case 3 -> d.getCurrentScope().getManager().getSymbolClass();
            default -> throw new RuntimeException("BuiltinClass has unknown type");
        };
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        return switch (this.type.ordinal()) {
            case 1 -> Access.arrayClass(context);
            case 2 -> Access.hashClass(context);
            case 0 -> Access.objectClass(context);
            case 3 -> Access.symbolClass(context);
            default -> throw new RuntimeException("BuiltinClass has unknown type");
        };
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BuiltinClass(this);
    }

    public static enum Type {
        OBJECT,
        ARRAY,
        HASH,
        SYMBOL;


        public static Type fromOrdinal(int value2) {
            return value2 < 0 || value2 >= Type.values().length ? null : Type.values()[value2];
        }
    }
}

